/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.mevenide.genapp.TemplateInfo;
import org.openide.WizardDescriptor;

public class GenAppPropsVisual
extends JPanel {
    private TemplateInfo current;
    private Model currentModel;
    private JScrollPane jScrollPane1;
    private JLabel lblProps;
    private JTable tblProps;
    static /* synthetic */ Class class$java$lang$String;

    public GenAppPropsVisual() {
        this.initComponents();
        this.setName("Template's Properties");
        this.putClientProperty("NewProjectWizard_Title", "New Maven GenApp project");
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return true;
    }

    void read(WizardDescriptor d) {
        TemplateInfo templ = (TemplateInfo)d.getProperty("gatemplate");
        if (this.current == null || !this.current.getName().equals(templ.getName())) {
            this.current = templ;
            this.loadModel();
            for (int i = 0; i < this.currentModel.getRowCount(); ++i) {
                PropWrapper row = this.currentModel.getRow(i);
                if ("id".equals(row.getProperty())) {
                    String val = (String)d.getProperty("property.id");
                    this.currentModel.setValueAt(val, i, 1);
                }
                d.putProperty("property." + row.getProperty(), null);
            }
        } else {
            for (int i = 0; i < this.currentModel.getRowCount(); ++i) {
                PropWrapper row = this.currentModel.getRow(i);
                String val = (String)d.getProperty("property." + row.getProperty());
                if (val == null) continue;
                this.currentModel.setValueAt(val, i, 1);
            }
        }
    }

    void store(WizardDescriptor d) {
        for (int i = 0; i < this.currentModel.getRowCount(); ++i) {
            PropWrapper row = this.currentModel.getRow(i);
            d.putProperty("property." + row.getProperty(), (Object)row.getValue());
        }
    }

    private void loadModel() {
        ArrayList<PropWrapper> lst = new ArrayList<PropWrapper>();
        String[] params = this.current.getParameters();
        for (int i = 0; i < params.length; ++i) {
            PropWrapper wr = new PropWrapper(this.current, params[i], this.current.getDefaultValue(params[i]));
            wr.setValue(this.current.getDefaultValue(params[i]));
            lst.add(wr);
        }
        this.currentModel = new Model(lst);
        this.tblProps.setModel(this.currentModel);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tblProps = new JTable();
        this.lblProps = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(200, 200));
        this.tblProps.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblProps);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblProps.setLabelFor(this.tblProps);
        this.lblProps.setText("Template's properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblProps, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        this.tblProps.requestFocus();
    }

    private class Model
    implements TableModel,
    TableCellRenderer {
        private List rows;
        private DefaultTableCellRenderer delegate = new DefaultTableCellRenderer();
        private List listeners;

        public Model(List rowlist) {
            this.rows = rowlist;
            this.listeners = new ArrayList();
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1) {
                PropWrapper rw = (PropWrapper)this.rows.get(row);
                rw.setValue((String)aValue);
                this.fireTableChanged(new TableModelEvent(this, row, row, column));
            }
        }

        private void fireTableChanged(TableModelEvent event) {
            TableModelListener[] lst = new TableModelListener[this.listeners.size()];
            lst = this.listeners.toArray(lst);
            for (int i = 0; i < lst.length; ++i) {
                lst[i].tableChanged(event);
            }
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Prompt";
            }
            if (column == 1) {
                return "Value";
            }
            return "XXX";
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = GenAppPropsVisual.class$("java.lang.String")) : class$java$lang$String;
        }

        public PropWrapper getRow(int row) {
            return (PropWrapper)this.rows.get(row);
        }

        public Object getValueAt(int row, int column) {
            PropWrapper rowObj = (PropWrapper)this.rows.get(row);
            if (column == 0) {
                String str = rowObj.getInfo().getPromptText(rowObj.getProperty());
                return str != null ? str : rowObj.getProperty();
            }
            if (column == 1) {
                return rowObj.getValue();
            }
            return "";
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Component com = this.delegate.getTableCellRendererComponent(jTable, obj, isSelected, hasFocus, row, column);
            if (com instanceof JLabel && column == 0) {
                JLabel lbl = (JLabel)com;
                PropWrapper wr = (PropWrapper)this.rows.get(row);
                lbl.setBackground(UIManager.getColor("Label.background"));
            }
            return com;
        }
    }

    private static class PropWrapper {
        private TemplateInfo info;
        private String prop;
        private String value;
        private String name;

        PropWrapper(TemplateInfo i, String property, String displayName) {
            this.info = i;
            this.prop = property;
            this.name = displayName;
        }

        public TemplateInfo getInfo() {
            return this.info;
        }

        public String getProperty() {
            return this.prop;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String val) {
            this.value = val;
        }

        public String getDisplayName() {
            return this.name;
        }
    }
}

