/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.mevenide.context.DefaultQueryContext;
import org.mevenide.genapp.GenAppTemplateFinder;
import org.mevenide.genapp.TemplateInfo;
import org.mevenide.netbeans.project.wizards.GenAppTemplatePanel;
import org.openide.WizardDescriptor;

public class GenAppTemplateVisual
extends JPanel
implements DocumentListener {
    private GenAppTemplatePanel panel;
    private GenAppTemplateFinder finder;
    private JButton btnBrowse;
    private JSeparator jSeparator1;
    private JLabel lblFolder;
    private JLabel lblProjectDir;
    private JLabel lblProjectName;
    private JLabel lblTemplateList;
    private JPanel locationContainer;
    private JList lstTemplateList;
    private JPanel optionsContainer;
    private JTextField txtFolder;
    private JTextField txtProjectDir;
    private JTextField txtProjectName;

    public GenAppTemplateVisual(GenAppTemplatePanel pnl) {
        this.panel = pnl;
        this.initComponents();
        this.txtProjectName.getDocument().addDocumentListener(this);
        this.txtProjectDir.getDocument().addDocumentListener(this);
        this.finder = new GenAppTemplateFinder(DefaultQueryContext.getNonProjectContextInstance());
        this.setName("Name and Location");
        this.putClientProperty("NewProjectWizard_Title", "New Maven GenApp project");
        TemplateInfo[] infos = this.finder.getTemplates("All");
        DefaultListModel<ListWrapper> model = new DefaultListModel<ListWrapper>();
        if (infos != null) {
            Iterator<TemplateInfo> it = Arrays.asList(infos).iterator();
            while (it.hasNext()) {
                model.addElement(new ListWrapper(it.next()));
            }
        }
        this.lstTemplateList.setModel(model);
        this.lstTemplateList.setSelectionMode(0);
        this.lstTemplateList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GenAppTemplateVisual.this.panel.fireChangeEvent();
            }
        });
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.txtProjectName.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Name is not valid folder name.");
            return false;
        }
        File destFolder = new File(this.txtFolder.getText());
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Folder already exists and is not empty.");
            return false;
        }
        if (this.lstTemplateList.getSelectedIndex() == -1) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"You need to select a template from the list.");
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void read(WizardDescriptor d) {
        String val = (String)d.getProperty("artifactID");
        this.txtProjectName.setText(val != null ? val : "");
        val = (String)d.getProperty("projectDir");
        this.txtProjectDir.setText(val != null ? val : "");
        ListWrapper wr = (ListWrapper)d.getProperty("xxxtemplate");
        if (wr != null) {
            this.lstTemplateList.setSelectedValue(wr, true);
        }
    }

    void store(WizardDescriptor d) {
        d.putProperty("artifactID", (Object)this.txtProjectName.getText());
        d.putProperty("property.id", (Object)this.txtProjectName.getText());
        d.putProperty("projectDir", (Object)this.txtProjectDir.getText());
        d.putProperty("finder", (Object)this.finder);
        ListWrapper wr = (ListWrapper)this.lstTemplateList.getSelectedValue();
        d.putProperty("gatemplate", (Object)wr.getInfo());
        d.putProperty("xxxtemplate", this.lstTemplateList.getSelectedValue());
    }

    private void initComponents() {
        this.locationContainer = new JPanel();
        this.lblProjectName = new JLabel();
        this.txtProjectName = new JTextField();
        this.lblProjectDir = new JLabel();
        this.txtProjectDir = new JTextField();
        this.lblFolder = new JLabel();
        this.txtFolder = new JTextField();
        this.btnBrowse = new JButton();
        this.jSeparator1 = new JSeparator();
        this.optionsContainer = new JPanel();
        this.lblTemplateList = new JLabel();
        this.lstTemplateList = new JList();
        this.setLayout(new GridBagLayout());
        this.locationContainer.setLayout(new GridBagLayout());
        this.lblProjectName.setLabelFor(this.txtProjectName);
        this.lblProjectName.setText("Project Name (Artifact ID):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.locationContainer.add((Component)this.lblProjectName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.locationContainer.add((Component)this.txtProjectName, gridBagConstraints);
        this.lblProjectDir.setLabelFor(this.txtProjectDir);
        this.lblProjectDir.setText("Project Location:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.locationContainer.add((Component)this.lblProjectDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.locationContainer.add((Component)this.txtProjectDir, gridBagConstraints);
        this.lblFolder.setLabelFor(this.txtFolder);
        this.lblFolder.setText("Project Folder:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.locationContainer.add((Component)this.lblFolder, gridBagConstraints);
        this.txtFolder.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.locationContainer.add((Component)this.txtFolder, gridBagConstraints);
        this.btnBrowse.setText("Browse...");
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenAppTemplateVisual.this.btnBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.locationContainer.add((Component)this.btnBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.locationContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.optionsContainer.setLayout(new GridBagLayout());
        this.lblTemplateList.setLabelFor(this.lstTemplateList);
        this.lblTemplateList.setText("Available Templates");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.optionsContainer.add((Component)this.lblTemplateList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.optionsContainer.add((Component)this.lstTemplateList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.optionsContainer, gridBagConstraints);
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Project Location");
        chooser.setFileSelectionMode(1);
        String path = this.txtProjectDir.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.txtProjectDir.setText(projectDir.getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    public void addNotify() {
        super.addNotify();
        this.txtProjectName.requestFocus();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.txtProjectName.getDocument() || doc == this.txtProjectDir.getDocument()) {
            String projectName = this.txtProjectName.getText();
            String projectFolder = this.txtProjectDir.getText();
            this.txtFolder.setText(projectFolder + File.separatorChar + projectName);
        }
        this.panel.fireChangeEvent();
    }

    private static class ListWrapper {
        private TemplateInfo info;

        ListWrapper(TemplateInfo i) {
            this.info = i;
        }

        public String toString() {
            return this.info.getDisplayName();
        }

        public TemplateInfo getInfo() {
            return this.info;
        }
    }
}

