/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.mevenide.context.IProjectContext;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.MavenPOMChange;
import org.mevenide.netbeans.project.customizer.MavenPOMTreeChange;
import org.mevenide.netbeans.project.customizer.MavenPropertyChange;
import org.mevenide.netbeans.project.writer.ChangesContentProvider;
import org.mevenide.netbeans.project.writer.CountNewLinesReader;
import org.mevenide.netbeans.project.writer.DependencyUpdater;
import org.mevenide.project.io.CarefulProjectMarshaller;
import org.mevenide.project.io.ElementContentProvider;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.properties.Comment;
import org.mevenide.properties.ElementFactory;
import org.mevenide.properties.KeyValuePair;
import org.mevenide.properties.PropertyModel;
import org.mevenide.properties.PropertyModelFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.UserQuestionException;

public class NbProjectWriter
implements FileSystem.AtomicAction {
    private MavenProject project;
    private List changes;

    public NbProjectWriter(MavenProject proj) {
        this.project = proj;
    }

    public void applyChanges(List changes) throws Exception {
        FileSystem fs = this.project.getProjectDirectory().getFileSystem();
        this.changes = changes;
        fs.runAtomicAction((FileSystem.AtomicAction)this);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws IOException {
        Iterator locIt;
        HashMap locFileToModelMap = new HashMap();
        HashMap locFileToLockMap = new HashMap();
        Iterator<Object> it = this.changes.iterator();
        boolean checkDependencies = false;
        String newArtifact = null;
        String newGroup = null;
        String newVersion = null;
        String oldArtifact = null;
        String oldGroup = null;
        String oldVersion = null;
        try {
            ArrayList pomChanges = new ArrayList();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof MavenPropertyChange) {
                    MavenPropertyChange change = (MavenPropertyChange)obj;
                    this.processPropertyChange(change, locFileToLockMap, locFileToModelMap);
                }
                if (!(obj instanceof MavenPOMChange) && !(obj instanceof MavenPOMTreeChange)) continue;
                pomChanges.add(obj);
                if (!(obj instanceof MavenPOMChange)) continue;
                MavenPOMChange chan = (MavenPOMChange)obj;
                if ("pom.artifactId".equals(chan.getPath()) && !chan.getOldValue().equals(chan.getNewValue())) {
                    newArtifact = chan.getNewValue();
                    checkDependencies = true;
                }
                if ("pom.groupId".equals(chan.getPath()) && !chan.getOldValue().equals(chan.getNewValue())) {
                    newGroup = chan.getNewValue();
                    checkDependencies = true;
                }
                if (!"pom.currentVersion".equals(chan.getPath()) || chan.getOldValue().equals(chan.getNewValue())) continue;
                newVersion = chan.getNewValue();
                checkDependencies = true;
            }
            if (checkDependencies) {
                oldArtifact = this.project.getOriginalMavenProject().getArtifactId();
                oldGroup = this.project.getOriginalMavenProject().getGroupId();
                oldVersion = this.project.getOriginalMavenProject().getCurrentVersion();
                newVersion = newVersion != null ? newVersion : oldVersion;
                newGroup = newGroup != null ? newGroup : oldGroup;
                newArtifact = newArtifact != null ? newArtifact : oldArtifact;
            }
            this.writePOMs(pomChanges, locFileToLockMap);
            it = locFileToModelMap.keySet().iterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                PropertyModel model = (PropertyModel)locFileToModelMap.get(file);
                FileLock lock = (FileLock)locFileToLockMap.get(file);
                FileObject fo = FileUtil.toFileObject((File)file);
                model.store(fo.getOutputStream(lock));
            }
            locIt = locFileToLockMap.values().iterator();
        }
        catch (IOException exc) {
            try {
                throw exc;
                catch (Exception exc2) {
                    IOException newone = new IOException("Error while writing project files.");
                    ErrorManager.getDefault().annotate((Throwable)newone, (Throwable)exc2);
                    throw newone;
                }
            }
            catch (Throwable throwable) {
                Iterator locIt2 = locFileToLockMap.values().iterator();
                while (locIt2.hasNext()) {
                    FileLock lock = (FileLock)locIt2.next();
                    lock.releaseLock();
                }
                if (!checkDependencies) throw throwable;
                try {
                    DependencyUpdater.checkOpenedProjects(oldArtifact, oldGroup, oldVersion, newArtifact, newGroup, newVersion);
                    throw throwable;
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Exception exc2) {
                    IOException newone = new IOException("Error while writing project files.");
                    ErrorManager.getDefault().annotate((Throwable)newone, (Throwable)exc2);
                    throw newone;
                }
            }
        }
        while (locIt.hasNext()) {
            FileLock lock = (FileLock)locIt.next();
            lock.releaseLock();
        }
        if (!checkDependencies) return;
        try {
            DependencyUpdater.checkOpenedProjects(oldArtifact, oldGroup, oldVersion, newArtifact, newGroup, newVersion);
            return;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception exc2) {
            IOException newone = new IOException("Error while writing project files.");
            ErrorManager.getDefault().annotate((Throwable)newone, (Throwable)exc2);
            throw newone;
        }
    }

    private PropertyModel createPropertyModel(File location, HashMap locks, HashMap models) throws IOException {
        FileObject fo = null;
        if (!location.exists()) {
            FileObject parentFO;
            File parent = location.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if ((parentFO = FileUtil.toFileObject((File)parent)) == null) {
                throw new IOException("Cannot create directory where to create the property file.");
            }
            fo = parentFO.createData(location.getName());
        } else {
            fo = FileUtil.toFileObject((File)location);
        }
        if (fo == null) {
            throw new IOException("");
        }
        try {
            PropertyModel model = PropertyModelFactory.getFactory().newPropertyModel(fo.getInputStream());
            FileLock lock = fo.lock();
            locks.put(location, lock);
            models.put(location, model);
            return model;
        }
        catch (UserQuestionException exc) {
            throw new IOException("Cannot obtain lock. User interaction required.");
        }
    }

    private int findBestPlacement(PropertyModel model, String key) {
        int secondDot;
        if (key.startsWith("maven.") && (secondDot = key.indexOf(".", 6)) > 0) {
            String keyGroup = key.substring(0, secondDot);
            Iterator it = model.getList().iterator();
            int index = -1;
            while (it.hasNext()) {
                KeyValuePair pair;
                ++index;
                org.mevenide.properties.Element el = (org.mevenide.properties.Element)it.next();
                if (!(el instanceof KeyValuePair) || !(pair = (KeyValuePair)el).getKey().startsWith(keyGroup)) continue;
                return index;
            }
        }
        return -1;
    }

    private void processPropertyChange(MavenPropertyChange change, HashMap locFileToLockMap, HashMap locFileToModelMap) throws IOException {
        PropertyModel model;
        if (change.getOldLocation() != -2 && change.getOldLocation() != -1) {
            KeyValuePair oldpair;
            File oldLoc = FileUtilities.locationToFile(change.getOldLocation(), this.project);
            model = (PropertyModel)locFileToModelMap.get(oldLoc);
            if (model == null) {
                model = this.createPropertyModel(oldLoc, locFileToLockMap, locFileToModelMap);
            }
            if (change.getOldLocation() != change.getNewLocation() && (oldpair = model.findByKey(change.getKey())) != null) {
                model.removeElement((org.mevenide.properties.Element)oldpair);
            }
        }
        if (change.getNewLocation() != -2 && change.getNewLocation() != -1) {
            KeyValuePair pair;
            File newLoc = FileUtilities.locationToFile(change.getNewLocation(), this.project);
            model = (PropertyModel)locFileToModelMap.get(newLoc);
            if (model == null) {
                model = this.createPropertyModel(newLoc, locFileToLockMap, locFileToModelMap);
            }
            if ((pair = model.findByKey(change.getKey())) != null) {
                if (change.getOldLocation() == change.getNewLocation()) {
                    pair.setValue(change.getNewValue());
                } else {
                    String commentStr = "#" + pair.getKey() + "=" + pair.getValue();
                    int index = model.getList().indexOf(pair);
                    Comment comment = ElementFactory.getFactory().createComment();
                    comment.setComment(commentStr);
                    model.insertAt(index, (org.mevenide.properties.Element)comment);
                    pair.setValue(change.getNewValue());
                }
            } else {
                pair = ElementFactory.getFactory().createKeyValuePair(change.getKey(), '=');
                pair.setValue(change.getNewValue());
                int index = this.findBestPlacement(model, change.getKey());
                if (index > 0) {
                    model.insertAt(index, (org.mevenide.properties.Element)pair);
                } else {
                    model.addElement((org.mevenide.properties.Element)pair);
                }
            }
        }
    }

    private void writePOMs(List changes, HashMap fileLockMap) throws Exception {
        if (changes.size() > 0) {
            IProjectContext context = this.project.getContext().getPOMContext();
            Element[] roots = context.getRootElementLayers();
            File[] files = context.getProjectFiles();
            Writer writer = null;
            CountNewLinesReader reader = null;
            try {
                for (int i = 0; i < files.length; ++i) {
                    ChangesContentProvider provider = new ChangesContentProvider((IContentProvider)new ElementContentProvider(roots[i]), changes, "pom", i);
                    FileObject fo = FileUtil.toFileObject((File)files[i]);
                    reader = new CountNewLinesReader(fo.getInputStream());
                    SAXBuilder builder = new SAXBuilder();
                    Document originalDoc = builder.build((Reader)reader);
                    reader.close();
                    FileLock lock = fo.lock();
                    fileLockMap.put(files[i], lock);
                    writer = new OutputStreamWriter(fo.getOutputStream(lock));
                    CarefulProjectMarshaller marshall = new CarefulProjectMarshaller(NbProjectWriter.figureOutFormat(roots[i], reader));
                    marshall.marshall(writer, (IContentProvider)provider, originalDoc);
                }
            }
            catch (UserQuestionException exc) {
                throw new IOException("Cannot obtain lock. User interaction required.");
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    static Format figureOutFormat(Element root, CountNewLinesReader reader) {
        Format toRet = Format.getPrettyFormat();
        List content = root.getContent();
        String lineSep = reader.getNewLineString();
        String indent = "    ";
        if (content.size() > 2) {
            String newLine;
            String line;
            int index;
            Content cont1 = (Content)content.get(0);
            Content cont2 = (Content)content.get(1);
            if (cont1 instanceof Text && cont2 instanceof Element && (index = (line = cont1.getValue()).indexOf("\n")) > -1 && line.length() + lineSep.length() > index && (newLine = line.substring(index + lineSep.length())).matches("[ ]{" + newLine.length() + "}")) {
                indent = newLine;
            }
        }
        toRet.setIndent(indent);
        toRet.setLineSeparator(lineSep);
        return toRet;
    }
}

