/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.MavenChange;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.project.customizer.TextComponentPOMChange;
import org.mevenide.netbeans.project.customizer.ui.LocationComboFactory;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class DescriptionPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)DescriptionPanel.class);
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private OriginChange ocLogo;
    private OriginChange ocUrl;
    private OriginChange ocInceptionYear;
    private OriginChange ocShortDescription;
    private OriginChange ocDescription;
    private HashMap changes;
    private boolean initialized;
    private JButton btnDescription;
    private JButton btnInceptionYear;
    private JButton btnLogo;
    private JButton btnShortDescription;
    private JButton btnUrl;
    private JButton btnUrlLoc;
    private JLabel lblDescription;
    private JLabel lblInceptionYear;
    private JLabel lblLogo;
    private JLabel lblShortDescription;
    private JLabel lblUrl;
    private JScrollPane spDescription;
    private JTextArea taDescription;
    private JTextField txtInceptionYear;
    private JTextField txtLogo;
    private JTextField txtShortDescription;
    private JTextField txtUrl;

    public DescriptionPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.setName("Description");
        this.btnUrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String url = DescriptionPanel.this.txtUrl.getText().trim();
                url = DescriptionPanel.this.project.getPropertyResolver().resolveString(url);
                if (url.startsWith("http://")) {
                    try {
                        URL link = new URL(url);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                    }
                    catch (MalformedURLException exc) {
                        NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
                    }
                }
            }
        });
        this.initialized = false;
    }

    private void initComponents() {
        this.lblInceptionYear = new JLabel();
        this.txtInceptionYear = new JTextField();
        this.ocInceptionYear = LocationComboFactory.createPOMChange(this.project, false);
        this.btnInceptionYear = (JButton)this.ocInceptionYear.getComponent();
        this.lblUrl = new JLabel();
        this.txtUrl = new JTextField();
        this.ocUrl = LocationComboFactory.createPOMChange(this.project, false);
        this.btnUrlLoc = (JButton)this.ocUrl.getComponent();
        this.btnUrl = new JButton();
        this.lblLogo = new JLabel();
        this.txtLogo = new JTextField();
        this.ocLogo = LocationComboFactory.createPOMChange(this.project, false);
        this.btnLogo = (JButton)this.ocLogo.getComponent();
        this.lblShortDescription = new JLabel();
        this.txtShortDescription = new JTextField();
        this.ocShortDescription = LocationComboFactory.createPOMChange(this.project, false);
        this.btnShortDescription = (JButton)this.ocShortDescription.getComponent();
        this.lblDescription = new JLabel();
        this.spDescription = new JScrollPane();
        this.taDescription = new JTextArea();
        this.ocDescription = LocationComboFactory.createPOMChange(this.project, true);
        this.btnDescription = (JButton)this.ocDescription.getComponent();
        this.setLayout(new GridBagLayout());
        this.lblInceptionYear.setLabelFor(this.txtInceptionYear);
        this.lblInceptionYear.setText(NbBundle.getMessage((Class)DescriptionPanel.class, (String)"DescPanel.lblInceptionYear.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblInceptionYear, gridBagConstraints);
        this.txtInceptionYear.setMinimumSize(new Dimension(50, 28));
        this.txtInceptionYear.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtInceptionYear, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnInceptionYear, gridBagConstraints);
        this.lblUrl.setLabelFor(this.txtUrl);
        this.lblUrl.setText(NbBundle.getMessage((Class)DescriptionPanel.class, (String)"DescPanel.lblUrl.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblUrl, gridBagConstraints);
        this.txtUrl.setMinimumSize(new Dimension(50, 26));
        this.txtUrl.setPreferredSize(new Dimension(50, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnUrlLoc, gridBagConstraints);
        this.btnUrl.setText(NbBundle.getMessage((Class)DescriptionPanel.class, (String)"BasicPanel.btnUrl.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnUrl, gridBagConstraints);
        this.lblLogo.setLabelFor(this.txtLogo);
        this.lblLogo.setText(NbBundle.getMessage((Class)DescriptionPanel.class, (String)"DescPanel.lblLogo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtLogo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnLogo, gridBagConstraints);
        this.lblShortDescription.setLabelFor(this.txtShortDescription);
        this.lblShortDescription.setText(NbBundle.getMessage((Class)DescriptionPanel.class, (String)"DescPanel.lblShortDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblShortDescription, gridBagConstraints);
        this.txtShortDescription.setMinimumSize(new Dimension(100, 26));
        this.txtShortDescription.setPreferredSize(new Dimension(100, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtShortDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnShortDescription, gridBagConstraints);
        this.lblDescription.setLabelFor(this.taDescription);
        this.lblDescription.setText(NbBundle.getMessage((Class)DescriptionPanel.class, (String)"DescPanel.lblDescription.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblDescription, gridBagConstraints);
        this.taDescription.setMinimumSize(new Dimension(200, 100));
        this.spDescription.setViewportView(this.taDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.spDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btnDescription, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        this.createPOMChangeInstance("inceptionYear", this.txtInceptionYear, this.ocInceptionYear);
        this.createPOMChangeInstance("logo", this.txtLogo, this.ocLogo);
        this.createPOMChangeInstance("url", this.txtUrl, this.ocUrl);
        this.createPOMChangeInstance("shortDescription", this.txtShortDescription, this.ocShortDescription);
        this.createPOMChangeInstance("description", this.taDescription, this.ocDescription);
    }

    private void createPOMChangeInstance(String propName, JTextComponent field, OriginChange oc) {
        String key = "pom." + propName;
        String value = this.project.getProjectWalker().getValue(key);
        int location = this.project.getProjectWalker().getLocation(key);
        if (value == null) {
            value = "";
        }
        this.changes.put(key, new TextComponentPOMChange(key, value, location, field, oc));
    }

    public void setResolveValues(boolean resolve) {
        this.assignValue("inceptionYear", resolve);
        this.assignValue("logo", resolve);
        this.assignValue("url", resolve);
        this.assignValue("shortDescription", resolve);
        this.assignValue("description", resolve);
    }

    private void assignValue(String actionName, boolean resolve) {
        String key = "pom." + actionName;
        TextComponentPOMChange change = (TextComponentPOMChange)this.changes.get(key);
        if (resolve) {
            String value = this.project.getPropertyResolver().resolveString(change.getNewValue());
            change.setResolvedValue(value);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    private int doValidateCheck() {
        return 0;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        return "";
    }
}

