/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.BuildPanel;
import org.mevenide.netbeans.project.customizer.CheckBoxPropertyChange;
import org.mevenide.netbeans.project.customizer.MavenChange;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.project.customizer.TextFieldPropertyChange;
import org.mevenide.netbeans.project.customizer.ui.LocationComboFactory;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class JavaPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)BuildPanel.class);
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private OriginChange ocDebug;
    private OriginChange ocDeprecated;
    private OriginChange ocAdditional;
    private OriginChange ocMainClass;
    private OriginChange ocManifest;
    private OriginChange ocCompress;
    private OriginChange ocExecutable;
    private HashMap changes;
    private boolean initialized;
    private JButton btnAdditional;
    private JButton btnCompress;
    private JButton btnDebug;
    private JButton btnDeprecated;
    private JButton btnEdit;
    private JButton btnExecutable;
    private JButton btnMainClass;
    private JButton btnManifest;
    private JCheckBox cbCompress;
    private JCheckBox cbDebug;
    private JCheckBox cbDeprecated;
    private JComboBox comPlatform;
    private JPanel jPanel1;
    private JLabel lblAdditional;
    private JLabel lblExecutable;
    private JLabel lblMainClass;
    private JLabel lblManifest;
    private JTextField txtAdditional;
    private JTextField txtExecutable;
    private JTextField txtMainClass;
    private JTextField txtManifest;

    public JavaPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.setName("Java and Jar");
        this.initialized = false;
        this.comPlatform.setToolTipText("In order to have code completion and other IDE features for the project, the user should define a Java Platform corresponding to the  compilate executable.");
    }

    private void initComponents() {
        this.ocDebug = LocationComboFactory.createPropertiesChange(this.project);
        this.btnDebug = (JButton)this.ocDebug.getComponent();
        this.cbDebug = new JCheckBox();
        this.ocDeprecated = LocationComboFactory.createPropertiesChange(this.project);
        this.btnDeprecated = (JButton)this.ocDeprecated.getComponent();
        this.cbDeprecated = new JCheckBox();
        this.lblAdditional = new JLabel();
        this.txtAdditional = new JTextField();
        this.ocAdditional = LocationComboFactory.createPropertiesChange(this.project);
        this.btnAdditional = (JButton)this.ocAdditional.getComponent();
        this.lblMainClass = new JLabel();
        this.txtMainClass = new JTextField();
        this.ocMainClass = LocationComboFactory.createPropertiesChange(this.project);
        this.btnMainClass = (JButton)this.ocMainClass.getComponent();
        this.lblManifest = new JLabel();
        this.txtManifest = new JTextField();
        this.ocManifest = LocationComboFactory.createPropertiesChange(this.project);
        this.btnManifest = (JButton)this.ocManifest.getComponent();
        this.ocCompress = LocationComboFactory.createPropertiesChange(this.project);
        this.btnCompress = (JButton)this.ocCompress.getComponent();
        this.cbCompress = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.ocExecutable = LocationComboFactory.createPropertiesChange(this.project);
        this.btnExecutable = (JButton)this.ocExecutable.getComponent();
        this.lblExecutable = new JLabel();
        this.txtExecutable = new JTextField();
        this.comPlatform = new JComboBox();
        this.btnEdit = new JButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.btnDebug, gridBagConstraints);
        this.cbDebug.setText("Generate Debugging Info");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbDebug, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.btnDeprecated, gridBagConstraints);
        this.cbDeprecated.setText("Report Usage of Deprecated APIs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbDeprecated, gridBagConstraints);
        this.lblAdditional.setLabelFor(this.txtAdditional);
        this.lblAdditional.setText("Additional Compiler Options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblAdditional, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtAdditional, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnAdditional, gridBagConstraints);
        this.lblMainClass.setLabelFor(this.txtMainClass);
        this.lblMainClass.setText("Main Class:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.lblMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 6, 0, 0);
        this.add((Component)this.txtMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 6, 0, 0);
        this.add((Component)this.btnMainClass, gridBagConstraints);
        this.lblManifest.setLabelFor(this.txtManifest);
        this.lblManifest.setText("Manifest File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblManifest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtManifest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnManifest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.btnCompress, gridBagConstraints);
        this.cbCompress.setText("Compress JAR File");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbCompress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnExecutable, gridBagConstraints);
        this.lblExecutable.setLabelFor(this.txtExecutable);
        this.lblExecutable.setText("Compilation Executable:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblExecutable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtExecutable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.comPlatform, gridBagConstraints);
        this.btnEdit.setText("Edit...");
        this.btnEdit.setToolTipText("Edit the Defined Java Platforms");
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JavaPanel.this.btnEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnEdit, gridBagConstraints);
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer(null);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
            this.populatePlatformCombo(this.project.getPropertyResolver().getResolvedValue("maven.compile.executable"));
            ExecutableListener lst = new ExecutableListener();
            this.comPlatform.addActionListener(lst);
            this.txtExecutable.getDocument().addDocumentListener(lst);
        }
    }

    private void populateChangeInstances() {
        this.createToggleChangeInstance("maven.compile.debug", this.cbDebug, this.ocDebug, true);
        this.createToggleChangeInstance("maven.compile.deprecation", this.cbDeprecated, this.ocDeprecated, false);
        this.createToggleChangeInstance("maven.jar.compress", this.cbCompress, this.ocCompress, true);
        this.createChangeInstance("maven.compile.compilerargs", this.txtAdditional, this.ocAdditional);
        this.createChangeInstance("maven.jar.mainclass", this.txtMainClass, this.ocMainClass);
        this.createChangeInstance("maven.jar.manifest", this.txtManifest, this.ocManifest);
        this.createChangeInstance("maven.compile.executable", this.txtExecutable, this.ocExecutable);
    }

    private void createToggleChangeInstance(String key, JCheckBox field, OriginChange oc, boolean defaultValue) {
        String value = this.project.getPropertyResolver().getResolvedValue(key);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = Boolean.toString(defaultValue);
            location = -1;
        }
        this.changes.put(key, new CheckBoxPropertyChange(key, value, location, field, oc, defaultValue, false));
    }

    private void createChangeInstance(String key, JTextField field, OriginChange oc) {
        String value = this.project.getPropertyResolver().getValue(key);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = "";
            location = -1;
        }
        String defaultValue = this.project.getPropertyLocator().getValueAtLocation(key, -2);
        this.changes.put(key, new TextFieldPropertyChange(key, value, location, field, oc, defaultValue));
    }

    public void setResolveValues(boolean resolve) {
        this.assignValue("maven.compile.compilerargs", resolve);
        this.assignValue("maven.jar.mainclass", resolve);
        this.assignValue("maven.jar.manifest", resolve);
        this.assignValue("maven.compile.executable", resolve);
    }

    private void assignValue(String key, boolean resolve) {
        TextFieldPropertyChange change = (TextFieldPropertyChange)this.changes.get(key);
        if (resolve) {
            String value = this.project.getPropertyResolver().resolveString(change.getNewValue());
            change.setResolvedValue(value);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        String message = "";
        return message;
    }

    private void populatePlatformCombo(String customCompile) {
        ArrayList<Object> col = new ArrayList<Object>();
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        JavaPlatform[] platforms = pm.getInstalledPlatforms();
        Object selected = new NoCorrectPlatform();
        String def = pm.getDefaultPlatform().getDisplayName();
        for (int i = 0; i < platforms.length; ++i) {
            if (!def.equals(platforms[i].getDisplayName())) {
                col.add(platforms[i].getDisplayName());
                continue;
            }
            col.add(selected);
        }
        if (customCompile != null && customCompile.trim().length() > 0) {
            FileObject toolFO;
            boolean found = false;
            File fl = new File(customCompile);
            if (fl.exists() && (toolFO = FileUtil.toFileObject((File)fl)) != null) {
                String toolname = toolFO.getNameExt();
                for (int i = 0; i < platforms.length; ++i) {
                    FileObject fo;
                    if (def.equals(platforms[i].getDisplayName()) || (fo = platforms[i].findTool(toolname)) == null || !fo.equals(toolFO)) continue;
                    selected = platforms[i].getDisplayName();
                    found = true;
                    break;
                }
            }
        }
        this.comPlatform.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
        this.comPlatform.setSelectedItem(selected);
    }

    private class ExecutableListener
    implements ActionListener,
    DocumentListener {
        private boolean skip = false;

        private ExecutableListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.skip) {
                this.skip = true;
                Object obj = JavaPanel.this.comPlatform.getSelectedItem();
                if (!(obj instanceof NoCorrectPlatform)) {
                    String toFind;
                    JavaPlatform plat;
                    FileObject fo;
                    String str = (String)obj;
                    JavaPlatformManager pm = JavaPlatformManager.getDefault();
                    JavaPlatform[] platforms = pm.getPlatforms(str, null);
                    if (platforms != null && platforms.length > 0 && (fo = (plat = platforms[0]).findTool(toFind = Utilities.isWindows() ? "javac.exe" : "javac")) != null) {
                        File fil = FileUtil.toFile((FileObject)fo);
                        JavaPanel.this.txtExecutable.setText(fil.getAbsolutePath());
                    }
                }
                this.skip = false;
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.change();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.change();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.change();
        }

        private void change() {
            if (!this.skip) {
                this.skip = true;
                JavaPanel.this.populatePlatformCombo(JavaPanel.this.project.getPropertyResolver().resolveString(JavaPanel.this.txtExecutable.getText()));
                this.skip = false;
            }
        }
    }

    private static class NoCorrectPlatform {
        private NoCorrectPlatform() {
        }

        public String toString() {
            return "Default Platform";
        }
    }
}

