/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.mevenide.netbeans.project.customizer.MavenPOMTreeChange;
import org.mevenide.netbeans.project.customizer.MultiTextComponentPOMChange;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.mevenide.netbeans.project.writer.AbstractContentProvider;
import org.mevenide.project.io.IContentProvider;

public class ListModelPOMChange
implements MavenPOMTreeChange {
    private String key;
    private List values;
    private int location;
    private List newValues;
    private int newLocation;
    private DefaultListModel model;
    private OriginChange origin;
    private DocListener listener;
    private boolean ignore = false;
    private boolean hasPomChanges;

    public ListModelPOMChange(String keyParam, List oldValues, int oldLocation, DefaultListModel lst, OriginChange oc) {
        this(keyParam, oldValues, oldLocation, lst, oc, false);
    }

    public ListModelPOMChange(String keyParam, List oldValues, int oldLocation, DefaultListModel lst, OriginChange oc, boolean itemsPomChanges) {
        this.key = keyParam;
        this.values = oldValues;
        this.location = oldLocation;
        this.newValues = new ArrayList(this.values);
        this.newLocation = oldLocation;
        this.origin = oc;
        this.origin.setInitialLocationID(oldLocation);
        this.model = lst;
        Iterator it = this.newValues.iterator();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.listener = new DocListener();
        this.origin.setChangeObserver(this.listener);
        this.model.addListDataListener(this.listener);
        this.hasPomChanges = itemsPomChanges;
    }

    public void startIgnoringChanges() {
        this.ignore = true;
    }

    public void stopIgnoringChanges() {
        this.model.removeAllElements();
        Iterator it = this.newValues.iterator();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.origin.setInitialLocationID(this.newLocation);
        this.ignore = false;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public int getOldLocation() {
        return this.location;
    }

    public boolean hasChanged() {
        return this.newLocation != this.location || !((Object)this.values).equals(this.newValues);
    }

    public void setResolvedValues(List resvalues) {
        this.ignore = true;
        this.origin.getComponent().setEnabled(false);
        this.model.removeAllElements();
        Iterator it = resvalues.iterator();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.ignore = false;
    }

    public void resetToNonResolvedValue() {
        this.ignore = true;
        this.origin.getComponent().setEnabled(true);
        this.model.removeAllElements();
        Iterator it = this.newValues.iterator();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.ignore = false;
    }

    public String getPath() {
        return this.key;
    }

    public IContentProvider getChangedContent() {
        if (!this.hasPomChanges) {
            return new ValueListContentProvider(this.newValues);
        }
        return new SubProviderContainerProvider(this.newValues);
    }

    protected static class SubProviderContainerProvider
    extends AbstractContentProvider {
        private List vals;

        public SubProviderContainerProvider(List values) {
            this.vals = values;
        }

        public List getSubContentProviderList(String parentKey, String childKey) {
            ArrayList<IContentProvider> toReturn = new ArrayList<IContentProvider>();
            Iterator it = this.vals.iterator();
            while (it.hasNext()) {
                MultiTextComponentPOMChange chng = (MultiTextComponentPOMChange)it.next();
                toReturn.add(chng.getChangedContent());
            }
            return toReturn;
        }
    }

    protected static class ValueListContentProvider
    extends AbstractContentProvider {
        private List vals;

        public ValueListContentProvider(List values) {
            this.vals = values;
        }

        public List getValueList(String parentKey, String childKey) {
            return this.vals;
        }
    }

    private class DocListener
    implements ListDataListener,
    OriginChange.ChangeObserver {
        private DocListener() {
        }

        private void update() {
            if (ListModelPOMChange.this.ignore) {
                return;
            }
            Enumeration en = ListModelPOMChange.this.model.elements();
            ListModelPOMChange.this.newValues.clear();
            while (en.hasMoreElements()) {
                ListModelPOMChange.this.newValues.add(en.nextElement());
            }
            if (ListModelPOMChange.this.origin.getSelectedLocationID() == -1 || ListModelPOMChange.this.origin.getSelectedLocationID() == -2) {
                ListModelPOMChange.this.origin.setAction(0);
            }
        }

        public void locationChanged() {
            if (ListModelPOMChange.this.ignore) {
                return;
            }
            ListModelPOMChange.this.newLocation = ListModelPOMChange.this.origin.getSelectedLocationID();
            if (ListModelPOMChange.this.newLocation < 0) {
                ListModelPOMChange.this.ignore = true;
                ListModelPOMChange.this.newValues.clear();
                ListModelPOMChange.this.model.removeAllElements();
                ListModelPOMChange.this.ignore = false;
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.update();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.update();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.update();
        }
    }
}

