/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.mevenide.netbeans.project.customizer.MavenPOMChange;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;

public class TextComponentPOMChange
implements MavenPOMChange {
    private String key;
    private String value;
    private int location;
    private String newValue;
    private int newLocation;
    private JTextComponent field;
    private OriginChange origin;
    private DocListener listener;
    private boolean ignore = false;

    public TextComponentPOMChange(String keyParam, String oldValue, int oldLocation, JTextComponent textfield, OriginChange oc) {
        this.key = keyParam;
        this.value = oldValue != null ? oldValue : "";
        this.location = oldLocation;
        this.newValue = this.value;
        this.newLocation = oldLocation;
        this.field = textfield;
        this.origin = oc;
        this.origin.setInitialLocationID(oldLocation);
        this.field.setText(this.value);
        this.listener = new DocListener();
        this.origin.setChangeObserver(this.listener);
        this.field.getDocument().addDocumentListener(this.listener);
    }

    public void startIgnoringChanges() {
        this.ignore = true;
    }

    public void stopIgnoringChanges() {
        this.field.setText(this.newValue);
        this.origin.setInitialLocationID(this.newLocation);
        this.ignore = false;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public int getOldLocation() {
        return this.location;
    }

    public String getOldValue() {
        return this.value;
    }

    public boolean hasChanged() {
        return this.newLocation != this.location || !this.getOldValue().equals(this.getNewValue());
    }

    public void setResolvedValue(String resvalue) {
        this.ignore = true;
        this.field.setEditable(false);
        this.origin.getComponent().setEnabled(false);
        this.field.setText(resvalue);
        this.ignore = false;
    }

    public void resetToNonResolvedValue() {
        this.ignore = true;
        this.field.setEditable(true);
        this.origin.getComponent().setEnabled(true);
        this.field.setText(this.newValue);
        this.ignore = false;
    }

    public String getPath() {
        return this.key;
    }

    private class DocListener
    implements DocumentListener,
    OriginChange.ChangeObserver {
        private DocListener() {
        }

        private void update() {
            if (TextComponentPOMChange.this.ignore) {
                return;
            }
            TextComponentPOMChange.this.newValue = TextComponentPOMChange.this.field.getText();
            if (TextComponentPOMChange.this.origin.getSelectedLocationID() == -1 || TextComponentPOMChange.this.origin.getSelectedLocationID() == -2) {
                TextComponentPOMChange.this.origin.setAction(0);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        public void locationChanged() {
            if (TextComponentPOMChange.this.ignore) {
                return;
            }
            TextComponentPOMChange.this.newLocation = TextComponentPOMChange.this.origin.getSelectedLocationID();
            if (TextComponentPOMChange.this.newLocation < 0) {
                TextComponentPOMChange.this.ignore = true;
                TextComponentPOMChange.this.newValue = "";
                TextComponentPOMChange.this.field.setText(TextComponentPOMChange.this.newValue);
                TextComponentPOMChange.this.ignore = false;
            }
        }
    }
}

