/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.Action;
import org.apache.maven.project.Dependency;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.queries.MavenFileOwnerQueryImpl;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.project.io.JarOverrideReader2;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.Project;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class DependencyNode
extends AbstractNode {
    private Action[] actions;
    private IContentProvider dependency;
    private MavenProject project;
    private boolean isOverriden;
    private String override;

    public DependencyNode(IContentProvider dep, MavenProject proj) {
        this(dep, proj, Lookups.singleton((Object)dep));
    }

    public DependencyNode(IContentProvider dep, MavenProject proj, Lookup lookup) {
        super(Children.LEAF, lookup);
        this.dependency = dep;
        this.project = proj;
        this.setDisplayName(this.createName());
        this.setIconBase();
        this.checkOverride();
    }

    private void setIconBase() {
        URI uri = FileUtilities.getDependencyURI(this.createDependencySnapshot(), this.project);
        Project depPrj = MavenFileOwnerQueryImpl.getInstance().getOwner(uri);
        if (depPrj != null) {
            this.setIconBase("org/mevenide/netbeans/project/resources/MavenIcon");
        } else if ("plugin".equalsIgnoreCase(this.dependency.getValue("type"))) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyPlugin");
        } else if (this.dependency.getValue("type") != null && "pom".equalsIgnoreCase(this.dependency.getValue("type"))) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyPom");
        } else if ("jar".equalsIgnoreCase(this.dependency.getValue("type"))) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyJar");
        } else {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        }
    }

    public DependencyNode(Dependency dep, MavenProject proj) {
        this(DependencyNode.createContentProvider(dep), proj);
    }

    private static IContentProvider createContentProvider(Dependency dep) {
        return new DepContentProvider(dep);
    }

    private Dependency createDependencySnapshot() {
        Dependency snap = new Dependency();
        if (this.dependency.getValue("artifactId") != null) {
            snap.setArtifactId(this.dependency.getValue("artifactId"));
        }
        if (this.dependency.getValue("groupId") != null) {
            snap.setGroupId(this.dependency.getValue("groupId"));
        }
        if (this.dependency.getValue("version") != null) {
            snap.setVersion(this.dependency.getValue("version"));
        }
        if (this.dependency.getValue("type") != null) {
            snap.setType(this.dependency.getValue("type"));
        }
        if (this.dependency.getValue("jar") != null) {
            snap.setJar(this.dependency.getValue("jar"));
        }
        if (this.dependency.getValue("url") != null) {
            snap.setUrl(this.dependency.getValue("url"));
        }
        return snap;
    }

    public void refreshNode() {
        this.setDisplayName(this.createName());
        this.setIconBase();
        this.checkOverride();
        this.fireIconChange();
        this.fireDisplayNameChange(null, this.getDisplayName());
    }

    private String createName() {
        String title = "";
        IPropertyResolver res = this.project.getPropertyResolver();
        if (this.dependency.getValue("jar") != null) {
            title = res.resolveString(this.dependency.getValue("jar"));
        } else {
            title = res.resolveString(this.dependency.getValue("artifactId"));
            if (this.dependency.getValue("version") != null) {
                title = title + "-" + res.resolveString(this.dependency.getValue("version"));
            }
        }
        return title;
    }

    private void checkOverride() {
        this.isOverriden = false;
        String ov = this.project.getPropertyResolver().getResolvedValue("maven.jar.override");
        if (ov != null) {
            ov = ov.trim();
        }
        if ("true".equalsIgnoreCase(ov) || "on".equalsIgnoreCase(ov)) {
            this.override = this.project.getPropertyResolver().getValue("maven.jar." + this.dependency.getValue("artifactId"));
            this.isOverriden = this.override != null;
        }
    }

    public Action[] getActions(boolean context) {
        if (this.actions == null) {
            this.actions = new Action[0];
        }
        return this.actions;
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    private boolean checkLocal() {
        if (!this.isOverriden) {
            URI uri = FileUtilities.getDependencyURI(this.createDependencySnapshot(), this.project);
            if (uri != null) {
                File file = new File(uri);
                return file.exists();
            }
        } else {
            String path = JarOverrideReader2.getInstance().processOverride(this.createDependencySnapshot(), this.project.getContext());
            if (path != null) {
                File file = new File(path);
                return file.exists();
            }
        }
        return false;
    }

    public boolean hasJavadocInRepository() {
        Dependency depSnap = this.createDependencySnapshot();
        depSnap.setType("javadoc.jar");
        URI uri = FileUtilities.getDependencyURI(depSnap, this.project);
        return uri != null && new File(uri).exists();
    }

    public boolean hasSourceInRepository() {
        Dependency depSnap = this.createDependencySnapshot();
        depSnap.setType("src.jar");
        URI uri = FileUtilities.getDependencyURI(depSnap, this.project);
        return uri != null && new File(uri).exists();
    }

    public Image getIcon(int param) {
        Image retValue = super.getIcon(param);
        if (this.checkLocal()) {
            if ("jar".equalsIgnoreCase(this.dependency.getValue("type"))) {
                if (this.hasJavadocInRepository()) {
                    retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/DependencyJavadocIncluded.png"), (int)12, (int)12);
                }
                if (this.hasSourceInRepository()) {
                    retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/DependencySrcIncluded.png"), (int)12, (int)8);
                }
                return retValue;
            }
            return retValue;
        }
        return Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ResourceNotIncluded.gif"), (int)0, (int)0);
    }

    public Image getOpenedIcon(int type) {
        Image retValue = super.getOpenedIcon(type);
        if (this.checkLocal()) {
            return retValue;
        }
        return Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ResourceNotIncluded.gif"), (int)0, (int)0);
    }

    public Component getCustomizer() {
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public String getHtmlDisplayName() {
        String retValue = this.isOverriden ? "<S>" + this.getDisplayName() + "</S>  ( Overriden: " + this.override + ")" : super.getHtmlDisplayName();
        return retValue;
    }

    private static class DepContentProvider
    implements IContentProvider {
        private Dependency dependency;

        public DepContentProvider(Dependency dep) {
            this.dependency = dep;
        }

        public List getProperties() {
            return this.dependency.getProperties();
        }

        public IContentProvider getSubContentProvider(String key) {
            return null;
        }

        public List getSubContentProviderList(String parentKey, String childKey) {
            return null;
        }

        public String getValue(String key) {
            if ("artifactId".equals(key)) {
                return this.dependency.getArtifactId();
            }
            if ("groupId".equals(key)) {
                return this.dependency.getGroupId();
            }
            if ("version".equals(key)) {
                return this.dependency.getVersion();
            }
            if ("type".equals(key)) {
                return this.dependency.getType();
            }
            if ("jar".equals(key)) {
                return this.dependency.getJar();
            }
            if ("url".equals(key)) {
                return this.dependency.getUrl();
            }
            return null;
        }

        public List getValueList(String parentKey, String childKey) {
            return null;
        }
    }
}

