/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.mevenide.netbeans.project.dependencies.LocalRepoRefresher;
import org.mevenide.netbeans.project.dependencies.RepoGrouperComparator;
import org.mevenide.netbeans.project.dependencies.RepoPathGrouper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class MultiRepositoryNode
extends AbstractNode
implements LocalRepoRefresher {
    private static final Object LOADING = new Object();
    private RepoPathGrouper element;
    private String label;
    private boolean downloaded = false;

    public MultiRepositoryNode(RepoPathGrouper el) {
        super((Children)(el.isLeaf() ? Children.LEAF : new RepositoryChildren(el)), Lookups.proxy((Lookup.Provider)new Provider(el)));
        this.element = el;
        if (this.element.getLevel() == 1 || this.element.getLevel() == 2) {
            this.setIconBase("org/mevenide/netbeans/project/resources/defaultFolder");
        } else if (this.element.getLevel() == 3) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        } else if (this.element.getLevel() == 4) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        } else if (this.element.getLevel() == 0) {
            this.setIconBase("org/mevenide/netbeans/project/resources/RepositoryRoot");
        } else {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        }
        if (this.element.isRemote() && this.element.isLocal()) {
            this.setShortDescription("Defined in both remote and local repositories.");
        } else if (this.element.isLocal()) {
            this.setShortDescription("Defined in local repository.");
        } else if (this.element.isRemote()) {
            this.setShortDescription("Defined in remote repository only.");
        }
    }

    public MultiRepositoryNode(RepoPathGrouper el, String rootLabel) {
        this(el);
        this.label = rootLabel;
    }

    public String getDisplayName() {
        return this.createName();
    }

    public String getHtmlDisplayName() {
        if ((this.element.isLocal() || this.downloaded) == this.element.isRemote()) {
            return "<html><b><font color='#8d8ba7'>" + this.getDisplayName() + "</font></b></html>";
        }
        if (this.element.isLocal()) {
            return super.getHtmlDisplayName();
        }
        if (this.element.isRemote()) {
            return "<html><b><font color='#9f9a93'>" + this.getDisplayName() + "</font></b></html>";
        }
        throw new IllegalStateException();
    }

    public int getRepoLevel() {
        return this.element.getLevel();
    }

    private String createName() {
        switch (this.element.getLevel()) {
            case 0: {
                String str = this.label == null ? "" : this.label;
                return str;
            }
            case 1: {
                return this.element.getGroupId();
            }
            case 2: {
                return this.element.getType();
            }
            case 3: {
                return this.element.getArtifactId();
            }
            case 4: {
                int level;
                Node parent = this.getParentNode();
                if (parent != null && parent instanceof MultiRepositoryNode && (level = ((MultiRepositoryNode)parent).getRepoLevel()) == 3) {
                    return this.element.getVersion();
                }
                return this.element.getArtifactId() + "  (" + this.element.getVersion() + ")";
            }
        }
        throw new IllegalStateException();
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public void markAsDownloaded() {
        this.downloaded = true;
        this.fireIconChange();
        this.fireDisplayNameChange(null, this.getDisplayName());
    }

    private static class Provider
    implements Lookup.Provider {
        private RepoPathGrouper gr;
        private Lookup look;

        public Provider(RepoPathGrouper grouper) {
            this.gr = grouper;
            Object[] els = this.gr.getElements();
            this.look = Lookups.fixed((Object[])els);
        }

        public Lookup getLookup() {
            return this.look;
        }
    }

    private static class RepositoryChildren
    extends Children.Keys {
        private RepoPathGrouper element;
        private Collection keys;

        RepositoryChildren(RepoPathGrouper el) {
            this.element = el;
            this.keys = Collections.EMPTY_LIST;
        }

        protected Node[] createNodes(Object obj) {
            if (obj == LOADING) {
                AbstractNode nd = new AbstractNode(Children.LEAF);
                nd.setName("Loading");
                nd.setDisplayName("Loading...");
                return new Node[]{nd};
            }
            if (obj instanceof String) {
                AbstractNode nd = new AbstractNode(Children.LEAF);
                nd.setName("Error");
                nd.setDisplayName((String)obj);
                return new Node[]{nd};
            }
            if (obj instanceof RepoPathGrouper) {
                return new Node[]{new MultiRepositoryNode((RepoPathGrouper)obj)};
            }
            System.out.println("wrong object..");
            return new Node[0];
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
        }

        protected void addNotify() {
            this.setKeys(Collections.singleton(LOADING));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        RepoPathGrouper[] els = RepositoryChildren.this.element.getChildren();
                        TreeSet<RepoPathGrouper> col = new TreeSet<RepoPathGrouper>(RepoGrouperComparator.getInstance());
                        if (RepositoryChildren.this.element.getLevel() == 2) {
                            for (int i = 0; i < els.length; ++i) {
                                RepoPathGrouper[] childs = els[i].getChildren();
                                if (childs.length == 1) {
                                    col.add(childs[0]);
                                    continue;
                                }
                                col.add(els[i]);
                            }
                        } else {
                            col.addAll(Arrays.asList(els));
                        }
                        RepositoryChildren.this.keys = col;
                        RepositoryChildren.this.setKeys(col);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        RepositoryChildren.this.setKeys(Collections.singleton(exc.getLocalizedMessage()));
                    }
                }
            });
            super.addNotify();
        }
    }
}

