/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.mevenide.netbeans.project.dependencies.LocalRepoRefresher;
import org.mevenide.netbeans.project.dependencies.RepoElementComparator;
import org.mevenide.repository.RepoPathElement;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class RepositoryNode
extends AbstractNode
implements LocalRepoRefresher {
    private static final Object LOADING = new Object();
    private RepoPathElement element;
    private URI root;

    public RepositoryNode(RepoPathElement el) {
        super((Children)(el.isLeaf() ? Children.LEAF : new RepositoryChildren(el)), Lookups.singleton((Object)el));
        this.element = el;
        if (this.element.getLevel() == 1 || this.element.getLevel() == 2) {
            this.setIconBase("org/mevenide/netbeans/project/resources/defaultFolder");
        } else if (this.element.getLevel() == 3) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        } else if (this.element.getLevel() == 4) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        } else {
            this.setIconBase("org/mevenide/netbeans/project/resources/RepositoryRoot");
        }
    }

    public RepositoryNode(RepoPathElement el, URI rootUri) {
        this(el);
        this.root = rootUri;
    }

    public String getDisplayName() {
        return this.createName();
    }

    public int getRepoLevel() {
        return this.element.getLevel();
    }

    public String getHtmlDisplayName() {
        if (this.element.isRemote()) {
            return "<html><b><font color='#9f9a93'>" + this.getDisplayName() + "</font></b></html>";
        }
        return super.getHtmlDisplayName();
    }

    private String createName() {
        switch (this.element.getLevel()) {
            case 0: {
                String str;
                String string = str = this.root == null ? "" : this.root.toString();
                if (str.startsWith("http://")) {
                    return "Remote at " + str;
                }
                return "Local at " + str;
            }
            case 1: {
                return this.element.getGroupId();
            }
            case 2: {
                return this.element.getType();
            }
            case 3: {
                return this.element.getArtifactId();
            }
            case 4: {
                int level;
                Node parent = this.getParentNode();
                if (parent != null && parent instanceof RepositoryNode && (level = ((RepositoryNode)parent).getRepoLevel()) == 3) {
                    return this.element.getVersion();
                }
                return this.element.getArtifactId() + "  (" + this.element.getVersion() + ")";
            }
        }
        throw new IllegalStateException();
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public void markAsDownloaded() {
    }

    public static RepoPathElement generateSameLevelElement(RepoPathElement element, RepoPathElement el) {
        String group = null;
        String type = null;
        String artifact = null;
        String version = null;
        String ext = null;
        if (element.getLevel() == 4) {
            type = el.getType();
            artifact = el.getArtifactId();
            version = el.getVersion();
            ext = el.getExtension();
            group = el.getGroupId();
        } else if (element.getLevel() == 3) {
            type = el.getType();
            artifact = el.getArtifactId();
            group = el.getGroupId();
        } else if (element.getLevel() == 2) {
            type = el.getType();
            group = el.getGroupId();
        } else if (element.getLevel() == 1) {
            group = el.getGroupId();
        }
        return new RepoPathElement(element.getReader(), null, group, type, artifact, version, ext);
    }

    private static class RepositoryChildren
    extends Children.Keys {
        private RepoPathElement element;
        private Collection keys;

        RepositoryChildren(RepoPathElement el) {
            this.element = el;
            this.keys = Collections.EMPTY_LIST;
        }

        protected Node[] createNodes(Object obj) {
            if (obj == LOADING) {
                AbstractNode nd = new AbstractNode(Children.LEAF);
                nd.setName("Loading");
                nd.setDisplayName("Loading...");
                return new Node[]{nd};
            }
            if (obj instanceof String) {
                AbstractNode nd = new AbstractNode(Children.LEAF);
                nd.setName("Error");
                nd.setDisplayName((String)obj);
                return new Node[]{nd};
            }
            if (obj instanceof RepoPathElement) {
                return new Node[]{new RepositoryNode((RepoPathElement)obj)};
            }
            System.out.println("wrong object..");
            return new Node[0];
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
        }

        protected void addNotify() {
            this.setKeys(Collections.singleton(LOADING));
            this.runLoad();
            super.addNotify();
        }

        private void runLoad() {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        RepoPathElement[] els = RepositoryChildren.this.element.getChildren();
                        TreeSet<RepoPathElement> col = new TreeSet<RepoPathElement>(RepoElementComparator.getInstance());
                        if (RepositoryChildren.this.element.getLevel() == 2) {
                            for (int i = 0; i < els.length; ++i) {
                                RepoPathElement[] childs = els[i].getChildren();
                                if (childs.length == 1) {
                                    col.add(childs[0]);
                                    continue;
                                }
                                col.add(els[i]);
                            }
                        } else {
                            col.addAll(Arrays.asList(els));
                        }
                        RepositoryChildren.this.keys = col;
                        RepositoryChildren.this.setKeys(col);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace(System.err);
                        String loc = exc.getLocalizedMessage();
                        if (loc != null) {
                            RepositoryChildren.this.setKeys(Collections.singleton(loc));
                        }
                        RepositoryChildren.this.setKeys(Collections.EMPTY_SET);
                    }
                }
            });
        }
    }
}

