/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.exec;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.goals.grabber.IGoalsGrabber;
import org.mevenide.netbeans.project.goals.GoalNameCookie;
import org.mevenide.netbeans.project.goals.GoalsGrabberProvider;
import org.mevenide.netbeans.project.goals.GoalsRootNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CustomGoalsPanel
extends JPanel {
    private static final Log logger = LogFactory.getLog((Class)CustomGoalsPanel.class);
    public static final String ACTION_GOALS_CHANGED = "GoalsChanged";
    private GoalsGrabberProvider provider;
    private List actionListeners = new ArrayList();
    private ExplorerPanel epGoals;
    private JLabel lblDescription;
    private JLabel lblEnter;
    private JLabel lblGoals;
    private JTextArea taDescription;
    private BeanTreeView tvGoals;
    private JTextField txtEnter;
    static /* synthetic */ Class class$org$mevenide$netbeans$project$goals$GoalNameCookie;

    public CustomGoalsPanel(GoalsGrabberProvider goalsProvider) {
        this.initComponents();
        this.provider = goalsProvider;
        this.tvGoals.setSelectionMode(4);
        this.tvGoals.setRootVisible(false);
        this.txtEnter.setText("");
        this.txtEnter.getDocument().addDocumentListener(new DocListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener listener) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener listener) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionEvent(ActionEvent event) {
        if (this.actionListeners.size() > 0) {
            ArrayList listeners = new ArrayList();
            List list = this.actionListeners;
            synchronized (list) {
                listeners.addAll(this.actionListeners);
            }
            if (listeners.size() > 0) {
                Iterator it = listeners.iterator();
                while (it.hasNext()) {
                    ActionListener list2 = (ActionListener)it.next();
                    list2.actionPerformed(event);
                }
            }
        }
    }

    public String getGoalsToExecute() {
        return this.txtEnter.getText();
    }

    public void setGoalsToExecute(String goals) {
        this.txtEnter.setText(goals);
        this.txtEnter.setSelectionStart(0);
        this.txtEnter.setSelectionEnd(goals.length());
    }

    private void initComponents() {
        this.lblEnter = new JLabel();
        this.txtEnter = new JTextField();
        this.lblGoals = new JLabel();
        this.epGoals = new ExplorerPanel();
        this.tvGoals = new BeanTreeView();
        this.lblDescription = new JLabel();
        this.taDescription = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.lblEnter.setLabelFor(this.txtEnter);
        this.lblEnter.setText("Enter goal(s) :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblEnter, gridBagConstraints);
        this.txtEnter.setMinimumSize(new Dimension(60, 28));
        this.txtEnter.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.txtEnter, gridBagConstraints);
        this.lblGoals.setLabelFor((Component)this.epGoals);
        this.lblGoals.setText("Available Goals:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblGoals, gridBagConstraints);
        this.epGoals.setMinimumSize(new Dimension(150, 100));
        this.tvGoals.setPreferredSize(new Dimension(400, 323));
        this.epGoals.add((Component)this.tvGoals, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.epGoals, gridBagConstraints);
        this.lblDescription.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblDescription, gridBagConstraints);
        this.taDescription.setEditable(false);
        this.taDescription.setLineWrap(true);
        this.taDescription.setRows(2);
        this.taDescription.setTabSize(4);
        this.taDescription.setWrapStyleWord(true);
        this.taDescription.setMinimumSize(new Dimension(50, 24));
        this.taDescription.setPreferredSize(new Dimension(100, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.taDescription, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        this.epGoals.getExplorerManager().setRootContext(this.createLoadingNode());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    final IGoalsGrabber grabber = CustomGoalsPanel.this.provider.getGoalsGrabber();
                    if (grabber == null) {
                        logger.error((Object)"No grabber");
                        throw new Exception("no grabber");
                    }
                    grabber.refresh();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CustomGoalsPanel.this.epGoals.getExplorerManager().setRootContext((Node)new GoalsRootNode(grabber));
                        }
                    });
                }
                catch (Exception exc) {
                    ErrorManager.getDefault().notify((Throwable)exc);
                    logger.error((Object)"Error while retrieving goals", (Throwable)exc);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CustomGoalsPanel.this.epGoals.getExplorerManager().setRootContext(CustomGoalsPanel.this.createNoGoalsNode());
                        }
                    });
                }
            }
        });
        this.epGoals.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new PropListener());
    }

    private Node createLoadingNode() {
        Children.Array childs = new Children.Array();
        AbstractNode loading = new AbstractNode(Children.LEAF);
        loading.setName("Loading");
        loading.setDisplayName(NbBundle.getBundle((Class)CustomGoalsPanel.class).getString("Loading"));
        childs.add(new Node[]{loading});
        return new AbstractNode((Children)childs);
    }

    private Node createNoGoalsNode() {
        Children.Array childs = new Children.Array();
        AbstractNode node = new AbstractNode(Children.LEAF);
        node.setName("NoGoals");
        node.setDisplayName(NbBundle.getBundle((Class)CustomGoalsPanel.class).getString("NoGoals"));
        childs.add(new Node[]{node});
        return new AbstractNode((Children)childs);
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.generateActionEvent();
        }

        public void insertUpdate(DocumentEvent e) {
            this.generateActionEvent();
        }

        public void removeUpdate(DocumentEvent e) {
            this.generateActionEvent();
        }

        private void generateActionEvent() {
            ActionEvent newEvent = new ActionEvent(CustomGoalsPanel.this, 1001, CustomGoalsPanel.ACTION_GOALS_CHANGED);
            CustomGoalsPanel.this.fireActionEvent(newEvent);
        }
    }

    private class PropListener
    implements PropertyChangeListener {
        private PropListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] nds = CustomGoalsPanel.this.epGoals.getExplorerManager().getSelectedNodes();
                StringBuffer goals = new StringBuffer();
                for (int i = 0; i < nds.length; ++i) {
                    GoalNameCookie cook = (GoalNameCookie)nds[i].getCookie(class$org$mevenide$netbeans$project$goals$GoalNameCookie == null ? CustomGoalsPanel.class$("org.mevenide.netbeans.project.goals.GoalNameCookie") : class$org$mevenide$netbeans$project$goals$GoalNameCookie);
                    if (cook == null) continue;
                    goals.append(cook.getGoalName());
                    goals.append(" ");
                    if (i != nds.length - 1) continue;
                    CustomGoalsPanel.this.taDescription.setText(nds[i].getShortDescription());
                }
                if (nds.length == 0) {
                    CustomGoalsPanel.this.taDescription.setText("");
                }
                int currPos = CustomGoalsPanel.this.txtEnter.getCaretPosition();
                int length = goals.length();
                String currSelected = CustomGoalsPanel.this.txtEnter.getSelectedText();
                int selStart = currSelected == null ? currPos : CustomGoalsPanel.this.txtEnter.getSelectionStart();
                int selEnd = currSelected == null ? currPos : CustomGoalsPanel.this.txtEnter.getSelectionEnd();
                logger.debug((Object)("selstart=" + selStart + "  selEnd=" + selEnd));
                String text = CustomGoalsPanel.this.txtEnter.getText();
                if (selStart > 0) {
                    goals.insert(0, text.substring(0, selStart));
                }
                if (selEnd < text.length()) {
                    goals.append(text.substring(selEnd + 1));
                }
                CustomGoalsPanel.this.txtEnter.setText(goals.toString());
                CustomGoalsPanel.this.txtEnter.setCaretPosition(selStart + length);
                CustomGoalsPanel.this.txtEnter.setSelectionStart(selStart);
                CustomGoalsPanel.this.txtEnter.setSelectionEnd(selStart + length);
            }
        }
    }
}

