/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.exec;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.OutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.project.exec.RunConfig;
import org.mevenide.netbeans.project.exec.RunContext;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.MapFormat;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class MavenExecutor
implements Runnable {
    private static final Log logger = LogFactory.getLog((Class)MavenExecutor.class);
    public static final String FORMAT_MAVEN_HOME = "MAVEN_HOME";
    public static final String FORMAT_GOAL = "goal";
    public static final String FORMAT_OFFLINE = "offline";
    public static final String FORMAT_NOBANNER = "nobanner";
    public static final String FORMAT_DEBUG = "debug";
    public static final String FORMAT_EXCEPTIONS = "exceptions";
    public static final String FORMAT_NONVERBOSE = "nonverbose";
    public static final String FORMAT_DOWNLOADMETER = "downloadmeter";
    private String goal = "dist";
    private String meter = "silent";
    private static final long serialVersionUID = 7564737833872873L;
    private RunContext context;
    private Process proces;
    private String format;
    private InputOutput io;
    private Set processors;
    private RunConfig config;
    private static RequestProcessor PROCESSOR = new RequestProcessor("maven execution", 3);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$windows$OutputListener;
    static /* synthetic */ Class class$org$openide$windows$OutputWriter;

    public MavenExecutor(RunContext proj, String gl, Set procs, RunConfig conf) {
        this.context = proj;
        this.goal = gl;
        this.processors = procs;
        this.config = conf;
        StringBuffer mavenExeFmt = new StringBuffer();
        if (Utilities.isWindows()) {
            mavenExeFmt.append("\"{");
        } else {
            mavenExeFmt.append("{");
        }
        mavenExeFmt.append(FORMAT_MAVEN_HOME);
        mavenExeFmt.append("}/bin/");
        if (Utilities.isWindows()) {
            mavenExeFmt.append("maven.bat\"");
        } else {
            mavenExeFmt.append("maven");
        }
        mavenExeFmt.append(" {");
        mavenExeFmt.append(FORMAT_NOBANNER);
        mavenExeFmt.append("} {");
        mavenExeFmt.append(FORMAT_OFFLINE);
        mavenExeFmt.append("} {");
        mavenExeFmt.append(FORMAT_DEBUG);
        mavenExeFmt.append("} {");
        mavenExeFmt.append(FORMAT_EXCEPTIONS);
        mavenExeFmt.append("} {");
        mavenExeFmt.append(FORMAT_NONVERBOSE);
        mavenExeFmt.append("} {");
        mavenExeFmt.append(FORMAT_DOWNLOADMETER);
        mavenExeFmt.append("} {");
        mavenExeFmt.append(FORMAT_GOAL);
        mavenExeFmt.append("}");
        this.format = mavenExeFmt.toString();
    }

    public void setDownloadMeter(String met) {
        this.meter = met;
    }

    public Process createProcess() throws IOException {
        Process proc;
        File execDir = this.context.getExecutionDirectory();
        String[] additionals = this.context.getAdditionalParams();
        HashMap<String, String> formats = new HashMap<String, String>(5);
        formats.put(FORMAT_MAVEN_HOME, this.context.getMavenHome());
        if (additionals.length > 0) {
            formats.put(FORMAT_GOAL, "");
            formats.put(FORMAT_OFFLINE, "");
            formats.put(FORMAT_NOBANNER, "");
            formats.put(FORMAT_DEBUG, "");
            formats.put(FORMAT_EXCEPTIONS, "");
            formats.put(FORMAT_NONVERBOSE, "");
            formats.put(FORMAT_DOWNLOADMETER, "");
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(MapFormat.format((String)this.format, formats).trim());
            if (this.config.isOffline()) {
                lst.add("--offline");
            }
            if (this.config.isNoBanner()) {
                lst.add("--nobanner");
            }
            if (this.config.isDebug()) {
                lst.add("-X");
            }
            if (this.config.isExceptions()) {
                lst.add("--exception");
            }
            if (this.config.isNonverbose()) {
                lst.add("--quiet");
            }
            if (!this.config.isOffline() && !"default".equals(this.meter)) {
                lst.add("-Dmaven.download.meter=" + this.meter);
            }
            lst.addAll(Arrays.asList(additionals));
            String[] prcs = new String[lst.size()];
            prcs = lst.toArray(prcs);
            proc = Runtime.getRuntime().exec(prcs, null, execDir);
        } else {
            formats.put(FORMAT_GOAL, this.goal);
            formats.put(FORMAT_OFFLINE, this.config.isOffline() ? "--offline" : "");
            formats.put(FORMAT_NOBANNER, this.config.isNoBanner() ? "--nobanner" : "");
            formats.put(FORMAT_DEBUG, this.config.isDebug() ? "-X" : "");
            formats.put(FORMAT_EXCEPTIONS, this.config.isExceptions() ? "--exception" : "");
            formats.put(FORMAT_NONVERBOSE, this.config.isNonverbose() ? "--quiet" : "");
            if (!this.config.isOffline()) {
                formats.put(FORMAT_DOWNLOADMETER, "default".equals(this.meter) ? "" : "-Dmaven.download.meter=" + this.meter);
            } else {
                formats.put(FORMAT_DOWNLOADMETER, "");
            }
            String prc = MapFormat.format((String)this.format, formats).trim();
            proc = Runtime.getRuntime().exec(prc, null, execDir);
        }
        return proc;
    }

    private InputOutput createInputOutput() {
        InputOutput newio = IOProvider.getDefault().getIO(this.context.getExecutionName(), false);
        newio.setErrSeparated(false);
        try {
            newio.getOut().reset();
        }
        catch (IOException exc) {
            logger.error((Object)"Cannot reset InputOutput", (Throwable)exc);
        }
        return newio;
    }

    public InputOutput getInputOutput() {
        if (this.io == null) {
            this.io = this.createInputOutput();
        }
        return this.io;
    }

    public void setCustomInputOutput(InputOutput inout) {
        this.io = inout;
    }

    public void run() {
        try {
            this.proces = this.createProcess();
            InputOutput ioput = this.getInputOutput();
            OutputProcessor[] providers = new OutputProcessor[this.processors.size()];
            providers = this.processors.toArray(providers);
            Output out = new Output(this.proces.getInputStream(), ioput.getOut(), providers);
            Output err = new Output(this.proces.getErrorStream(), ioput.getErr(), providers);
            RequestProcessor.Task outTask = PROCESSOR.post((Runnable)out);
            RequestProcessor.Task errTask = PROCESSOR.post((Runnable)err);
            this.proces.waitFor();
            outTask.waitFinished();
            errTask.waitFinished();
            if (out.wasSuccessfull()) {
                ArrayList succActions = new ArrayList();
                succActions.addAll(out.getSuccessActions() != null ? out.getSuccessActions() : Collections.EMPTY_LIST);
                succActions.addAll(err.getSuccessActions() != null ? err.getSuccessActions() : Collections.EMPTY_LIST);
                if (succActions.size() > 0) {
                    Action action = null;
                    if (succActions.size() == 1) {
                        action = (Action)succActions.iterator().next();
                    } else {
                        int maxPriotity = -1;
                        Iterator it = succActions.iterator();
                        while (it.hasNext()) {
                            Action act = (Action)it.next();
                            Integer priority = (Integer)act.getValue("Priority");
                            if (priority <= maxPriotity) continue;
                            action = act;
                            maxPriotity = priority;
                        }
                    }
                    String question = (String)action.getValue("Question");
                    String title = (String)action.getValue("ShortDescription");
                    if (question != null) {
                        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)question, title == null ? "" : title, 2, 3);
                        Object returned = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        if (NotifyDescriptor.OK_OPTION.equals(returned)) {
                            action.actionPerformed(new ActionEvent(this, 1001, "Performed"));
                        }
                    } else {
                        action.actionPerformed(new ActionEvent(this, 1001, "Performed"));
                    }
                }
            }
        }
        catch (IOException io) {
            ErrorManager.getDefault().notify((Throwable)io);
        }
        catch (InterruptedException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
        }
    }

    private static class Output
    implements Runnable {
        private InputStream str;
        private OutputWriter writer;
        private OutputProcessor[] providers;
        private List successActions;
        private boolean success = false;
        private boolean failed = false;

        public Output(InputStream instream, OutputWriter out, OutputProcessor[] provs) {
            this.str = instream;
            this.writer = out;
            this.providers = provs;
            this.successActions = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader read = new BufferedReader(new InputStreamReader(this.str), 50);
            OutputVisitor visitor = new OutputVisitor();
            Method method = null;
            try {
                Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MavenExecutor.class$("java.lang.String")) : class$java$lang$String, class$org$openide$windows$OutputListener == null ? (class$org$openide$windows$OutputListener = MavenExecutor.class$("org.openide.windows.OutputListener")) : class$org$openide$windows$OutputListener, Boolean.TYPE};
                method = (class$org$openide$windows$OutputWriter == null ? (class$org$openide$windows$OutputWriter = MavenExecutor.class$("org.openide.windows.OutputWriter")) : class$org$openide$windows$OutputWriter).getMethod("println", params);
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                String line;
                while ((line = read.readLine()) != null) {
                    if (line.equals("BUILD SUCCESSFUL")) {
                        this.success = true;
                    }
                    if (line.equals("BUILD FAILED")) {
                        this.failed = true;
                    }
                    visitor.resetVisitor();
                    if (this.providers != null) {
                        for (int i = 0; i < this.providers.length; ++i) {
                            this.providers[i].processLine(line, visitor);
                        }
                    }
                    if (visitor.getOutputListener() == null) {
                        this.writer.println(line);
                    } else if (method != null) {
                        try {
                            Object[] objs = new Object[]{line, visitor.getOutputListener(), visitor.isImportant()};
                            method.invoke((Object)this.writer, objs);
                        }
                        catch (Exception exc) {
                            logger.error((Object)"Error while doing reflection", (Throwable)exc);
                        }
                    } else {
                        this.writer.println(line, visitor.getOutputListener());
                    }
                    if (visitor.getSuccessAction() != null) {
                        this.successActions.add(visitor.getSuccessAction());
                    }
                    this.writer.flush();
                }
                read.close();
            }
            catch (IOException io) {
                logger.error((Object)io);
            }
            finally {
                try {
                    read.close();
                    this.writer.close();
                }
                catch (IOException ioexc) {
                    logger.error((Object)ioexc);
                }
            }
        }

        public List getSuccessActions() {
            return this.successActions;
        }

        public boolean wasSuccessfull() {
            return this.success;
        }

        public boolean wasFailed() {
            return this.failed;
        }
    }
}

