/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Build;
import org.apache.maven.project.Project;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.nodes.DocsRootNode;
import org.mevenide.netbeans.project.nodes.EarFilterNode;
import org.mevenide.netbeans.project.nodes.EjbFilterNode;
import org.mevenide.netbeans.project.nodes.PluginScriptNode;
import org.mevenide.netbeans.project.nodes.ResourcesRootNode;
import org.mevenide.netbeans.project.nodes.WebAppFilterNode;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

class MavenProjectChildren
extends Children.Keys {
    private static final Log logger = LogFactory.getLog((Class)MavenProjectChildren.class);
    private static final String KEY_JELLY_SCRIPT = "jellyScript";
    private static final String KEY_RESOURCES = "resources";
    private static final String KEY_TEST_RESOURCES = "testresources";
    private static final String KEY_WEBAPP = "webapp";
    private static final String KEY_EAR = "ear";
    private static final String KEY_EJB = "ejb";
    private MavenProject project;
    private PropertyChangeListener changeListener;
    private String currentWebAppKey;
    private String currentEarKey;
    private String currentEjbKey;

    public MavenProjectChildren(MavenProject project) {
        this.project = project;
        this.changeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    logger.debug((Object)"regenerating project children keys");
                    MavenProjectChildren.this.regenerateKeys();
                    MavenProjectChildren.this.refresh();
                }
            }
        };
    }

    protected void addNotify() {
        super.addNotify();
        this.project.addPropertyChangeListener(this.changeListener);
        this.regenerateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.project.removePropertyChangeListener(this.changeListener);
        super.removeNotify();
    }

    private void regenerateKeys() {
        FileObject fo;
        Project proj;
        Build build;
        URI ejb;
        URI ear;
        ArrayList<Object> list = new ArrayList<Object>();
        Sources srcs = (Sources)this.project.getLookup().lookup(Sources.class);
        if (srcs == null) {
            throw new IllegalStateException("need Sources instance in lookup");
        }
        SourceGroup[] javagroup = srcs.getSourceGroups("java");
        for (int i = 0; i < javagroup.length; ++i) {
            list.add(javagroup[i]);
        }
        SourceGroup[] gengroup = srcs.getSourceGroups("GeneratedSources");
        for (int i = 0; i < gengroup.length; ++i) {
            list.add(gengroup[i]);
        }
        URI webapp = this.project.getWebAppDirectory();
        if (webapp != null) {
            this.currentWebAppKey = KEY_WEBAPP + webapp;
            list.add(this.currentWebAppKey);
        }
        if ((ear = this.project.getEarDirectory()) != null) {
            this.currentEarKey = KEY_EAR + ear;
            list.add(this.currentEarKey);
        }
        if ((ejb = this.project.getEjbDirectory()) != null) {
            this.currentEjbKey = KEY_EJB + ejb;
            list.add(this.currentEjbKey);
        }
        if ((build = (proj = this.project.getOriginalMavenProject()).getBuild()) != null) {
            List testlst;
            List reso = build.getResources();
            if (reso != null && reso.size() > 0) {
                list.add(KEY_RESOURCES);
            }
            if (build.getUnitTest() != null && (testlst = build.getUnitTest().getResources()) != null && testlst.size() > 0) {
                list.add(KEY_TEST_RESOURCES);
            }
        }
        if ((fo = this.project.getProjectDirectory().getFileObject("plugin", "jelly")) != null) {
            list.add(KEY_JELLY_SCRIPT);
        }
        SourceGroup[] xdocsgroup = srcs.getSourceGroups("XDocs");
        for (int i = 0; i < xdocsgroup.length; ++i) {
            list.add(xdocsgroup[i]);
        }
        this.setKeys(list);
    }

    protected Node[] createNodes(Object key) {
        Node[] nodeArray;
        AbstractNode n = null;
        if (key instanceof SourceGroup) {
            SourceGroup grp = (SourceGroup)key;
            n = "XDocs".equals(grp.getName()) ? new DocsRootNode(grp, this.project) : PackageView.createPackageView((SourceGroup)grp);
        } else if (key == KEY_JELLY_SCRIPT) {
            n = new PluginScriptNode(this.project.getProjectDirectory());
        } else if (key == KEY_RESOURCES) {
            n = new ResourcesRootNode(this.project, false);
        } else if (key == KEY_TEST_RESOURCES) {
            n = new ResourcesRootNode(this.project, true);
        } else if (key == this.currentWebAppKey) {
            n = this.createWebAppNode();
        } else if (key == this.currentEarKey) {
            n = this.createEarNode();
        } else if (key == this.currentEjbKey) {
            n = this.createEjbNode();
        }
        if (n == null) {
            nodeArray = new Node[]{};
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = n;
        }
        return nodeArray;
    }

    private DataFolder getFolder(String relPath) {
        FileObject folder = FileUtilities.findFolder(this.project.getProjectDirectory(), relPath);
        if (folder != null) {
            return DataFolder.findFolder((FileObject)folder);
        }
        return null;
    }

    private DataFolder getFolder(URI path) {
        try {
            FileObject folder = URLMapper.findFileObject((URL)path.toURL());
            if (folder != null) {
                return DataFolder.findFolder((FileObject)folder);
            }
        }
        catch (MalformedURLException exc) {
            logger.warn((Object)("malformed URI=" + path), (Throwable)exc);
        }
        return null;
    }

    private Node createWebAppNode() {
        WebAppFilterNode n = null;
        try {
            FileObject fo = URLMapper.findFileObject((URL)this.project.getWebAppDirectory().toURL());
            if (fo != null) {
                DataFolder fold = DataFolder.findFolder((FileObject)fo);
                File fil = FileUtil.toFile((FileObject)fo);
                if (fold != null) {
                    n = new WebAppFilterNode(this.project, fold.getNodeDelegate().cloneNode(), fil);
                }
            }
        }
        catch (MalformedURLException exc) {
            logger.debug((Object)"malformed webapp rootfile url", (Throwable)exc);
            n = null;
        }
        return n;
    }

    private Node createEarNode() {
        EarFilterNode n = null;
        try {
            FileObject fo = URLMapper.findFileObject((URL)this.project.getEarDirectory().toURL());
            if (fo != null) {
                DataFolder fold = DataFolder.findFolder((FileObject)fo);
                File fil = FileUtil.toFile((FileObject)fo);
                if (fold != null) {
                    n = new EarFilterNode(this.project, fold.getNodeDelegate().cloneNode(), fil);
                }
            }
        }
        catch (MalformedURLException exc) {
            logger.debug((Object)"malformed ear rootfile url", (Throwable)exc);
            n = null;
        }
        return n;
    }

    private Node createEjbNode() {
        EjbFilterNode n = null;
        try {
            FileObject fo = URLMapper.findFileObject((URL)this.project.getEjbDirectory().toURL());
            if (fo != null) {
                DataFolder fold = DataFolder.findFolder((FileObject)fo);
                File fil = FileUtil.toFile((FileObject)fo);
                if (fold != null) {
                    n = new EjbFilterNode(this.project, fold.getNodeDelegate().cloneNode(), fil);
                }
            }
        }
        catch (MalformedURLException exc) {
            logger.debug((Object)"malformed ejb rootfile url", (Throwable)exc);
            n = null;
        }
        return n;
    }
}

