/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.mevenide.plugins.ICustomPluginLoader;
import org.mevenide.plugins.PluginProperty;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public final class NbCustomPluginLoaderImpl
implements ICustomPluginLoader {
    private static Log logger = LogFactory.getLog((Class)NbCustomPluginLoaderImpl.class);
    private static final String ROOT = "Plugins/Maven/PluginProperties";

    public PluginProperty[] loadProperties(String plugin, String version, boolean exactMatch) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject root = fs.findResource(ROOT);
        String match = plugin + "-" + version;
        if (root != null) {
            Enumeration en = root.getChildren(false);
            FileObject candidate = null;
            while (en.hasMoreElements()) {
                FileObject fo = (FileObject)en.nextElement();
                String name = fo.getName();
                if (exactMatch && name.equalsIgnoreCase(match)) {
                    candidate = fo;
                    break;
                }
                if (exactMatch || !name.startsWith(plugin)) continue;
                String vers = name.substring(plugin.length() + 1);
                candidate = fo;
            }
            if (candidate != null) {
                return this.loadProps(candidate);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginProperty[] loadProps(FileObject fo) {
        ArrayList<PluginProperty> toReturn = null;
        InputStream stream = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            stream = fo.getInputStream();
            Document document = builder.build(stream);
            Element root = document.getRootElement();
            List categories = root.getChildren("category");
            Iterator it = categories.iterator();
            toReturn = new ArrayList<PluginProperty>();
            while (it.hasNext()) {
                Element cat = (Element)it.next();
                List props = cat.getChildren("property");
                Iterator it2 = props.iterator();
                while (it2.hasNext()) {
                    Element pr = (Element)it2.next();
                    PluginProperty prop = new PluginProperty(pr.getAttributeValue("name"), pr.getAttributeValue("label"), pr.getAttributeValue("default"), Boolean.getBoolean(pr.getAttributeValue("required")), pr.getAttributeValue("description"));
                    toReturn.add(prop);
                }
            }
        }
        catch (Exception exc) {
            logger.error((Object)("Exception while reading file " + fo.getPath()), (Throwable)exc);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException x) {
                    logger.error((Object)"Cannot close", (Throwable)x);
                }
            }
        }
        if (toReturn != null) {
            PluginProperty[] ret = new PluginProperty[toReturn.size()];
            return toReturn.toArray(ret);
        }
        return null;
    }
}

