/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Dependency;
import org.apache.tools.ant.DirectoryScanner;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.queries.MavenFileOwnerQueryImpl;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class SubprojectProviderImpl
implements SubprojectProvider {
    private static final Log logger = LogFactory.getLog((Class)SubprojectProviderImpl.class);
    private static final String MULTIPROJECT_INCLUDES = "maven.multiproject.includes";
    private static final String MULTIPROJECT_EXCLUDES = "maven.multiproject.excludes";
    private static final String MULTIPROJECT_BASEDIR = "maven.multiproject.basedir";
    private MavenProject project;
    private List listeners;
    private ChangeListener listener2;

    public SubprojectProviderImpl(MavenProject proj) {
        this.project = proj;
        this.listeners = new ArrayList();
        proj.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SubprojectProviderImpl.this.fireChange();
            }
        });
        this.listener2 = new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                SubprojectProviderImpl.this.fireChange();
            }
        };
        MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
    }

    public Set getSubprojects() {
        File basefile;
        logger.debug((Object)"getSubProjects()");
        String includes = this.project.getPropertyResolver().getResolvedValue(MULTIPROJECT_INCLUDES);
        String excludes = this.project.getPropertyResolver().getResolvedValue(MULTIPROJECT_EXCLUDES);
        String basedir = this.project.getPropertyResolver().getResolvedValue(MULTIPROJECT_BASEDIR);
        int includesLocation = this.project.getPropertyLocator().getPropertyLocation(MULTIPROJECT_INCLUDES);
        HashSet<Project> projects = new HashSet<Project>();
        if (includes != null && includesLocation > -2 && (basefile = FileUtil.normalizeFile((File)new File(basedir))).exists()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(basefile);
            if (excludes != null) {
                String[] exc = StringUtils.split((String)excludes, (String)",");
                scanner.setExcludes(exc);
            }
            String[] inc = StringUtils.split((String)includes, (String)",");
            scanner.setIncludes(inc);
            scanner.scan();
            String[] results = scanner.getIncludedFiles();
            for (int i = 0; i < results.length; ++i) {
                Project proj = this.processOneSubproject(basefile, results[i]);
                if (proj == null || !(proj instanceof MavenProject)) continue;
                projects.add(proj);
            }
        }
        Set opened = MavenFileOwnerQueryImpl.getInstance().getOpenedProjects();
        projects.addAll(opened);
        projects.remove(this.project);
        HashSet<MavenProject> toReturn = new HashSet<MavenProject>();
        Iterator itx = projects.iterator();
        while (itx.hasNext()) {
            String dpVersion;
            MavenProject prj = (MavenProject)itx.next();
            IPropertyResolver prjRes = prj.getPropertyResolver();
            String version = prjRes.resolveString(prj.getOriginalMavenProject().getCurrentVersion());
            String id = prjRes.resolveString(prj.getOriginalMavenProject().getId());
            List deps = this.project.getOriginalMavenProject().getDependencies();
            Dependency dp = null;
            if (deps != null) {
                Iterator it = deps.iterator();
                while (it.hasNext()) {
                    Dependency xx = (Dependency)it.next();
                    if (!id.trim().equals(this.project.getPropertyResolver().resolveString(xx.getId()).trim())) continue;
                    dp = xx;
                    break;
                }
            }
            if (dp == null || (dpVersion = this.project.getPropertyResolver().resolveString(dp.getVersion())) == null || !dpVersion.equals(version) && !"SNAPSHOT".equals(dpVersion)) continue;
            toReturn.add(prj);
        }
        return toReturn;
    }

    private Project processOneSubproject(File basefile, String relPath) {
        File projectFile = FileUtil.normalizeFile((File)new File(basefile.getAbsolutePath() + File.separator + relPath));
        if (projectFile.exists()) {
            FileObject projectDir = FileUtil.toFileObject((File)projectFile);
            if (projectDir != null) {
                projectDir = projectDir.getParent();
                if (this.project.getProjectDirectory().equals(projectDir)) {
                    return null;
                }
                if (ProjectManager.getDefault().isProject(projectDir)) {
                    try {
                        Project proj = ProjectManager.getDefault().findProject(projectDir);
                        return proj;
                    }
                    catch (IOException exc) {
                        logger.debug((Object)"IO exc. while loading project", (Throwable)exc);
                    }
                }
            } else {
                logger.debug((Object)("fileobject not found=" + relPath + " in basedir=" + basefile));
            }
        } else {
            logger.debug((Object)("project file not found=" + relPath + " in basedir=" + basefile));
        }
        return null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList lists = new ArrayList();
        SubprojectProviderImpl subprojectProviderImpl = this;
        synchronized (subprojectProviderImpl) {
            lists.addAll(this.listeners);
        }
        Iterator it = lists.iterator();
        while (it.hasNext()) {
            ChangeListener listener = (ChangeListener)it.next();
            listener.stateChanged(new ChangeEvent(this));
        }
    }
}

