/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.classpath;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.Build;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.project.Resource;
import org.apache.maven.project.UnitTest;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.classpath.AbstractProjectClassPathImpl;
import org.openide.filesystems.FileUtil;

public class TestSrcRuntimeClassPathImpl
extends AbstractProjectClassPathImpl {
    public TestSrcRuntimeClassPathImpl(MavenProject proj) {
        super(proj);
    }

    URI[] createPath() {
        Build build;
        Iterator it;
        ArrayList<URI> lst = new ArrayList<URI>();
        Project mavproj = this.getMavenProject().getOriginalMavenProject();
        lst.add(this.getMavenProject().getBuildClassesDir());
        URI tests = this.getMavenProject().getTestBuildClassesDir();
        if (tests != null) {
            lst.add(tests);
        }
        boolean junitIncluded = false;
        List deps = mavproj.getDependencies();
        Iterator iterator = it = deps != null ? deps.iterator() : Collections.EMPTY_LIST.iterator();
        while (it.hasNext()) {
            Dependency dep = (Dependency)it.next();
            URI uri = this.checkOneDependency(dep);
            if (uri == null) continue;
            lst.add(uri);
            if (!"junit".equals(dep.getId())) continue;
            junitIncluded = true;
        }
        if (!junitIncluded) {
            String[] junitList;
            String repo = this.getMavenProject().getLocFinder().getMavenLocalRepository();
            repo = repo.endsWith("\\") || repo.endsWith("/") ? repo : repo + File.separator;
            File dir = new File(repo = repo + "junit/jars");
            if (dir.exists() && (junitList = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith("junit-") && name.endsWith(".jar");
                }
            })) != null && junitList.length > 0) {
                String latest = junitList[0];
                if (junitList.length > 1) {
                    for (int i = 1; i < junitList.length; ++i) {
                        if (latest.compareTo(junitList[i]) >= 0) continue;
                        latest = junitList[i];
                    }
                }
                File fil = new File(dir, latest);
                URI uri = (fil = FileUtil.normalizeFile((File)fil)).toURI();
                if (uri != null) {
                    lst.add(uri);
                }
            }
        }
        if ((build = mavproj.getBuild()) != null) {
            List resources = build.getResources();
            Iterator iterator2 = it = resources != null ? resources.iterator() : Collections.EMPTY_LIST.iterator();
            while (it.hasNext()) {
                Resource res = (Resource)it.next();
                URI uri = this.checkOneResource(res);
                if (uri == null) continue;
                lst.add(uri);
            }
            UnitTest test = build.getUnitTest();
            if (test != null) {
                resources = test.getResources();
                Iterator iterator3 = it = resources != null ? resources.iterator() : Collections.EMPTY_LIST.iterator();
                while (it.hasNext()) {
                    Resource res = (Resource)it.next();
                    URI uri = this.checkOneResource(res);
                    if (uri == null) continue;
                    lst.add(uri);
                }
            }
        }
        URI[] uris = new URI[lst.size()];
        uris = lst.toArray(uris);
        return uris;
    }
}

