/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.customizer.changes.MavenChange;
import org.mevenide.netbeans.api.customizer.changes.TextComponentPOMChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.openide.util.NbBundle;

public class BasicsPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)BasicsPanel.class);
    private ProjectValidateObserver valObserver;
    private DocumentListener listener;
    private MavenProject project;
    private OriginChange ocID;
    private OriginChange ocArtifactID;
    private OriginChange ocGroupID;
    private OriginChange ocPackage;
    private OriginChange ocCurrentVersion;
    private OriginChange ocName;
    private HashMap changes;
    private boolean initialized;
    private JButton btnArtifactID;
    private JButton btnCurrentVersion;
    private JButton btnGroupID;
    private JButton btnId;
    private JButton btnName;
    private JButton btnPackage;
    private JPanel jPanel1;
    private JLabel lblArtifactID;
    private JLabel lblCurrentVersion;
    private JLabel lblGroupID;
    private JLabel lblId;
    private JLabel lblName;
    private JLabel lblPackage;
    private JTextField txtArtifactID;
    private JTextField txtCurrentVersion;
    private JTextField txtGroupID;
    private JTextField txtId;
    private JTextField txtName;
    private JTextField txtPackage;

    public BasicsPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        String idWarning = "The id element in the POM is deprecated. Please use artifactId and groupId elements instead.";
        this.txtId.setToolTipText(idWarning);
        this.lblId.setToolTipText(idWarning);
        this.valObserver = null;
        this.setName(NbBundle.getMessage((Class)BasicsPanel.class, (String)"BasicsPanel.name"));
        this.initialized = false;
    }

    private void initComponents() {
        this.lblId = new JLabel();
        this.txtId = new JTextField();
        this.ocID = LocationComboFactory.createPOMChange(this.project, false);
        this.btnId = (JButton)this.ocID.getComponent();
        this.lblArtifactID = new JLabel();
        this.txtArtifactID = new JTextField();
        this.ocArtifactID = LocationComboFactory.createPOMChange(this.project, false);
        this.btnArtifactID = (JButton)this.ocArtifactID.getComponent();
        this.lblGroupID = new JLabel();
        this.txtGroupID = new JTextField();
        this.ocGroupID = LocationComboFactory.createPOMChange(this.project, false);
        this.btnGroupID = (JButton)this.ocGroupID.getComponent();
        this.lblCurrentVersion = new JLabel();
        this.txtCurrentVersion = new JTextField();
        this.ocCurrentVersion = LocationComboFactory.createPOMChange(this.project, false);
        this.btnCurrentVersion = (JButton)this.ocCurrentVersion.getComponent();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.ocName = LocationComboFactory.createPOMChange(this.project, false);
        this.btnName = (JButton)this.ocName.getComponent();
        this.lblPackage = new JLabel();
        this.txtPackage = new JTextField();
        this.ocPackage = LocationComboFactory.createPOMChange(this.project, false);
        this.btnPackage = (JButton)this.ocPackage.getComponent();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblId.setLabelFor(this.txtId);
        this.lblId.setText("ID :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.txtId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.btnId, gridBagConstraints);
        this.lblArtifactID.setLabelFor(this.txtArtifactID);
        this.lblArtifactID.setText(NbBundle.getMessage((Class)BasicsPanel.class, (String)"BasicsPanel.lblArtifactID.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblArtifactID, gridBagConstraints);
        this.txtArtifactID.setMinimumSize(new Dimension(30, 26));
        this.txtArtifactID.setPreferredSize(new Dimension(30, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtArtifactID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnArtifactID, gridBagConstraints);
        this.lblGroupID.setLabelFor(this.txtGroupID);
        this.lblGroupID.setText(NbBundle.getMessage((Class)BasicsPanel.class, (String)"BasicsPanel.lblGroupID.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblGroupID, gridBagConstraints);
        this.txtGroupID.setMinimumSize(new Dimension(30, 26));
        this.txtGroupID.setPreferredSize(new Dimension(30, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtGroupID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnGroupID, gridBagConstraints);
        this.lblCurrentVersion.setLabelFor(this.txtCurrentVersion);
        this.lblCurrentVersion.setText(NbBundle.getMessage((Class)BasicsPanel.class, (String)"BasicsPanel.lblCurrentVersion.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblCurrentVersion, gridBagConstraints);
        this.txtCurrentVersion.setMinimumSize(new Dimension(30, 26));
        this.txtCurrentVersion.setPreferredSize(new Dimension(30, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtCurrentVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnCurrentVersion, gridBagConstraints);
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText(NbBundle.getMessage((Class)BasicsPanel.class, (String)"BasicsPanel.lblName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setMinimumSize(new Dimension(30, 26));
        this.txtName.setPreferredSize(new Dimension(30, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 3, 0, 0);
        this.add((Component)this.txtName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnName, gridBagConstraints);
        this.lblPackage.setLabelFor(this.txtPackage);
        this.lblPackage.setText(NbBundle.getMessage((Class)BasicsPanel.class, (String)"BasicsPanel.lblPackage.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblPackage, gridBagConstraints);
        this.txtPackage.setMinimumSize(new Dimension(50, 26));
        this.txtPackage.setPreferredSize(new Dimension(50, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtPackage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add((Component)this.btnPackage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        String value = this.project.getOriginalMavenProject().getId();
        int location = this.project.getProjectWalker().getLocation("pom.id");
        if (value == null) {
            value = "";
        }
        this.changes.put("pom.id", new TextComponentPOMChange("pom.id", value, location, this.txtId, this.ocID));
        this.btnId.setVisible(false);
        this.createArtifactIDChangeInstance();
        this.createGroupIDChangeInstance();
        this.createPOMChangeInstance("currentVersion", this.txtCurrentVersion, this.ocCurrentVersion);
        this.createPOMChangeInstance("name", this.txtName, this.ocName);
        this.createPOMChangeInstance("package", this.txtPackage, this.ocPackage);
    }

    private void createPOMChangeInstance(String propName, JTextComponent field, OriginChange oc) {
        String key = "pom." + propName;
        String value = this.project.getProjectWalker().getValue(key);
        int location = this.project.getProjectWalker().getLocation(key);
        if (value == null) {
            value = "";
        }
        this.changes.put(key, new TextComponentPOMChange(key, value, location, field, oc));
    }

    private void createArtifactIDChangeInstance() {
        String key = "pom.artifactId";
        String value = this.project.getProjectWalker().getValue(key);
        int location = this.project.getProjectWalker().getLocation(key);
        if (value == null) {
            value = "";
            this.changes.put(key, new TextComponentPOMChange(key, value, location, this.txtArtifactID, this.ocArtifactID));
            this.txtArtifactID.setText(this.project.getOriginalMavenProject().getArtifactId());
        } else {
            this.changes.put(key, new TextComponentPOMChange(key, value, location, this.txtArtifactID, this.ocArtifactID));
        }
    }

    private void createGroupIDChangeInstance() {
        String key = "pom.groupId";
        String value = this.project.getProjectWalker().getValue(key);
        int location = this.project.getProjectWalker().getLocation(key);
        if (value == null) {
            value = "";
            this.changes.put(key, new TextComponentPOMChange(key, value, location, this.txtGroupID, this.ocGroupID));
            this.txtGroupID.setText(this.project.getOriginalMavenProject().getGroupId());
        } else {
            this.changes.put(key, new TextComponentPOMChange(key, value, location, this.txtGroupID, this.ocGroupID));
        }
    }

    public void setResolveValues(boolean resolve) {
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
        this.assignValue("id", true);
        this.assignValue("artifactId", resolve);
        this.assignValue("groupId", resolve);
        this.assignValue("currentVersion", resolve);
        this.assignValue("name", resolve);
        this.assignValue("package", resolve);
    }

    private void assignValue(String actionName, boolean resolve) {
        String key = "pom." + actionName;
        TextComponentPOMChange change = (TextComponentPOMChange)this.changes.get(key);
        if (resolve) {
            String value = this.project.getPropertyResolver().resolveString(change.getNewValue());
            change.setResolvedValue(value);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
        if (this.listener == null) {
            this.listener = new ValidateListener();
            this.txtId.getDocument().addDocumentListener(this.listener);
            this.txtArtifactID.getDocument().addDocumentListener(this.listener);
            this.txtGroupID.getDocument().addDocumentListener(this.listener);
            this.txtPackage.getDocument().addDocumentListener(this.listener);
        }
    }

    private void doValidate() {
        logger.debug((Object)"Listener called");
        ProjectValidateObserver obs = this.valObserver;
        if (obs != null) {
            obs.resetValidState(this.isInValidState(), this.getValidityMessage());
        }
    }

    private int doValidateCheck() {
        if (Math.min(this.txtArtifactID.getText().trim().length(), this.txtGroupID.getText().trim().length()) == 0 && this.txtId.getText().trim().length() == 0) {
            return 1;
        }
        if (this.txtPackage.getText().trim().length() > 0) {
            boolean matches = this.txtPackage.getText().matches("[a-zA-Z0-9\\.]*");
            if (!matches) {
                return 2;
            }
            if (this.txtPackage.getText().startsWith(".") || this.txtPackage.getText().endsWith(".")) {
                return 2;
            }
        }
        return 0;
    }

    public boolean isInValidState() {
        return this.doValidateCheck() == 0;
    }

    public String getValidityMessage() {
        int retCode = this.doValidateCheck();
        String message = "";
        if (retCode == 1) {
            message = NbBundle.getMessage((Class)BasicsPanel.class, (String)"BasicsPanel.error1.text");
        }
        if (retCode == 2) {
            message = "Badly formed package name";
        }
        return message;
    }

    private class ValidateListener
    implements DocumentListener {
        private ValidateListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            BasicsPanel.this.doValidate();
        }

        public void insertUpdate(DocumentEvent e) {
            BasicsPanel.this.doValidate();
        }

        public void removeUpdate(DocumentEvent e) {
            BasicsPanel.this.doValidate();
        }
    }
}

