/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.customizer.changes.CheckBoxPropertyChange;
import org.mevenide.netbeans.api.customizer.changes.MavenChange;
import org.mevenide.netbeans.api.customizer.changes.TextComponentPOMChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.openide.util.NbBundle;

public class BuildPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)BuildPanel.class);
    private ProjectValidateObserver valObserver;
    private DocumentListener listener;
    private MavenProject project;
    private OriginChange ocOffline;
    private OriginChange ocRemoteRepoEnabled;
    private OriginChange ocSrc;
    private OriginChange ocTestSrc;
    private OriginChange ocAspectSrc;
    private OriginChange ocIntTestSrc;
    private HashMap changes;
    private boolean initialized;
    private JButton btnAspectSrc;
    private JButton btnIntTestSrc;
    private JButton btnOffline;
    private JButton btnRemoteRepoEnabled;
    private JButton btnSrc;
    private JButton btnTestSrc;
    private JCheckBox cbOffline;
    private JCheckBox cbRemoteRepoEnabled;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JLabel lblAspectSrc;
    private JLabel lblIntTestSrc;
    private JLabel lblSrc;
    private JLabel lblTestSrc;
    private JTextField txtAspectSrc;
    private JTextField txtIntTestSrc;
    private JTextField txtSrc;
    private JTextField txtTestSrc;

    public BuildPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.setName(NbBundle.getMessage((Class)BuildPanel.class, (String)"BuildPanel.name"));
        this.initialized = false;
    }

    private void initComponents() {
        this.lblSrc = new JLabel();
        this.txtSrc = new JTextField();
        this.ocSrc = LocationComboFactory.createPOMChange(this.project, false);
        this.btnSrc = (JButton)this.ocSrc.getComponent();
        this.lblTestSrc = new JLabel();
        this.txtTestSrc = new JTextField();
        this.ocTestSrc = LocationComboFactory.createPOMChange(this.project, false);
        this.btnTestSrc = (JButton)this.ocTestSrc.getComponent();
        this.lblAspectSrc = new JLabel();
        this.txtAspectSrc = new JTextField();
        this.ocAspectSrc = LocationComboFactory.createPOMChange(this.project, false);
        this.btnAspectSrc = (JButton)this.ocAspectSrc.getComponent();
        this.lblIntTestSrc = new JLabel();
        this.txtIntTestSrc = new JTextField();
        this.ocIntTestSrc = LocationComboFactory.createPOMChange(this.project, false);
        this.btnIntTestSrc = (JButton)this.ocIntTestSrc.getComponent();
        this.jSeparator1 = new JSeparator();
        this.cbOffline = new JCheckBox();
        this.cbRemoteRepoEnabled = new JCheckBox();
        this.ocRemoteRepoEnabled = LocationComboFactory.createPropertiesChange(this.project);
        this.btnRemoteRepoEnabled = (JButton)this.ocRemoteRepoEnabled.getComponent();
        this.ocOffline = LocationComboFactory.createPropertiesChange(this.project);
        this.btnOffline = (JButton)this.ocOffline.getComponent();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.lblSrc.setLabelFor(this.txtSrc);
        this.lblSrc.setText("Sources :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblSrc, gridBagConstraints);
        this.txtSrc.setPreferredSize(new Dimension(60, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.txtSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.btnSrc, gridBagConstraints);
        this.lblTestSrc.setLabelFor(this.txtTestSrc);
        this.lblTestSrc.setText("Unit Test Sources :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblTestSrc, gridBagConstraints);
        this.txtTestSrc.setPreferredSize(new Dimension(60, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtTestSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.btnTestSrc, gridBagConstraints);
        this.lblAspectSrc.setLabelFor(this.txtAspectSrc);
        this.lblAspectSrc.setText("Aspect Sources :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblAspectSrc, gridBagConstraints);
        this.txtAspectSrc.setPreferredSize(new Dimension(60, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtAspectSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.add((Component)this.btnAspectSrc, gridBagConstraints);
        this.lblIntTestSrc.setLabelFor(this.txtIntTestSrc);
        this.lblIntTestSrc.setText("Integration Test Sources :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblIntTestSrc, gridBagConstraints);
        this.txtIntTestSrc.setPreferredSize(new Dimension(60, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.txtIntTestSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.btnIntTestSrc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.cbOffline.setText("Work online.");
        this.cbOffline.setToolTipText("Maven Property: maven.mode.online");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbOffline, gridBagConstraints);
        this.cbRemoteRepoEnabled.setText("Check remote repository for new snapshot dependencies");
        this.cbRemoteRepoEnabled.setToolTipText("Maven Property: maven.repo.remote.enabled");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.cbRemoteRepoEnabled, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.btnRemoteRepoEnabled, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.btnOffline, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        this.createChangeInstance("maven.mode.online", this.cbOffline, this.ocOffline, true, false);
        this.createChangeInstance("maven.repo.remote.enabled", this.cbRemoteRepoEnabled, this.ocRemoteRepoEnabled, true, false);
        this.createPOMChangeInstance("sourceDirectory", this.txtSrc, this.ocSrc);
        this.createPOMChangeInstance("unitTestSourceDirectory", this.txtTestSrc, this.ocTestSrc);
        this.createPOMChangeInstance("aspectSourceDirectory", this.txtAspectSrc, this.ocAspectSrc);
        this.createPOMChangeInstance("integrationUnitTestSourceDirectory", this.txtIntTestSrc, this.ocIntTestSrc);
    }

    private void createChangeInstance(String key, JCheckBox field, OriginChange oc, boolean defaultValue, boolean opposite) {
        String value = this.project.getPropertyResolver().getResolvedValue(key);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = Boolean.toString(defaultValue);
            location = -1;
        }
        this.changes.put(key, new CheckBoxPropertyChange(key, value, location, field, oc, defaultValue, opposite));
    }

    private void createPOMChangeInstance(String propName, JTextField field, OriginChange oc) {
        String key = "pom.build." + propName;
        String value = this.project.getProjectWalker().getValue(key);
        int location = this.project.getProjectWalker().getLocation(key);
        if (value == null) {
            value = "";
        }
        this.changes.put(key, new TextComponentPOMChange(key, value, location, field, oc));
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public void setResolveValues(boolean resolve) {
        this.assignValue("sourceDirectory", resolve);
        this.assignValue("unitTestSourceDirectory", resolve);
        this.assignValue("aspectSourceDirectory", resolve);
        this.assignValue("integrationUnitTestSourceDirectory", resolve);
    }

    private void assignValue(String actionName, boolean resolve) {
        String key = "pom.build." + actionName;
        TextComponentPOMChange change = (TextComponentPOMChange)this.changes.get(key);
        if (resolve) {
            String value = this.project.getPropertyResolver().resolveString(change.getNewValue());
            change.setResolvedValue(value);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    private String getValue(String value, boolean resolve) {
        if (resolve) {
            return this.project.getPropertyResolver().resolveString(value);
        }
        return value;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
        if (this.listener == null) {
            this.listener = new ValidateListener();
            this.txtSrc.getDocument().addDocumentListener(this.listener);
        }
    }

    private void doValidate() {
        logger.debug((Object)"Listener called");
        ProjectValidateObserver obs = this.valObserver;
        if (obs != null) {
            obs.resetValidState(this.isInValidState(), this.getValidityMessage());
        }
    }

    private int doValidateCheck() {
        if (this.txtSrc.getText().trim().length() == 0) {
            return 1;
        }
        return 0;
    }

    public boolean isInValidState() {
        return this.doValidateCheck() == 0;
    }

    public String getValidityMessage() {
        int retCode = this.doValidateCheck();
        String message = "";
        if (retCode == 1) {
            message = NbBundle.getMessage((Class)BuildPanel.class, (String)"BuildPanel.error1.text");
        }
        return message;
    }

    private class ValidateListener
    implements DocumentListener {
        private ValidateListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            BuildPanel.this.doValidate();
        }

        public void insertUpdate(DocumentEvent e) {
            BuildPanel.this.doValidate();
        }

        public void removeUpdate(DocumentEvent e) {
            BuildPanel.this.doValidate();
        }
    }
}

