/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Build;
import org.apache.maven.project.UnitTest;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.customizer.changes.CheckBoxPropertyChange;
import org.mevenide.netbeans.api.customizer.changes.MavenChange;
import org.mevenide.netbeans.api.customizer.changes.TextFieldPropertyChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class UnitTestPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)UnitTestPanel.class);
    private ProjectValidateObserver valObserver;
    private DocumentListener listener;
    private MavenProject project;
    private OriginChange ocDebug;
    private OriginChange ocDeprecated;
    private OriginChange ocAdditional;
    private OriginChange ocMainClass;
    private OriginChange ocManifest;
    private OriginChange ocCompress;
    private ExplorerManager resourceManager;
    private ExplorerManager testManager;
    private HashMap changes;
    private JButton btnAddTest;
    private JButton btnAllowFail;
    private JButton btnEditTest;
    private JButton btnRemoveTest;
    private JButton btnSkip;
    private JCheckBox cbAllowFail;
    private JCheckBox cbSkip;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel pnlResources;
    private JPanel pnlTests;

    public UnitTestPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.setName("Unit test");
        this.populateChangeInstances();
    }

    private void initComponents() {
        this.pnlTests = new TestPanel();
        this.jLabel1 = new JLabel();
        this.btnAddTest = new JButton();
        this.btnEditTest = new JButton();
        this.btnRemoveTest = new JButton();
        this.jLabel2 = new JLabel();
        this.pnlResources = new ResourcePanel();
        this.jButton5 = new JButton();
        this.jButton4 = new JButton();
        this.jButton6 = new JButton();
        this.btnSkip = new JButton();
        this.cbSkip = new JCheckBox();
        this.btnAllowFail = new JButton();
        this.cbAllowFail = new JCheckBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.pnlTests, gridBagConstraints);
        this.jLabel1.setText("Unit Tests:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.btnAddTest.setText("Add");
        this.btnAddTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitTestPanel.this.btnAddTestActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.btnAddTest, gridBagConstraints);
        this.btnEditTest.setText("Edit");
        this.btnEditTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitTestPanel.this.btnEditTestActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.btnEditTest, gridBagConstraints);
        this.btnRemoveTest.setText("Remove");
        this.btnRemoveTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UnitTestPanel.this.btnRemoveTestActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.btnRemoveTest, gridBagConstraints);
        this.jLabel2.setText("Resources");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.pnlResources, gridBagConstraints);
        this.jButton5.setText("Edit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jButton5, gridBagConstraints);
        this.jButton4.setText("Add");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jButton4, gridBagConstraints);
        this.jButton6.setText("Remove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jButton6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btnSkip, gridBagConstraints);
        this.cbSkip.setText("Skip Tests when compiling");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cbSkip, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btnAllowFail, gridBagConstraints);
        this.cbAllowFail.setText("Allow Tests to fail");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cbAllowFail, gridBagConstraints);
    }

    private void btnRemoveTestActionPerformed(ActionEvent evt) {
    }

    private void btnEditTestActionPerformed(ActionEvent evt) {
    }

    private void btnAddTestActionPerformed(ActionEvent evt) {
        JPanel panel = new JPanel();
        JComboBox<Object> cb = new JComboBox<Object>(new Object[]{"Include", "Exclude"});
        JLabel lbl = new JLabel("Add: ");
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        panel.add((Component)lbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        panel.add(cb, gridBagConstraints);
        lbl = new JLabel("Value: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        panel.add((Component)lbl, gridBagConstraints);
        JTextField field = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        panel.add((Component)field, gridBagConstraints);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, "Add Include/Exclude");
        Object returned = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    private void populateChangeInstances() {
        UnitTest test;
        Build bld = this.project.getOriginalMavenProject().getBuild();
        if (bld != null && (test = bld.getUnitTest()) != null) {
            TestPanel pnl = (TestPanel)this.pnlTests;
            pnl.setData(test.getIncludes(), test.getExcludes());
        }
    }

    private void createToggleChangeInstance(String key, JCheckBox field, OriginChange oc, boolean defaultValue) {
        String value = this.project.getPropertyResolver().getResolvedValue(key);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = Boolean.toString(defaultValue);
            location = -1;
        }
        this.changes.put(key, new CheckBoxPropertyChange(key, value, location, field, oc, defaultValue, false));
    }

    private void createChangeInstance(String key, JTextField field, OriginChange oc) {
        String value = this.project.getPropertyResolver().getValue(key);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = "";
            location = -1;
        }
        String defaultValue = this.project.getPropertyLocator().getValueAtLocation(key, -2);
        this.changes.put(key, new TextFieldPropertyChange(key, value, location, field, oc, defaultValue));
    }

    public void setResolveValues(boolean resolve) {
    }

    private void assignValue(String key, boolean resolve) {
        TextFieldPropertyChange change = (TextFieldPropertyChange)this.changes.get(key);
        if (resolve) {
            String value = this.project.getPropertyResolver().resolveString(change.getNewValue());
            change.setResolvedValue(value);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        String message = "";
        return message;
    }

    private class InExChildren
    extends Children.Keys {
        private List list;

        public InExChildren(List lst) {
            this.list = lst != null ? new ArrayList(lst) : new ArrayList();
            this.setKeys(this.list);
        }

        public Node[] createNodes(Object key) {
            AbstractNode toReturn = new AbstractNode(Children.LEAF);
            toReturn.setName(key.toString());
            return new Node[]{toReturn};
        }

        public void addItem(String newone) {
            this.list.add(newone);
            this.setKeys(this.list);
        }

        public void removeItem(String toRemove) {
            this.list.remove(toRemove);
            this.setKeys(this.list);
        }
    }

    private class InExNode
    extends AbstractNode {
        private List lst;

        public InExNode(List list, boolean includes) {
            super((Children)new InExChildren(list));
            this.lst = list;
            if (includes) {
                this.setDisplayName("Includes");
            } else {
                this.setDisplayName("Excludes");
            }
        }
    }

    private class ResourcePanel
    extends JPanel
    implements ExplorerManager.Provider {
        public ResourcePanel() {
            UnitTestPanel.this.resourceManager = new ExplorerManager();
            this.setLayout(new BorderLayout());
            BeanTreeView btv = new BeanTreeView();
            this.add((Component)btv, "Center");
        }

        public ExplorerManager getExplorerManager() {
            return UnitTestPanel.this.resourceManager;
        }
    }

    private class TestPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private InExNode includes;
        private InExNode excludes;

        public TestPanel() {
            UnitTestPanel.this.testManager = new ExplorerManager();
            BeanTreeView btv = new BeanTreeView();
            btv.setRootVisible(false);
            btv.setPopupAllowed(false);
            btv.setDefaultActionAllowed(true);
            this.setLayout(new BorderLayout());
            this.add((Component)btv, "Center");
        }

        public ExplorerManager getExplorerManager() {
            return UnitTestPanel.this.testManager;
        }

        public void setData(List in, List ex) {
            Children.Array childs = new Children.Array();
            this.includes = new InExNode(in, true);
            this.excludes = new InExNode(ex, false);
            childs.add(new Node[]{this.includes, this.excludes});
            AbstractNode root = new AbstractNode((Children)childs);
            UnitTestPanel.this.testManager.setRootContext((Node)root);
        }

        public void addData(String newValue, boolean include) {
            if (include) {
                ((InExChildren)this.includes.getChildren()).addItem(newValue);
            } else {
                ((InExChildren)this.excludes.getChildren()).addItem(newValue);
            }
        }

        public void removeData(String newValue, boolean include) {
            if (include) {
                ((InExChildren)this.includes.getChildren()).removeItem(newValue);
            } else {
                ((InExChildren)this.excludes.getChildren()).removeItem(newValue);
            }
        }
    }
}

