/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.Dependency;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.customizer.DependencyPOMChange;
import org.mevenide.netbeans.project.dependencies.DependencyChildren;
import org.mevenide.netbeans.project.dependencies.DependencyEditor;
import org.mevenide.netbeans.project.dependencies.RepositoryUtilities;
import org.mevenide.netbeans.project.queries.MavenFileOwnerQueryImpl;
import org.mevenide.netbeans.project.writer.NbProjectWriter;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.project.io.JarOverrideReader2;
import org.mevenide.properties.IPropertyResolver;
import org.mevenide.repository.IRepositoryReader;
import org.netbeans.api.project.Project;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.NodeAction;

public class DependencyNode
extends AbstractNode {
    private Action[] actions;
    private DependencyPOMChange change;
    private IContentProvider dependency;
    private MavenProject project;
    private boolean isOverriden;
    private String override;
    private boolean longLiving;
    private PropertyChangeListener listener;
    private ChangeListener listener2;
    static /* synthetic */ Class class$java$util$List;

    public DependencyNode(Lookup lookup, boolean isLongLiving) {
        super((Children)(isLongLiving ? new DependencyChildren(lookup) : Children.LEAF), lookup);
        this.project = (MavenProject)lookup.lookup(MavenProject.class);
        this.change = (DependencyPOMChange)lookup.lookup(DependencyPOMChange.class);
        this.dependency = this.change.getChangedContent();
        this.longLiving = isLongLiving;
        if (this.longLiving) {
            this.listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        DependencyNode.this.refreshNode();
                    }
                }
            };
            this.project.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)((Object)this)));
            this.listener2 = new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    DependencyNode.this.refreshNode();
                }
            };
            MavenFileOwnerQueryImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this.listener2, (Object)MavenFileOwnerQueryImpl.getInstance()));
        }
        this.setDisplayName(this.createName());
        this.setIconBase();
        this.checkOverride();
    }

    private void setIconBase() {
        if (this.isDependencyProjectOpen()) {
            this.setIconBase("org/mevenide/netbeans/project/resources/MavenIcon");
        } else if (this.isPluginDependency()) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyPlugin");
        } else if (this.isJarDependency()) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyJar");
        } else {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        }
    }

    private boolean isJarDependency() {
        return "jar".equalsIgnoreCase(this.dependency.getValue("type"));
    }

    private boolean isPluginDependency() {
        return "plugin".equalsIgnoreCase(this.dependency.getValue("type"));
    }

    private boolean isEjbDependency() {
        return "ejb".equalsIgnoreCase(this.dependency.getValue("type"));
    }

    boolean isDependencyProjectOpen() {
        URI uri = FileUtilities.getDependencyURI(DependencyNode.createDependencySnapshot(this.dependency), this.project);
        Project depPrj = MavenFileOwnerQueryImpl.getInstance().getOwner(uri);
        return depPrj != null;
    }

    public static Dependency createDependencySnapshot(IContentProvider dependency) {
        Dependency snap = new Dependency();
        if (dependency.getValue("artifactId") != null) {
            snap.setArtifactId(dependency.getValue("artifactId"));
        }
        if (dependency.getValue("groupId") != null) {
            snap.setGroupId(dependency.getValue("groupId"));
        }
        if (dependency.getValue("id") != null) {
            snap.setId(dependency.getValue("groupId"));
        }
        if (dependency.getValue("version") != null) {
            snap.setVersion(dependency.getValue("version"));
        }
        if (dependency.getValue("type") != null) {
            snap.setType(dependency.getValue("type"));
        } else {
            snap.setType("jar");
        }
        if (dependency.getValue("jar") != null) {
            snap.setJar(dependency.getValue("jar"));
        }
        if (dependency.getValue("url") != null) {
            snap.setUrl(dependency.getValue("url"));
        }
        return snap;
    }

    public void refreshNode() {
        this.setDisplayName(this.createName());
        this.setIconBase();
        this.checkOverride();
        this.fireIconChange();
        this.fireDisplayNameChange(null, this.getDisplayName());
        if (this.longLiving) {
            ((DependencyChildren)this.getChildren()).doRefresh();
        }
    }

    private String createName() {
        String title = "";
        IPropertyResolver res = this.project.getPropertyResolver();
        if (this.dependency.getValue("jar") != null) {
            title = res.resolveString(this.dependency.getValue("jar"));
        } else {
            title = res.resolveString(this.dependency.getValue("artifactId"));
            if (this.dependency.getValue("version") != null) {
                title = title + "-" + res.resolveString(this.dependency.getValue("version"));
            }
        }
        return title;
    }

    private void checkOverride() {
        this.isOverriden = false;
        String ov = this.project.getPropertyResolver().getResolvedValue("maven.jar.override");
        if (ov != null) {
            ov = ov.trim();
        }
        if ("true".equalsIgnoreCase(ov) || "on".equalsIgnoreCase(ov)) {
            this.override = this.project.getPropertyResolver().getValue("maven.jar." + this.dependency.getValue("artifactId"));
            this.isOverriden = this.override != null;
        }
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> acts = new ArrayList<AbstractAction>();
        acts.add(new ViewJavadocAction());
        if (!this.checkLocal()) {
            acts.add((AbstractAction)DownloadAction.get((Class)DownloadAction.class));
        }
        acts.add(new EditAction());
        acts.add((AbstractAction)RemoveDepAction.get((Class)RemoveDepAction.class));
        acts.add(null);
        acts.add((AbstractAction)PropertiesAction.get((Class)PropertiesAction.class));
        return acts.toArray(new Action[acts.size()]);
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean hasCustomizer() {
        return false;
    }

    private boolean checkLocal() {
        if (!this.isOverriden) {
            URI uri = FileUtilities.getDependencyURI(DependencyNode.createDependencySnapshot(this.dependency), this.project);
            if (uri != null) {
                File file = new File(uri);
                return file.exists();
            }
        } else {
            String path = JarOverrideReader2.getInstance().processOverride(DependencyNode.createDependencySnapshot(this.dependency), this.project.getContext());
            if (path != null) {
                File file = new File(path);
                return file.exists();
            }
        }
        return false;
    }

    public boolean hasJavadocInRepository() {
        boolean has;
        Dependency depSnap = DependencyNode.createDependencySnapshot(this.dependency);
        depSnap.setType("javadoc.jar");
        URI uri = FileUtilities.getDependencyURI(depSnap, this.project);
        boolean bl = has = uri != null && new File(uri).exists();
        if (!has) {
            depSnap.setType("javadoc");
            uri = FileUtilities.getDependencyURI(depSnap, this.project);
            has = uri != null && new File(uri).exists();
        }
        return has;
    }

    public boolean hasSourceInRepository() {
        Dependency depSnap = DependencyNode.createDependencySnapshot(this.dependency);
        depSnap.setType("src.jar");
        URI uri = FileUtilities.getDependencyURI(depSnap, this.project);
        return uri != null && new File(uri).exists();
    }

    public Image getIcon(int param) {
        Image retValue = super.getIcon(param);
        if (this.checkLocal()) {
            if ("jar".equalsIgnoreCase(this.dependency.getValue("type")) || this.dependency.getValue("type") == null) {
                if (this.hasJavadocInRepository()) {
                    retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/DependencyJavadocIncluded.png"), (int)12, (int)12);
                }
                if (this.hasSourceInRepository()) {
                    retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/DependencySrcIncluded.png"), (int)12, (int)8);
                }
                return retValue;
            }
            return retValue;
        }
        return Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ResourceNotIncluded.gif"), (int)0, (int)0);
    }

    public Image getOpenedIcon(int type) {
        Image retValue = super.getOpenedIcon(type);
        if (this.checkLocal()) {
            if ("jar".equalsIgnoreCase(this.dependency.getValue("type")) || this.dependency.getValue("type") == null) {
                if (this.hasJavadocInRepository()) {
                    retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/DependencyJavadocIncluded.png"), (int)12, (int)12);
                }
                if (this.hasSourceInRepository()) {
                    retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/DependencySrcIncluded.png"), (int)12, (int)8);
                }
                return retValue;
            }
            return retValue;
        }
        return Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ResourceNotIncluded.gif"), (int)0, (int)0);
    }

    public Component getCustomizer() {
        return null;
    }

    public String getHtmlDisplayName() {
        String retValue = this.isOverriden ? "<S>" + this.getDisplayName() + "</S>  ( Overriden: " + this.override + ")" : super.getHtmlDisplayName();
        return retValue;
    }

    public void destroy() throws IOException {
        super.destroy();
    }

    private static class RemoveDepAction
    extends NodeAction {
        protected boolean enable(Node[] node) {
            MavenProject project = null;
            if (node != null && node.length > 0) {
                for (int i = 0; i < node.length; ++i) {
                    Object obj = node[i].getLookup().lookup(class$org$mevenide$netbeans$project$customizer$DependencyPOMChange == null ? DependencyNode.class$("org.mevenide.netbeans.project.customizer.DependencyPOMChange") : class$org$mevenide$netbeans$project$customizer$DependencyPOMChange);
                    if (obj == null) {
                        return false;
                    }
                    Object proj = node[i].getLookup().lookup(class$org$mevenide$netbeans$api$project$MavenProject == null ? DependencyNode.class$("org.mevenide.netbeans.api.project.MavenProject") : class$org$mevenide$netbeans$api$project$MavenProject);
                    if (project == null) {
                        project = (MavenProject)proj;
                        continue;
                    }
                    if (project == proj) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String getName() {
            return "Delete";
        }

        protected void performAction(Node[] node) {
            ArrayList<Object> toDelete = new ArrayList<Object>();
            MavenProject project = null;
            if (node != null && node.length > 0) {
                for (int i = 0; i < node.length; ++i) {
                    Object obj = node[i].getLookup().lookup(class$org$mevenide$netbeans$project$customizer$DependencyPOMChange == null ? DependencyNode.class$("org.mevenide.netbeans.project.customizer.DependencyPOMChange") : class$org$mevenide$netbeans$project$customizer$DependencyPOMChange);
                    if (obj != null) {
                        toDelete.add(obj);
                    }
                    if (project != null) continue;
                    project = (MavenProject)node[i].getLookup().lookup(class$org$mevenide$netbeans$api$project$MavenProject == null ? DependencyNode.class$("org.mevenide.netbeans.api.project.MavenProject") : class$org$mevenide$netbeans$api$project$MavenProject);
                }
            }
            if (project == null) {
                return;
            }
            if (toDelete.size() > 0) {
                NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)("Are you sure you want to remove " + toDelete.size() + " dependencies?"), "Remove Dependencies", 0, 3);
                Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                if (ret == NotifyDescriptor.YES_OPTION) {
                    try {
                        NbProjectWriter writer = new NbProjectWriter(project);
                        List changes = (List)node[0].getLookup().lookup(class$java$util$List == null ? (class$java$util$List = DependencyNode.class$("java.util.List")) : class$java$util$List);
                        changes.removeAll(toDelete);
                        writer.applyChanges(changes);
                    }
                    catch (Exception exc) {
                        ErrorManager.getDefault().notify(256, (Throwable)exc);
                    }
                }
            }
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private static class DownloadAction
    extends NodeAction {
        protected boolean enable(Node[] node) {
            if (node != null && node.length > 0) {
                for (int i = 0; i < node.length; ++i) {
                    Object obj = node[i].getLookup().lookup(class$org$mevenide$netbeans$project$customizer$DependencyPOMChange == null ? DependencyNode.class$("org.mevenide.netbeans.project.customizer.DependencyPOMChange") : class$org$mevenide$netbeans$project$customizer$DependencyPOMChange);
                    if (obj != null) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String getName() {
            return "Download artifact";
        }

        protected void performAction(Node[] node) {
            if (node != null && node.length > 0) {
                HashSet<MavenProject> projectsToFire = new HashSet<MavenProject>();
                for (int i = 0; i < node.length; ++i) {
                    Object obj = node[i].getLookup().lookup(class$org$mevenide$netbeans$project$customizer$DependencyPOMChange == null ? DependencyNode.class$("org.mevenide.netbeans.project.customizer.DependencyPOMChange") : class$org$mevenide$netbeans$project$customizer$DependencyPOMChange);
                    if (obj == null) continue;
                    DependencyPOMChange chng = (DependencyPOMChange)obj;
                    MavenProject prj = (MavenProject)node[i].getLookup().lookup(class$org$mevenide$netbeans$api$project$MavenProject == null ? DependencyNode.class$("org.mevenide.netbeans.api.project.MavenProject") : class$org$mevenide$netbeans$api$project$MavenProject);
                    IRepositoryReader[] readers = RepositoryUtilities.createRemoteReaders(prj.getPropertyResolver());
                    Dependency dep = DependencyNode.createDependencySnapshot(chng.getChangedContent());
                    try {
                        boolean downloaded = RepositoryUtilities.downloadArtifact(readers, prj, dep);
                        if (!downloaded) continue;
                        projectsToFire.add(prj);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        StatusDisplayer.getDefault().setStatusText(dep.getArtifact() + " is not available in repote repositories.");
                        continue;
                    }
                    catch (Exception exc) {
                        StatusDisplayer.getDefault().setStatusText("Error downloading " + dep.getArtifact() + " : " + exc.getLocalizedMessage());
                    }
                }
                Iterator it = projectsToFire.iterator();
                while (it.hasNext()) {
                    ((MavenProject)it.next()).firePropertyChange("MavenProject");
                }
            }
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private class ViewJavadocAction
    extends AbstractAction {
        public ViewJavadocAction() {
            this.putValue("Name", "View Javadoc");
            this.setEnabled(DependencyNode.this.hasJavadocInRepository());
        }

        public void actionPerformed(ActionEvent event) {
            Dependency depSnap = DependencyNode.createDependencySnapshot(DependencyNode.this.dependency);
            depSnap.setType("javadoc.jar");
            URI uri = FileUtilities.getDependencyURI(depSnap, DependencyNode.this.project);
            try {
                URL url = uri.toURL();
                if (FileUtil.isArchiveFile((URL)url)) {
                    URL archUrl = FileUtil.getArchiveRoot((URL)url);
                    String path = archUrl.toString() + "index.html";
                    URL link = new URL(path);
                    HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                }
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", "Edit...");
        }

        public void actionPerformed(ActionEvent event) {
            DependencyEditor ed = new DependencyEditor(DependencyNode.this.project, DependencyNode.this.change);
            DialogDescriptor dd = new DialogDescriptor((Object)ed, "Edit Dependency");
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (ret == NotifyDescriptor.OK_OPTION) {
                HashMap props = ed.getProperties();
                MavenSettings.getDefault().checkDependencyProperties(props.keySet());
                DependencyNode.this.change.setNewValues(ed.getValues(), props);
                try {
                    NbProjectWriter writer = new NbProjectWriter(DependencyNode.this.project);
                    List changes = (List)DependencyNode.this.getLookup().lookup(class$java$util$List == null ? (class$java$util$List = DependencyNode.class$("java.util.List")) : class$java$util$List);
                    writer.applyChanges(changes);
                }
                catch (Exception exc) {
                    ErrorManager.getDefault().notify(256, (Throwable)exc);
                }
            }
        }
    }
}

