/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.netbeans.project.dependencies.LocalRepoRefresher;
import org.mevenide.netbeans.project.dependencies.MultiRepositoryNode;
import org.mevenide.netbeans.project.dependencies.RepoPathGrouper;
import org.mevenide.netbeans.project.dependencies.RepositoryNode;
import org.mevenide.netbeans.project.dependencies.RepositoryUtilities;
import org.mevenide.properties.IPropertyResolver;
import org.mevenide.repository.IRepositoryReader;
import org.mevenide.repository.RepoPathElement;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class RepositoryExplorerPanel
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private BeanTreeView btv;
    private IPropertyResolver resolver;
    private ILocationFinder finder;
    private RepoPathElement[] roots;
    private IRepositoryReader localReader;
    private URI[] rootUris;
    private JButton btnDownload;
    private JButton btnLibrary;
    private JToggleButton btnMerge;
    private JPanel jPanel1;
    private JPanel pnlDeps;

    public RepositoryExplorerPanel(IPropertyResolver resolver, ILocationFinder finder) {
        this.initComponents();
        this.resolver = resolver;
        this.finder = finder;
        this.createRoots();
        GridBagConstraints fillConstraints = new GridBagConstraints();
        fillConstraints.gridwidth = 0;
        fillConstraints.gridheight = 0;
        fillConstraints.fill = 1;
        fillConstraints.weightx = 1.0;
        fillConstraints.weighty = 1.0;
        this.manager = new ExplorerManager();
        this.btv = new BeanTreeView();
        this.btv.setSelectionMode(4);
        this.btv.setPopupAllowed(true);
        this.btv.setRootVisible(false);
        this.btv.setDefaultActionAllowed(false);
        this.pnlDeps.add((Component)this.btv, fillConstraints);
        this.manager.setRootContext(this.createSeparateRootNode());
        this.btv.expandAll();
        this.btnLibrary.setVisible(false);
        this.btnLibrary.setEnabled(this.manager.getSelectedNodes().length != 0);
        this.btnDownload.setEnabled(this.manager.getSelectedNodes().length != 0);
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("selectedNodes".equals(event.getPropertyName())) {
                    Node[] nds = RepositoryExplorerPanel.this.manager.getSelectedNodes();
                    boolean isLeaf = nds.length != 0;
                    for (int i = 0; i < nds.length; ++i) {
                        RepoPathElement el = (RepoPathElement)nds[i].getLookup().lookup(class$org$mevenide$repository$RepoPathElement == null ? RepositoryExplorerPanel.class$("org.mevenide.repository.RepoPathElement") : class$org$mevenide$repository$RepoPathElement);
                        if (el != null && el.isLeaf()) continue;
                        isLeaf = false;
                        break;
                    }
                    RepositoryExplorerPanel.this.btnLibrary.setEnabled(isLeaf);
                    RepositoryExplorerPanel.this.btnDownload.setEnabled(isLeaf);
                }
            }
        });
    }

    private void initComponents() {
        this.pnlDeps = new JPanel();
        this.btnMerge = new JToggleButton();
        this.btnDownload = new JButton();
        this.btnLibrary = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pnlDeps.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.pnlDeps, gridBagConstraints);
        this.btnMerge.setIcon(new ImageIcon(this.getClass().getResource("/org/mevenide/netbeans/project/resources/MergeRepos.png")));
        this.btnMerge.setToolTipText("Split/Merge Repository Roots");
        this.btnMerge.setSelectedIcon(new ImageIcon(this.getClass().getResource("/org/mevenide/netbeans/project/resources/SplitRepos.png")));
        this.btnMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorerPanel.this.btnMergeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.btnMerge, gridBagConstraints);
        this.btnDownload.setIcon(new ImageIcon(this.getClass().getResource("/org/mevenide/netbeans/project/resources/Download.png")));
        this.btnDownload.setToolTipText("Download artifact");
        this.btnDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorerPanel.this.btnDownloadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnDownload, gridBagConstraints);
        this.btnLibrary.setIcon(new ImageIcon(this.getClass().getResource("/org/mevenide/netbeans/project/resources/AddLibrary.png")));
        this.btnLibrary.setToolTipText("Create Library From Artifact(s)");
        this.btnLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RepositoryExplorerPanel.this.btnLibraryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnLibrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnLibraryActionPerformed(ActionEvent evt) {
    }

    private void btnDownloadActionPerformed(ActionEvent evt) {
        final Node[] nodes = this.manager.getSelectedNodes();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RepositoryExplorerPanel.this.download(nodes);
            }
        });
    }

    private void btnMergeActionPerformed(ActionEvent evt) {
        Node root = this.btnMerge.isSelected() ? this.createCombinedRootNode() : this.createSeparateRootNode();
        this.manager.setRootContext(root);
    }

    public RepoPathElement getSelectedRepoPathElement() {
        Node[] nds = this.getExplorerManager().getSelectedNodes();
        if (nds.length > 0) {
            return (RepoPathElement)nds[0].getLookup().lookup(RepoPathElement.class);
        }
        return null;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void createRoots() {
        File fil = new File(this.finder.getMavenLocalRepository());
        this.localReader = RepositoryUtilities.createLocalReader(this.finder);
        RepoPathElement root = new RepoPathElement(this.localReader);
        ArrayList<RepoPathElement> cols = new ArrayList<RepoPathElement>();
        ArrayList<URI> cols2 = new ArrayList<URI>();
        cols.add(root);
        cols2.add(fil.toURI());
        IRepositoryReader[] remotes = RepositoryUtilities.createRemoteReaders(this.resolver);
        URI[] uris = RepositoryUtilities.createRemoteRepositoryURIs(this.resolver);
        for (int i = 0; i < remotes.length; ++i) {
            RepoPathElement remoteRoot = new RepoPathElement(remotes[i]);
            cols.add(remoteRoot);
            cols2.add(uris[i]);
        }
        this.roots = cols.toArray(new RepoPathElement[cols.size()]);
        this.rootUris = cols2.toArray(new URI[cols2.size()]);
    }

    private Node createSeparateRootNode() {
        ArrayList<RepositoryNode> cols = new ArrayList<RepositoryNode>();
        for (int i = 0; i < this.roots.length; ++i) {
            cols.add(new RepositoryNode(this.roots[i], this.rootUris[i]));
        }
        Children.Array arr = new Children.Array();
        Node[] nds = new Node[cols.size()];
        arr.add(cols.toArray(nds));
        return new AbstractNode((Children)arr);
    }

    private Node createCombinedRootNode() {
        Children.Array arr = new Children.Array();
        Node[] nds = new Node[]{new MultiRepositoryNode(new RepoPathGrouper(this.roots), "Multiple Repository Root")};
        arr.add(nds);
        return new AbstractNode((Children)arr);
    }

    private void download(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            Lookup.Result res = nodes[i].getLookup().lookup(new Lookup.Template(class$org$mevenide$repository$RepoPathElement == null ? RepositoryExplorerPanel.class$("org.mevenide.repository.RepoPathElement") : class$org$mevenide$repository$RepoPathElement));
            if (res == null) continue;
            boolean done = false;
            Iterator it = res.allInstances().iterator();
            RepoPathElement element = null;
            while (it.hasNext() && !done) {
                element = (RepoPathElement)it.next();
                try {
                    done = RepositoryUtilities.downloadArtifact(this.finder, this.resolver, element);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    done = false;
                    StatusDisplayer.getDefault().setStatusText("Download failed: " + exc.getLocalizedMessage());
                }
            }
            if (!done) continue;
            for (Node nd = nodes[i]; nd != null && nd instanceof LocalRepoRefresher; nd = nd.getParentNode()) {
                ((LocalRepoRefresher)nd).markAsDownloaded();
            }
        }
    }
}

