/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.customizer.DependencyPOMChange;
import org.mevenide.netbeans.project.dependencies.LocalRepoRefresher;
import org.mevenide.netbeans.project.dependencies.RepoElementComparator;
import org.mevenide.netbeans.project.queries.MavenFileOwnerQueryImpl;
import org.mevenide.netbeans.project.writer.NbProjectWriter;
import org.mevenide.repository.RepoPathElement;
import org.netbeans.api.project.ProjectInformation;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class RepositoryNode
extends AbstractNode
implements LocalRepoRefresher {
    private static final Object LOADING = new Object();
    private RepoPathElement element;
    private URI root;
    static /* synthetic */ Class class$org$netbeans$api$project$ProjectInformation;

    public RepositoryNode(RepoPathElement el) {
        super((Children)(el.isLeaf() ? Children.LEAF : new RepositoryChildren(el)), Lookups.singleton((Object)el));
        this.element = el;
        if (this.element.getLevel() == 1 || this.element.getLevel() == 2) {
            this.setIconBase("org/mevenide/netbeans/project/resources/defaultFolder");
        } else if (this.element.getLevel() == 3) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        } else if (this.element.getLevel() == 4) {
            this.setIconBase("org/mevenide/netbeans/project/resources/DependencyIcon");
        } else {
            this.setIconBase("org/mevenide/netbeans/project/resources/RepositoryRoot");
        }
    }

    public RepositoryNode(RepoPathElement el, URI rootUri) {
        this(el);
        this.root = rootUri;
    }

    public String getDisplayName() {
        return this.createName();
    }

    public int getRepoLevel() {
        return this.element.getLevel();
    }

    public String getHtmlDisplayName() {
        if (this.element.isRemote()) {
            return "<html><b><font color='#9f9a93'>" + this.getDisplayName() + "</font></b></html>";
        }
        return super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean context) {
        if (this.element.isLeaf()) {
            Action[] retValue = new Action[]{new AddAsDependencyAction(), null, ((PropertiesAction)PropertiesAction.get((Class)PropertiesAction.class)).createContextAwareInstance(Lookups.singleton((Object)this))};
            return retValue;
        }
        return new Action[0];
    }

    private String createName() {
        switch (this.element.getLevel()) {
            case 0: {
                String str;
                String string = str = this.root == null ? "" : this.root.toString();
                if (str.startsWith("http://")) {
                    return "Remote at " + str;
                }
                return "Local at " + str;
            }
            case 1: {
                return this.element.getGroupId();
            }
            case 2: {
                return this.element.getType();
            }
            case 3: {
                return this.element.getArtifactId();
            }
            case 4: {
                int level;
                Node parent = this.getParentNode();
                if (parent != null && parent instanceof RepositoryNode && (level = ((RepositoryNode)parent).getRepoLevel()) == 3) {
                    return this.element.getVersion();
                }
                return this.element.getArtifactId() + "  (" + this.element.getVersion() + ")";
            }
        }
        throw new IllegalStateException();
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean hasCustomizer() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public void markAsDownloaded() {
    }

    public static RepoPathElement generateSameLevelElement(RepoPathElement element, RepoPathElement el) {
        String group = null;
        String type = null;
        String artifact = null;
        String version = null;
        String ext = null;
        if (element.getLevel() == 4) {
            type = el.getType();
            artifact = el.getArtifactId();
            version = el.getVersion();
            ext = el.getExtension();
            group = el.getGroupId();
        } else if (element.getLevel() == 3) {
            type = el.getType();
            artifact = el.getArtifactId();
            group = el.getGroupId();
        } else if (element.getLevel() == 2) {
            type = el.getType();
            group = el.getGroupId();
        } else if (element.getLevel() == 1) {
            group = el.getGroupId();
        }
        return new RepoPathElement(element.getReader(), null, group, type, artifact, version, ext);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set basicProps = sheet.get("properties");
        try {
            PropertySupport.Reflection artifactId = new PropertySupport.Reflection((Object)this.element, String.class, "getArtifactId", null);
            artifactId.setName("artifactId");
            artifactId.setDisplayName("Artifact Id");
            artifactId.setShortDescription("");
            PropertySupport.Reflection groupId = new PropertySupport.Reflection((Object)this.element, String.class, "getGroupId", null);
            groupId.setName("groupId");
            groupId.setDisplayName("Group Id");
            groupId.setShortDescription("");
            PropertySupport.Reflection version = new PropertySupport.Reflection((Object)this.element, String.class, "getVersion", null);
            version.setName("version");
            version.setDisplayName("Version");
            version.setShortDescription("");
            PropertySupport.Reflection type = new PropertySupport.Reflection((Object)this.element, String.class, "getType", null);
            type.setName("type");
            type.setDisplayName("Type");
            type.setShortDescription("");
            basicProps.put(new Node.Property[]{artifactId, groupId, version, type});
        }
        catch (NoSuchMethodException exc) {
            exc.printStackTrace();
        }
        return sheet;
    }

    private class AddAsDependencyAction
    extends AbstractAction
    implements Presenter.Popup {
        private MavenProject project;

        public AddAsDependencyAction() {
        }

        public AddAsDependencyAction(MavenProject proj) {
            this.project = proj;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Project[] projs = this.project.getContext().getPOMContext().getProjectLayers();
            ArrayList<DependencyPOMChange> deps = new ArrayList<DependencyPOMChange>();
            DependencyPOMChange change = null;
            for (int i = 0; i < projs.length; ++i) {
                List ones = projs[i].getDependencies();
                if (ones == null) continue;
                Iterator it = ones.iterator();
                while (it.hasNext()) {
                    Dependency dep = (Dependency)it.next();
                    DependencyPOMChange chng = DependencyPOMChange.createChangeInstance(dep, i, new HashMap(), LocationComboFactory.createPOMChange(this.project, false), false);
                    deps.add(chng);
                    if ((!RepositoryNode.this.element.getArtifactId().equals(dep.getArtifactId()) || !RepositoryNode.this.element.getGroupId().equals(dep.getGroupId())) && (!RepositoryNode.this.element.getArtifactId().equals(RepositoryNode.this.element.getGroupId()) || !RepositoryNode.this.element.getArtifactId().equals(dep.getId())) || !RepositoryNode.this.element.getType().equals(dep.getType()) && (!RepositoryNode.this.element.getType().equals("jar") || dep.getType() != null)) continue;
                    change = chng;
                }
            }
            if (change == null) {
                change = DependencyPOMChange.createChangeInstance(null, 0, new HashMap(), LocationComboFactory.createPOMChange(this.project, false), false);
                deps.add(change);
            } else {
                NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)("The project already has a dependency with '" + RepositoryNode.this.element.getGroupId() + ":" + RepositoryNode.this.element.getArtifactId() + "' id. Replace it?"), "Dependency conflict", 0, 3);
                Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (ret != NotifyDescriptor.YES_OPTION) {
                    return;
                }
            }
            HashMap<String, String> newValues = new HashMap<String, String>();
            newValues.put("artifactId", RepositoryNode.this.element.getArtifactId());
            newValues.put("groupId", RepositoryNode.this.element.getGroupId());
            newValues.put("version", RepositoryNode.this.element.getVersion());
            newValues.put("type", RepositoryNode.this.element.getType());
            change.setNewValues(newValues, new HashMap());
            try {
                NbProjectWriter writer = new NbProjectWriter(this.project);
                writer.applyChanges(deps);
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify(256, (Throwable)exc);
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenu menu = new JMenu();
            if (this.project == null) {
                menu.setText("Add as dependency to");
                Set projs = MavenFileOwnerQueryImpl.getInstance().getOpenedProjects();
                if (projs.size() == 0) {
                    menu.setEnabled(false);
                } else {
                    Iterator it = projs.iterator();
                    while (it.hasNext()) {
                        MavenProject prj = (MavenProject)it.next();
                        ProjectInformation info = (ProjectInformation)prj.getLookup().lookup(class$org$netbeans$api$project$ProjectInformation == null ? RepositoryNode.class$("org.netbeans.api.project.ProjectInformation") : class$org$netbeans$api$project$ProjectInformation);
                        JMenuItem item = new JMenuItem(new AddAsDependencyAction(prj));
                        item.setText(info.getDisplayName());
                        item.setIcon(info.getIcon());
                        menu.add(item);
                    }
                }
            }
            return menu;
        }
    }

    private static class RepositoryChildren
    extends Children.Keys {
        private RepoPathElement element;
        private Collection keys;

        RepositoryChildren(RepoPathElement el) {
            this.element = el;
            this.keys = Collections.EMPTY_LIST;
        }

        protected Node[] createNodes(Object obj) {
            if (obj == LOADING) {
                AbstractNode nd = new AbstractNode(Children.LEAF);
                nd.setName("Loading");
                nd.setDisplayName("Loading...");
                return new Node[]{nd};
            }
            if (obj instanceof String) {
                AbstractNode nd = new AbstractNode(Children.LEAF);
                nd.setName("Error");
                nd.setDisplayName((String)obj);
                return new Node[]{nd};
            }
            if (obj instanceof RepoPathElement) {
                return new Node[]{new RepositoryNode((RepoPathElement)obj)};
            }
            System.out.println("wrong object..");
            return new Node[0];
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
        }

        protected void addNotify() {
            this.setKeys(Collections.singleton(LOADING));
            this.runLoad();
            super.addNotify();
        }

        private void runLoad() {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        RepoPathElement[] els = RepositoryChildren.this.element.getChildren();
                        TreeSet<RepoPathElement> col = new TreeSet<RepoPathElement>(RepoElementComparator.getInstance());
                        if (RepositoryChildren.this.element.getLevel() == 2) {
                            for (int i = 0; i < els.length; ++i) {
                                RepoPathElement[] childs = els[i].getChildren();
                                if (childs.length == 1) {
                                    col.add(childs[0]);
                                    continue;
                                }
                                col.add(els[i]);
                            }
                        } else {
                            col.addAll(Arrays.asList(els));
                        }
                        RepositoryChildren.this.keys = col;
                        RepositoryChildren.this.setKeys(col);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace(System.err);
                        String loc = exc.getLocalizedMessage();
                        if (loc != null) {
                            RepositoryChildren.this.setKeys(Collections.singleton(loc));
                        }
                        RepositoryChildren.this.setKeys(Collections.EMPTY_SET);
                    }
                }
            });
        }
    }
}

