/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.maven.project.Dependency;
import org.apache.maven.util.DownloadMeter;
import org.apache.maven.util.HttpUtils;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.ProxyUtilities;
import org.mevenide.netbeans.project.dependencies.StatusBarDownloadMeter;
import org.mevenide.properties.IPropertyResolver;
import org.mevenide.repository.IRepositoryReader;
import org.mevenide.repository.RepoPathElement;
import org.mevenide.repository.RepositoryReaderFactory;

public final class RepositoryUtilities {
    private RepositoryUtilities() {
    }

    public static IRepositoryReader createLocalReader(ILocationFinder finder) {
        File fil = new File(finder.getMavenLocalRepository());
        return RepositoryReaderFactory.createLocalRepositoryReader((File)fil);
    }

    public static IRepositoryReader[] createRemoteReaders(IPropertyResolver resolver) {
        String host = resolver.getResolvedValue("maven.proxy.host");
        String port = resolver.getResolvedValue("maven.proxy.port");
        String user = resolver.getResolvedValue("maven.proxy.username");
        String passwd = resolver.getResolvedValue("maven.proxy.password");
        if (host == null) {
            host = ProxyUtilities.getProxyHost();
        }
        if (port == null) {
            port = ProxyUtilities.getProxyPort();
        }
        if (host != null && host.length() == 0) {
            host = null;
        }
        if (port != null && port.length() == 0) {
            port = null;
        }
        if (user != null && user.length() == 0) {
            user = null;
        }
        if (passwd != null && passwd.length() == 0) {
            passwd = null;
        }
        String repos = resolver.getResolvedValue("maven.repo.remote");
        ArrayList<IRepositoryReader> cols = new ArrayList<IRepositoryReader>();
        if (repos != null) {
            StringTokenizer tokens = new StringTokenizer(repos, ",");
            while (tokens.hasMoreTokens()) {
                URI uri = URI.create(tokens.nextToken());
                IRepositoryReader reader = port != null && host != null ? (user != null && passwd != null ? RepositoryReaderFactory.createRemoteRepositoryReader((URI)uri, (String)host, (String)port, (String)user, (String)passwd) : RepositoryReaderFactory.createRemoteRepositoryReader((URI)uri, (String)host, (String)port)) : RepositoryReaderFactory.createRemoteRepositoryReader((URI)uri);
                cols.add(reader);
            }
        }
        return cols.toArray(new IRepositoryReader[cols.size()]);
    }

    public static URI[] createRemoteRepositoryURIs(IPropertyResolver resolver) {
        String repos = resolver.getResolvedValue("maven.repo.remote");
        ArrayList<URI> cols = new ArrayList<URI>();
        if (repos != null) {
            StringTokenizer tokens = new StringTokenizer(repos, ",");
            while (tokens.hasMoreTokens()) {
                URI uri = URI.create(tokens.nextToken());
                cols.add(uri);
            }
        }
        return cols.toArray(new URI[cols.size()]);
    }

    public static boolean downloadArtifact(IRepositoryReader[] readers, MavenProject project, Dependency dependency) throws Exception {
        Exception fileNotFound = new Exception();
        for (int i = 0; i < readers.length; ++i) {
            String groupId = dependency.getGroupId() != null ? dependency.getGroupId() : dependency.getId();
            String artId = dependency.getArtifactId() != null ? dependency.getArtifactId() : dependency.getId();
            String type = dependency.getType() != null ? dependency.getType() : "jar";
            String ext = dependency.getExtension();
            RepoPathElement el = new RepoPathElement(readers[i], null, groupId, type, dependency.getVersion(), artId, ext);
            File localRepo = new File(project.getLocFinder().getMavenLocalRepository());
            File destinationFile = new File(URI.create(localRepo.toURI().toString() + el.getRelativeURIPath()));
            if (!destinationFile.exists() || destinationFile.getName().indexOf("SNAPSHOT") >= 0) {
                try {
                    return RepositoryUtilities.downloadArtifact(project.getLocFinder(), project.getPropertyResolver(), el);
                }
                catch (FileNotFoundException exc) {
                    fileNotFound = exc;
                    continue;
                }
            }
            return false;
        }
        throw fileNotFound;
    }

    public static boolean downloadArtifact(ILocationFinder finder, IPropertyResolver resolver, RepoPathElement repoElement) throws Exception {
        if (!repoElement.isRemote()) {
            return false;
        }
        if (!repoElement.isLeaf()) {
            RepoPathElement[] elements = repoElement.getChildren();
            for (int i = 0; i < elements.length; ++i) {
                RepositoryUtilities.downloadArtifact(finder, resolver, elements[i]);
            }
            return true;
        }
        URI uri = repoElement.getURI();
        String relPath = repoElement.getRelativeURIPath();
        File localRepo = new File(finder.getMavenLocalRepository());
        File destinationFile = new File(URI.create(localRepo.toURI().toString() + relPath));
        destinationFile.getParentFile().mkdirs();
        String host = resolver.getResolvedValue("maven.proxy.host");
        String port = resolver.getResolvedValue("maven.proxy.port");
        String user = resolver.getResolvedValue("maven.proxy.username");
        String passwd = resolver.getResolvedValue("maven.proxy.password");
        if (host == null) {
            host = ProxyUtilities.getProxyHost();
        }
        if (port == null) {
            port = ProxyUtilities.getProxyPort();
        }
        if (host != null && host.length() == 0) {
            host = null;
        }
        if (port != null && port.length() == 0) {
            port = null;
        }
        if (user != null && user.length() == 0) {
            user = null;
        }
        if (passwd != null && passwd.length() == 0) {
            passwd = null;
        }
        StatusBarDownloadMeter meter = new StatusBarDownloadMeter(repoElement.getRelativeURIPath());
        HttpUtils.getFile((String)uri.toURL().toString(), (File)destinationFile, (boolean)false, (boolean)true, (String)host, (String)port, (String)user, (String)passwd, null, null, (DownloadMeter)meter);
        return true;
    }
}

