/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.exec;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mevenide.goals.grabber.IGoalsGrabber;
import org.mevenide.goals.manager.GoalsGrabbersManager;
import org.mevenide.netbeans.project.exec.CustomGoalsPanel;
import org.mevenide.netbeans.project.goals.GoalsGrabberProvider;
import org.openide.util.NbBundle;

public class GoalCustomEditor
extends JPanel {
    private PropertyEditor editor;
    private Listener listener;
    private CustomGoalsPanel pnlAvailableGoals;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnMoveDown;
    private JButton btnMoveUp;
    private JButton btnRemove;
    private JButton btnRemoveAll;
    private JLabel lblGoals;
    private JList lstGoals;
    private JScrollPane spGoals;

    protected GoalCustomEditor() {
        this.initComponents();
        GoalsGrabberProvider provider = new GoalsGrabberProvider(){

            public IGoalsGrabber getGoalsGrabber() throws Exception {
                return GoalsGrabbersManager.getDefaultGoalsGrabber();
            }
        };
        this.pnlAvailableGoals = new CustomGoalsPanel(provider);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add(this.pnlAvailableGoals, gridBagConstraints, 0);
        this.lstGoals.setSelectionMode(0);
        this.enableRemoveButtons(-1);
        this.btnAdd.setMnemonic(NbBundle.getMessage((Class)GoalCustomEditor.class, (String)"GoalCustomEditor.btnAdd.mnemonic").charAt(0));
        this.btnEdit.setMnemonic(NbBundle.getMessage((Class)GoalCustomEditor.class, (String)"GoalCustomEditor.btnEdit.mnemonic").charAt(0));
        this.btnRemove.setMnemonic(NbBundle.getMessage((Class)GoalCustomEditor.class, (String)"GoalCustomEditor.btnRemove.mnemonic").charAt(0));
        this.btnRemoveAll.setMnemonic(NbBundle.getMessage((Class)GoalCustomEditor.class, (String)"GoalCustomEditor.btnRemoveAll.mnemonic").charAt(0));
        this.btnMoveUp.setMnemonic(NbBundle.getMessage((Class)GoalCustomEditor.class, (String)"GoalCustomEditor.btnMoveUp.mnemonic").charAt(0));
        this.btnMoveDown.setMnemonic(NbBundle.getMessage((Class)GoalCustomEditor.class, (String)"GoalCustomEditor.btnMoveDown.mnemonic").charAt(0));
    }

    public GoalCustomEditor(PropertyEditor editor) {
        this();
        this.editor = editor;
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnEdit = new JButton();
        this.btnRemove = new JButton();
        this.btnRemoveAll = new JButton();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.lblGoals = new JLabel();
        this.spGoals = new JScrollPane();
        this.lstGoals = new JList();
        this.setLayout(new GridBagLayout());
        this.btnAdd.setText(NbBundle.getBundle((Class)GoalCustomEditor.class).getString("GoalCustomEditor.btnAdd.text"));
        this.btnAdd.setActionCommand("Add");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnEdit.setText(NbBundle.getMessage((Class)GoalCustomEditor.class, (String)"GoalCustomEditor.btnEdit.text"));
        this.btnEdit.setActionCommand("Edit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.btnEdit, gridBagConstraints);
        this.btnRemove.setText(NbBundle.getBundle((Class)GoalCustomEditor.class).getString("GoalCustomEditor.btnRemove.text"));
        this.btnRemove.setActionCommand("Remove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.btnRemoveAll.setText(NbBundle.getBundle((Class)GoalCustomEditor.class).getString("GoalCustomEditor.btnRemoveAll.text"));
        this.btnRemoveAll.setActionCommand("RemoveAll");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.btnRemoveAll, gridBagConstraints);
        this.btnMoveUp.setText(NbBundle.getBundle((Class)GoalCustomEditor.class).getString("GoalCustomEditor.btnMoveUp.text"));
        this.btnMoveUp.setActionCommand("MoveUp");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnMoveUp, gridBagConstraints);
        this.btnMoveDown.setText(NbBundle.getBundle((Class)GoalCustomEditor.class).getString("GoalCustomEditor.btnMoveDown.text"));
        this.btnMoveDown.setActionCommand("MoveDown");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.btnMoveDown, gridBagConstraints);
        this.lblGoals.setLabelFor(this.lstGoals);
        this.lblGoals.setText(NbBundle.getBundle((Class)GoalCustomEditor.class).getString("GoalCustomEditor.lblGoals.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 12);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblGoals, gridBagConstraints);
        this.spGoals.setMinimumSize(new Dimension(100, 150));
        this.spGoals.setPreferredSize(new Dimension(200, 200));
        this.spGoals.setViewportView(this.lstGoals);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 12, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.spGoals, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (this.editor != null) {
            DefaultListModel<String> model = new DefaultListModel<String>();
            String[] vals = (String[])this.editor.getValue();
            for (int i = 0; i < vals.length; ++i) {
                model.addElement(vals[i]);
            }
            this.lstGoals.setModel(model);
            model.addListDataListener(new DataListener());
        }
        this.listener = new Listener();
        this.btnAdd.addActionListener(this.listener);
        this.btnEdit.addActionListener(this.listener);
        this.btnRemove.addActionListener(this.listener);
        this.btnRemoveAll.addActionListener(this.listener);
        this.btnMoveUp.addActionListener(this.listener);
        this.btnMoveDown.addActionListener(this.listener);
        this.lstGoals.addListSelectionListener(this.listener);
        this.lstGoals.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                GoalCustomEditor.this.enableRemoveButtons(GoalCustomEditor.this.lstGoals.getSelectedIndex());
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.listener != null) {
            this.btnAdd.removeActionListener(this.listener);
            this.btnRemove.removeActionListener(this.listener);
            this.btnRemoveAll.removeActionListener(this.listener);
            this.lstGoals.removeListSelectionListener(this.listener);
            this.btnMoveUp.removeActionListener(this.listener);
            this.btnMoveDown.removeActionListener(this.listener);
        }
    }

    private void enableRemoveButtons(int selectedIndex) {
        if (selectedIndex == -1) {
            this.btnRemove.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
            this.btnEdit.setEnabled(false);
        } else {
            if (selectedIndex == 0) {
                this.btnMoveUp.setEnabled(false);
            } else {
                this.btnMoveUp.setEnabled(true);
            }
            if (selectedIndex == this.lstGoals.getModel().getSize() - 1) {
                this.btnMoveDown.setEnabled(false);
            } else {
                this.btnMoveDown.setEnabled(true);
            }
            this.btnRemove.setEnabled(true);
            this.btnEdit.setEnabled(true);
        }
    }

    private class DataListener
    implements ListDataListener {
        private DataListener() {
        }

        public void contentsChanged(ListDataEvent e) {
            this.setValue();
        }

        public void intervalAdded(ListDataEvent e) {
            this.setValue();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.setValue();
        }

        private void setValue() {
            DefaultListModel model = (DefaultListModel)GoalCustomEditor.this.lstGoals.getModel();
            Object[] arr = new String[model.size()];
            model.copyInto(arr);
            GoalCustomEditor.this.editor.setValue(arr);
        }
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if ("Add".equals(e.getActionCommand())) {
                String goals = GoalCustomEditor.this.pnlAvailableGoals.getGoalsToExecute();
                if (goals.trim().length() != 0) {
                    DefaultListModel model = (DefaultListModel)GoalCustomEditor.this.lstGoals.getModel();
                    model.addElement(goals);
                }
            } else if ("Edit".equals(e.getActionCommand())) {
                String goals = GoalCustomEditor.this.pnlAvailableGoals.getGoalsToExecute();
                DefaultListModel model = (DefaultListModel)GoalCustomEditor.this.lstGoals.getModel();
                int index = GoalCustomEditor.this.lstGoals.getSelectedIndex();
                if (index >= 0) {
                    model.set(index, goals);
                }
            } else if ("Remove".equals(e.getActionCommand())) {
                DefaultListModel model = (DefaultListModel)GoalCustomEditor.this.lstGoals.getModel();
                int selected = GoalCustomEditor.this.lstGoals.getSelectedIndex();
                Object[] sel = GoalCustomEditor.this.lstGoals.getSelectedValues();
                GoalCustomEditor.this.lstGoals.clearSelection();
                for (int i = 0; i < sel.length; ++i) {
                    model.removeElement(sel[i]);
                }
                if (GoalCustomEditor.this.lstGoals.getModel().getSize() > selected) {
                    GoalCustomEditor.this.lstGoals.setSelectedIndex(selected);
                    GoalCustomEditor.this.lstGoals.grabFocus();
                }
            } else if ("RemoveAll".equals(e.getActionCommand())) {
                DefaultListModel model = (DefaultListModel)GoalCustomEditor.this.lstGoals.getModel();
                GoalCustomEditor.this.lstGoals.clearSelection();
                model.removeAllElements();
            } else if ("MoveUp".equals(e.getActionCommand())) {
                DefaultListModel model = (DefaultListModel)GoalCustomEditor.this.lstGoals.getModel();
                int selected = GoalCustomEditor.this.lstGoals.getSelectedIndex();
                Object obj = model.remove(selected);
                model.insertElementAt(obj, selected - 1);
                GoalCustomEditor.this.lstGoals.setSelectedIndex(selected - 1);
            } else if ("MoveDown".equals(e.getActionCommand())) {
                DefaultListModel model = (DefaultListModel)GoalCustomEditor.this.lstGoals.getModel();
                int selected = GoalCustomEditor.this.lstGoals.getSelectedIndex();
                Object obj = model.remove(selected);
                model.insertElementAt(obj, selected + 1);
                GoalCustomEditor.this.lstGoals.setSelectedIndex(selected + 1);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            GoalCustomEditor.this.enableRemoveButtons(GoalCustomEditor.this.lstGoals.getSelectedIndex());
            if (GoalCustomEditor.this.lstGoals.getSelectedIndex() != -1) {
                String goals = (String)GoalCustomEditor.this.lstGoals.getSelectedValue();
                GoalCustomEditor.this.pnlAvailableGoals.setGoalsToExecute(goals);
            } else {
                GoalCustomEditor.this.pnlAvailableGoals.setGoalsToExecute("");
            }
        }
    }
}

