/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.goals;

import java.util.Collections;
import org.mevenide.goals.grabber.IGoalsGrabber;
import org.mevenide.netbeans.project.goals.GoalNameCookie;
import org.mevenide.netbeans.project.goals.GoalNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class PluginNode
extends AbstractNode
implements GoalNameCookie {
    public PluginNode(String plugin, IGoalsGrabber grabber) {
        super((Children)new PluginChildren(plugin, grabber));
        this.setName(plugin);
        String displayName = plugin;
        if ("Project".equals(grabber.getOrigin(plugin))) {
            displayName = displayName + NbBundle.getMessage((Class)PluginNode.class, (String)"PluginNode.projectSpecific");
        }
        this.setDisplayName(displayName);
        this.setShortDescription(grabber.getDescription(plugin));
        this.setIconBase("org/mevenide/netbeans/project/goals/PluginIcon");
    }

    public Node.Cookie getCookie(Class clazz) {
        if (GoalNameCookie.class.isAssignableFrom(clazz)) {
            return this;
        }
        Node.Cookie retValue = super.getCookie(clazz);
        return retValue;
    }

    public String getGoalName() {
        return this.getName();
    }

    private static class PluginChildren
    extends Children.Keys {
        private IGoalsGrabber grabber;
        private String plugin;

        public PluginChildren(String plug, IGoalsGrabber grab) {
            this.plugin = plug;
            this.grabber = grab;
        }

        public void addNotify() {
            super.addNotify();
            this.setKeys(this.grabber.getGoals(this.plugin));
        }

        protected Node[] createNodes(Object obj) {
            String goal = (String)obj;
            return new Node[]{new GoalNode(this.plugin, this.grabber, goal)};
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
        }
    }
}

