/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.libraries;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.project.dependency.IDependencyResolver;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class RepositorySourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    public SourceForBinaryQuery.Result findSourceRoots(URL url) {
        File jarFile;
        URL binRoot = url;
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        binRoot = FileUtil.getArchiveFile((URL)url);
        FileObject jarFO = URLMapper.findFileObject((URL)binRoot);
        if (jarFO != null && (jarFile = FileUtil.toFile((FileObject)jarFO)) != null) {
            try {
                File groupDir;
                File srcsDir;
                File srcFile;
                IDependencyResolver resolver = DependencyResolverFactory.getFactory().newInstance(jarFile.getAbsolutePath());
                String version = resolver.guessVersion();
                String artifactid = resolver.guessArtifactId();
                String groupid = resolver.guessGroupId();
                String ext = resolver.guessExtension();
                if (version != null && artifactid != null && groupid != null && ext != null && "jar".equals(ext) && (srcFile = new File(srcsDir = new File(groupDir = jarFile.getParentFile().getParentFile(), "src.jars"), jarFile.getName().substring(0, jarFile.getName().length() - ext.length()) + "src.jar")).exists()) {
                    return new SrcResult(srcFile);
                }
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
        return null;
    }

    private class SrcResult
    implements SourceForBinaryQuery.Result {
        private File file;
        private List listeners;

        public SrcResult(File src) {
            this.file = src;
            this.listeners = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public FileObject[] getRoots() {
            if (this.file.exists()) {
                FileObject[] fos = new FileObject[]{FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)this.file))};
                return fos;
            }
            return new FileObject[0];
        }
    }
}

