/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.project.MavenProject;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class CompileAnnotation
extends Annotation
implements PropertyChangeListener,
OutputListener {
    private static final Log logger = LogFactory.getLog((Class)CompileAnnotation.class);
    private static final Set hyperlinks = new WeakSet();
    private boolean dead = false;
    private MavenProject project;
    private File clazzfile;
    private int lineNum;
    private String text;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((CompileAnnotation)it.next()).destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompileAnnotation(MavenProject proj, String clazz, String line, String textAnn) {
        this.clazzfile = new File(clazz + ".java");
        this.project = proj;
        this.text = textAnn;
        try {
            this.lineNum = Integer.parseInt(line);
        }
        catch (NumberFormatException exc) {
            this.lineNum = -1;
        }
        Set set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void outputLineSelected(OutputEvent ev) {
    }

    public void outputLineAction(OutputEvent ev) {
        block10: {
            FileObject file = FileUtil.toFileObject((File)this.clazzfile);
            if (file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null && file == dob.getPrimaryFile()) {
                    if (this.lineNum == -1) {
                        ed.open();
                    } else {
                        ed.openDocument();
                        try {
                            Line l = ed.getLineSet().getOriginal(this.lineNum - 1);
                            if (!l.isDeleted()) {
                                l.show(2);
                            }
                        }
                        catch (IndexOutOfBoundsException ioobe) {
                            ed.open();
                        }
                    }
                    CompileAnnotation.attachAllInFile(ed, this);
                    break block10;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException donfe) {
                logger.warn((Object)"DO not found.", (Throwable)donfe);
            }
            catch (IOException ioe) {
                logger.warn((Object)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachAllInFile(EditorCookie cook, CompileAnnotation annot) {
        HashSet newSet = null;
        Set set = hyperlinks;
        synchronized (set) {
            newSet = new HashSet(hyperlinks);
        }
        Iterator it = newSet.iterator();
        while (it.hasNext()) {
            Line l;
            CompileAnnotation ann = (CompileAnnotation)it.next();
            if (!ann.getFile().equals(annot.getFile()) || ann.getLine() == -1 || (l = cook.getLineSet().getOriginal(ann.getLine() - 1)).isDeleted()) continue;
            ann.attachAsNeeded(l);
        }
    }

    public void outputLineCleared(OutputEvent ev) {
        this.doDetach();
    }

    void destroy() {
        this.doDetach();
        this.dead = true;
    }

    private synchronized void attachAsNeeded(Line l) {
        if (this.getAttachedAnnotatable() == null) {
            Line ann = l;
            this.attach((Annotatable)ann);
            ann.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doDetach() {
        Annotatable ann = this.getAttachedAnnotatable();
        if (ann != null) {
            ann.removePropertyChangeListener((PropertyChangeListener)this);
            this.detach();
        }
        Set set = hyperlinks;
        synchronized (set) {
            hyperlinks.remove(this);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (this.dead) {
            return;
        }
        String prop = ev.getPropertyName();
        if (prop == null || prop.equals("text") || prop.equals("deleted")) {
            this.doDetach();
        }
    }

    public String getAnnotationType() {
        return "org-mevenide-netbeans-project-error";
    }

    public String getShortDescription() {
        return this.text;
    }

    public File getFile() {
        return this.clazzfile;
    }

    public int getLine() {
        return this.lineNum;
    }

    public String toString() {
        return "javaerror[" + this.clazzfile + ":" + this.lineNum + ":" + this.text + "]";
    }
}

