/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.output.FindbugsAnnotation;
import org.mevenide.reports.FindbugsResult;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class FindbugsOutputListenerProvider
extends AbstractOutputProcessor {
    private static Log logger = LogFactory.getLog((Class)FindbugsOutputListenerProvider.class);
    private static final String[] FINDBUGSGOALS = new String[]{"maven-findbugs-plugin:report:"};
    private Pattern failPattern;
    private MavenProject project;
    private boolean workNow;

    public FindbugsOutputListenerProvider(MavenProject proj) {
        this.project = proj;
        this.workNow = false;
        this.failPattern = Pattern.compile(".*\\[findbugs\\] Running FindBugs.*");
    }

    public String[] getWatchedGoals() {
        return FINDBUGSGOALS;
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.isWatchedGoalLine(line)) {
            this.workNow = true;
        }
        if (this.workNow && (match = this.failPattern.matcher(line)).matches()) {
            visitor.setOutputListener(new FindBugsOutputListener(this.project));
            this.workNow = false;
        }
    }

    private static class HtmlLinkListener
    implements OutputListener {
        private String errorId;

        public HtmlLinkListener(String id) {
            this.errorId = id;
        }

        public void outputLineAction(OutputEvent ev) {
            try {
                URL link = new URL("http://findbugs.sourceforge.net/bugDescriptions.html#" + this.errorId);
                HtmlBrowser.URLDisplayer.getDefault().showURL(link);
            }
            catch (MalformedURLException exc) {
                NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
            }
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public void outputLineSelected(OutputEvent ev) {
        }
    }

    private static class FindBugsOutputListener
    implements OutputListener {
        private MavenProject project;

        public FindBugsOutputListener(MavenProject proj) {
            this.project = proj;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            this.openReport();
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openReport() {
            FindbugsResult result = new FindbugsResult(this.project.getContext());
            String title = "Findbugs: " + this.project.getDisplayName();
            try {
                IOProvider.getDefault().getIO(title, false).getOut().reset();
            }
            catch (Exception exc) {
                logger.error((Object)"Exception while resetting output", (Throwable)exc);
            }
            InputOutput io = IOProvider.getDefault().getIO(title, false);
            io.select();
            OutputWriter writer = io.getOut();
            try {
                String[] classes = result.getClassNames();
                File srcRoot = new File(this.project.getSrcDirectory());
                FileObject rootFo = FileUtil.toFileObject((File)srcRoot);
                if (classes.length == 0) {
                    writer.println("No bugs found.");
                } else {
                    writer.println("Number of matched classes: " + classes.length);
                    writer.println(" ");
                }
                for (int i = 0; i < classes.length; ++i) {
                    writer.println(classes[i]);
                    List viols = result.getViolationsForClass(classes[i]);
                    Iterator it = viols.iterator();
                    while (it.hasNext()) {
                        FindbugsResult.Violation v = (FindbugsResult.Violation)it.next();
                        FindbugsAnnotation list = new FindbugsAnnotation(v, rootFo);
                        writer.println("   Line:" + v.getLine() + " " + v.getMessage().trim(), (OutputListener)list);
                        writer.println("                             (View detailed bug description in browser)", (OutputListener)new HtmlLinkListener(v.getType()));
                    }
                    writer.println(" ");
                }
            }
            catch (IOException exc) {
                logger.error((Object)"Exception while writing output", (Throwable)exc);
            }
            finally {
                writer.close();
            }
        }
    }
}

