/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.output.CompileAnnotation;

public class JavaOutputListenerProvider
extends AbstractOutputProcessor {
    private static final Log logger = LogFactory.getLog((Class)JavaOutputListenerProvider.class);
    private static final String[] JAVAGOALS = new String[]{"java:compile:", "test:compile:"};
    private Pattern failPattern = Pattern.compile("\\s*(?:\\[javac\\])?\\s*(.*)\\.java\\:([0-9]*)\\: (.*)");
    private MavenProject project;

    public JavaOutputListenerProvider(MavenProject proj) {
        this.project = proj;
    }

    public String[] getWatchedGoals() {
        return JAVAGOALS;
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.isInWatchedGoals(line) && (match = this.failPattern.matcher(line)).matches()) {
            String clazz = match.group(1);
            String lineNum = match.group(2);
            String text = match.group(3);
            visitor.setOutputListener(new CompileAnnotation(this.project, clazz, lineNum, text), !text.startsWith("warning"));
        }
    }
}

