/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.mevenide.genapp.TemplateInfo;
import org.mevenide.netbeans.project.wizards.CreateProjectPanel;
import org.openide.WizardDescriptor;

public class CreateProjectVisual
extends JPanel
implements DocumentListener {
    private CreateProjectPanel panel;
    private JButton btnBrowse;
    private JSeparator jSeparator1;
    private JLabel lblFolder;
    private JLabel lblGroupId;
    private JLabel lblName;
    private JLabel lblPackageName;
    private JLabel lblProjectDir;
    private JLabel lblProjectName;
    private JLabel lblVersion;
    private JPanel locationContainer;
    private JPanel optionsContainer;
    private JTextField txtFolder;
    private JTextField txtGroupId;
    private JTextField txtName;
    private JTextField txtPackageName;
    private JTextField txtProjectDir;
    private JTextField txtProjectName;
    private JTextField txtVersion;

    public CreateProjectVisual(CreateProjectPanel pnl) {
        this.panel = pnl;
        this.initComponents();
        this.txtProjectName.getDocument().addDocumentListener(this);
        this.txtProjectDir.getDocument().addDocumentListener(this);
        this.setName("Name and Location");
        this.putClientProperty("NewProjectWizard_Title", "New Maven project");
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        return this.validateBasics(wizardDescriptor);
    }

    void read(WizardDescriptor d) {
        TemplateInfo info = (TemplateInfo)d.getProperty("gatemplate");
        String val = (String)d.getProperty("property.artifactid");
        this.txtProjectName.setText(val != null ? val : info.getDefaultValue("artifactid"));
        val = (String)d.getProperty("projectDir");
        this.txtProjectDir.setText(val != null ? val : "");
        val = (String)d.getProperty("property.groupid");
        this.txtGroupId.setText(val != null ? val : info.getDefaultValue("groupid"));
        val = (String)d.getProperty("property.version");
        this.txtVersion.setText(val != null ? val : info.getDefaultValue("version"));
        val = (String)d.getProperty("property.package");
        this.txtPackageName.setText(val != null ? val : info.getDefaultValue("package"));
        val = (String)d.getProperty("property.name");
        this.txtName.setText(val != null ? val : info.getDefaultValue("name"));
    }

    void store(WizardDescriptor d) {
        d.putProperty("artifactID", (Object)this.txtProjectName.getText());
        d.putProperty("projectDir", (Object)this.txtProjectDir.getText());
        d.putProperty("property.artifactid", (Object)this.txtProjectName.getText());
        d.putProperty("property.groupid", (Object)this.txtGroupId.getText());
        d.putProperty("property.package", (Object)this.txtPackageName.getText());
        d.putProperty("property.version", (Object)this.txtVersion.getText());
        d.putProperty("property.name", (Object)this.txtName.getText());
    }

    private void initComponents() {
        this.locationContainer = new JPanel();
        this.lblProjectName = new JLabel();
        this.txtProjectName = new JTextField();
        this.lblProjectDir = new JLabel();
        this.txtProjectDir = new JTextField();
        this.lblFolder = new JLabel();
        this.txtFolder = new JTextField();
        this.btnBrowse = new JButton();
        this.jSeparator1 = new JSeparator();
        this.optionsContainer = new JPanel();
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblPackageName = new JLabel();
        this.txtPackageName = new JTextField();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.setLayout(new GridBagLayout());
        this.locationContainer.setLayout(new GridBagLayout());
        this.lblProjectName.setLabelFor(this.txtProjectName);
        this.lblProjectName.setText("Project (Artifact) ID:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.locationContainer.add((Component)this.lblProjectName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.locationContainer.add((Component)this.txtProjectName, gridBagConstraints);
        this.lblProjectDir.setLabelFor(this.txtProjectDir);
        this.lblProjectDir.setText("Project Location:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.locationContainer.add((Component)this.lblProjectDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.locationContainer.add((Component)this.txtProjectDir, gridBagConstraints);
        this.lblFolder.setLabelFor(this.txtFolder);
        this.lblFolder.setText("Project Folder:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.locationContainer.add((Component)this.lblFolder, gridBagConstraints);
        this.txtFolder.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.locationContainer.add((Component)this.txtFolder, gridBagConstraints);
        this.btnBrowse.setText("Browse...");
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateProjectVisual.this.btnBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.locationContainer.add((Component)this.btnBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.locationContainer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.optionsContainer.setLayout(new GridBagLayout());
        this.lblGroupId.setLabelFor(this.txtGroupId);
        this.lblGroupId.setText("Project Group ID :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.optionsContainer.add((Component)this.lblGroupId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.optionsContainer.add((Component)this.txtGroupId, gridBagConstraints);
        this.lblVersion.setLabelFor(this.txtVersion);
        this.lblVersion.setText("Version :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.optionsContainer.add((Component)this.lblVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.optionsContainer.add((Component)this.txtVersion, gridBagConstraints);
        this.lblPackageName.setLabelFor(this.txtPackageName);
        this.lblPackageName.setText("Package Name :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.optionsContainer.add((Component)this.lblPackageName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.optionsContainer.add((Component)this.txtPackageName, gridBagConstraints);
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText("Project Name :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.optionsContainer.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.optionsContainer.add((Component)this.txtName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.optionsContainer, gridBagConstraints);
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Project Location");
        chooser.setFileSelectionMode(1);
        String path = this.txtProjectDir.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.txtProjectDir.setText(projectDir.getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    public void addNotify() {
        super.addNotify();
        this.txtProjectName.requestFocus();
    }

    boolean validateBasics(WizardDescriptor wizardDescriptor) {
        if (this.txtProjectName.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Name is not valid folder name.");
            return false;
        }
        File destFolder = new File(this.txtFolder.getText());
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Project Folder already exists and is not empty.");
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.txtProjectName.getDocument() || doc == this.txtProjectDir.getDocument()) {
            String projectName = this.txtProjectName.getText();
            String projectFolder = this.txtProjectDir.getText();
            this.txtFolder.setText(projectFolder + File.separatorChar + projectName);
        }
        this.panel.fireChangeEvent();
    }
}

