/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.writer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.customizer.changes.MavenPOMSingleChange;
import org.mevenide.netbeans.api.customizer.changes.MavenPOMTreeChange;
import org.mevenide.netbeans.project.customizer.DependencyPOMChange;
import org.mevenide.project.io.IContentProvider;

public class ChangesContentProvider
implements IContentProvider {
    private static final Log log = LogFactory.getLog((Class)ChangesContentProvider.class);
    private IContentProvider provider;
    private List changes;
    private String path;
    private int location;

    public ChangesContentProvider(IContentProvider origin, List chngs, String pth, int loc) {
        this.provider = origin;
        this.changes = chngs;
        this.path = pth;
        this.location = loc;
    }

    protected IContentProvider createChildContentProvider(IContentProvider origin, String pth) {
        return new ChangesContentProvider(origin, this.changes, pth, this.location);
    }

    public IContentProvider getSubContentProvider(String key) {
        IContentProvider child;
        MavenPOMTreeChange change = this.findSubTreeChange(this.path + "." + key);
        if (change != null) {
            if (change.getOldLocation() == this.location && change.getNewLocation() != this.location) {
                return null;
            }
            if (change.getNewLocation() == this.location) {
                return change.getChangedContent();
            }
        }
        return (child = this.provider.getSubContentProvider(key)) != null ? this.createChildContentProvider(child, this.path + "." + key) : null;
    }

    public String getValue(String key) {
        MavenPOMSingleChange change = this.findChange(this.path + "." + key);
        if (change != null) {
            if (change.getOldLocation() == this.location && change.getNewLocation() != this.location) {
                return null;
            }
            if (change.getNewLocation() == this.location) {
                return change.getNewValue();
            }
        }
        return this.provider.getValue(key);
    }

    public List getSubContentProviderList(String parentKey, String childKey) {
        List orig;
        if ("dependencies".equals(parentKey) && "dependency".equals(childKey)) {
            return this.getDependenciesProviderList();
        }
        MavenPOMTreeChange change = this.findSubTreeChange(this.path + "." + parentKey);
        if (change != null) {
            if (change.getOldLocation() == this.location && change.getNewLocation() != this.location) {
                return null;
            }
            if (change.getNewLocation() == this.location) {
                return change.getChangedContent().getSubContentProviderList(parentKey, childKey);
            }
        }
        if ((orig = this.provider.getSubContentProviderList(parentKey, childKey)) != null) {
            Iterator it = orig.iterator();
            ArrayList<IContentProvider> toReturn = new ArrayList<IContentProvider>();
            while (it.hasNext()) {
                IContentProvider obj = (IContentProvider)it.next();
                toReturn.add(this.createChildContentProvider(obj, this.path + "." + parentKey + "." + childKey));
            }
            return toReturn;
        }
        return null;
    }

    public List getValueList(String parentKey, String childKey) {
        MavenPOMTreeChange change = this.findSubTreeChange(this.path + "." + parentKey);
        if (change != null) {
            if (change.getOldLocation() == this.location && change.getNewLocation() != this.location) {
                return null;
            }
            if (change.getNewLocation() == this.location) {
                return change.getChangedContent().getValueList(parentKey, childKey);
            }
        }
        return this.provider.getValueList(parentKey, childKey);
    }

    public List getProperties() {
        return this.provider.getProperties();
    }

    private MavenPOMSingleChange findChange(String pth) {
        Iterator it = this.changes.iterator();
        while (it.hasNext()) {
            MavenPOMSingleChange pom;
            Object obj = it.next();
            if (!(obj instanceof MavenPOMSingleChange) || !(pom = (MavenPOMSingleChange)obj).getPath().equals(pth)) continue;
            return pom;
        }
        return null;
    }

    private MavenPOMTreeChange findSubTreeChange(String pth) {
        Iterator it = this.changes.iterator();
        while (it.hasNext()) {
            MavenPOMTreeChange pom;
            Object obj = it.next();
            if (!(obj instanceof MavenPOMTreeChange) || !(pom = (MavenPOMTreeChange)obj).getPath().equals(pth)) continue;
            return pom;
        }
        return null;
    }

    private List getDependenciesProviderList() {
        ArrayList<IContentProvider> lst = new ArrayList<IContentProvider>();
        Iterator it = this.changes.iterator();
        while (it.hasNext()) {
            DependencyPOMChange change;
            Object obj = it.next();
            if (!(obj instanceof DependencyPOMChange) || (change = (DependencyPOMChange)obj).getOldLocation() == this.location && change.getNewLocation() != this.location || change.getNewLocation() != this.location) continue;
            lst.add(change.getChangedContent());
        }
        return lst;
    }
}

