/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

class CountNewLinesReader
extends Reader {
    Reader reader;
    static final byte LN_N = 0;
    static final byte LN_R = 1;
    static final byte LN_RN = 2;
    char[] charBuff;
    char[] readBuff;
    int remain;
    int position;
    final int[] newLinesCounts;

    CountNewLinesReader(InputStream is) throws IOException {
        this(is, null);
    }

    CountNewLinesReader(InputStream is, String encoding) throws IOException {
        this.reader = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
        this.position = 0;
        this.newLinesCounts = new int[]{0, 0, 0};
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.charBuff == null) {
            this.readCharBuff();
            this.translateToCharBuff();
        }
        if (this.remain <= 0) {
            return -1;
        }
        int min = Math.min(len, this.remain);
        System.arraycopy(this.charBuff, this.position, cbuf, off, min);
        this.remain -= min;
        this.position += min;
        return min;
    }

    private final void readCharBuff() throws IOException {
        int read;
        char[] tmp = new char[2048];
        ArrayList<char[]> buffs = new ArrayList<char[]>(20);
        while (true) {
            read = this.readFully(tmp);
            buffs.add(tmp);
            if (read < 2048) break;
            tmp = new char[2048];
        }
        int listsize = buffs.size() - 1;
        int size = listsize * 2048 + read;
        this.readBuff = new char[size];
        this.charBuff = new char[size];
        int copy = 0;
        for (int i = 0; i < listsize; ++i) {
            char[] tmp2 = (char[])buffs.get(i);
            System.arraycopy(tmp2, 0, this.readBuff, copy, 2048);
            copy += 2048;
        }
        System.arraycopy(tmp, 0, this.readBuff, copy, read);
    }

    private final int readFully(char[] buff) throws IOException {
        int read = 0;
        int sum = 0;
        while ((sum += (read = this.reader.read(buff, sum, buff.length - sum))) < buff.length && read > 0) {
        }
        return sum + 1;
    }

    final void translateToCharBuff() {
        char c;
        this.position = 0;
        int charBuffPtr = 0;
        int stop = this.readBuff.length - 1;
        int i = 0;
        block8: while (i < stop) {
            c = this.readBuff[i];
            switch (c) {
                case '\n': {
                    this.newLinesCounts[0] = this.newLinesCounts[0] + 1;
                    this.charBuff[charBuffPtr++] = 10;
                    ++i;
                    continue block8;
                }
                case '\r': {
                    char c2 = this.readBuff[i + 1];
                    if (c2 != '\n') {
                        this.newLinesCounts[1] = this.newLinesCounts[1] + 1;
                        ++i;
                    } else {
                        i += 2;
                        this.newLinesCounts[2] = this.newLinesCounts[2] + 1;
                    }
                    this.charBuff[charBuffPtr++] = 10;
                    continue block8;
                }
            }
            this.charBuff[charBuffPtr++] = this.readBuff[i++];
        }
        if (i == stop) {
            c = this.readBuff[i];
            switch (c) {
                case '\n': {
                    this.newLinesCounts[0] = this.newLinesCounts[0] + 1;
                    this.charBuff[charBuffPtr++] = 10;
                    break;
                }
                case '\r': {
                    this.newLinesCounts[1] = this.newLinesCounts[1] + 1;
                    this.charBuff[charBuffPtr++] = 10;
                    break;
                }
                default: {
                    this.charBuff[charBuffPtr++] = this.readBuff[i++];
                }
            }
        }
        this.remain = charBuffPtr;
        this.readBuff = null;
    }

    final int toNewLine(int i) {
        int counter = i;
        int len = this.readBuff.length;
        while (counter < len) {
            char chr;
            if ((chr = this.readBuff[counter++]) != '\r' && chr != '\n') continue;
            --counter;
            break;
        }
        return counter - i;
    }

    public String getNewLineString() {
        if (this.newLinesCounts[0] == this.newLinesCounts[1] && this.newLinesCounts[1] == this.newLinesCounts[2]) {
            String s = System.getProperty("line.separator");
            return s;
        }
        if (this.newLinesCounts[0] > this.newLinesCounts[1]) {
            return this.newLinesCounts[0] > this.newLinesCounts[2] ? "\n" : "\r\n";
        }
        return this.newLinesCounts[1] > this.newLinesCounts[2] ? "\r" : "\r\n";
    }
}

