/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Resource;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.project.io.JarOverrideReader2;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

abstract class AbstractProjectClassPathImpl
implements ClassPathImplementation {
    private static final Log logger = LogFactory.getLog((Class)AbstractProjectClassPathImpl.class);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List resources;
    private MavenProject project;

    protected AbstractProjectClassPathImpl(MavenProject proj) {
        this.project = proj;
        this.project.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                List newValues = AbstractProjectClassPathImpl.this.getPath();
                if (AbstractProjectClassPathImpl.this.hasChanged(AbstractProjectClassPathImpl.this.resources, newValues)) {
                    logger.debug((Object)("fire PROP_RSOURCES-" + AbstractProjectClassPathImpl.this.getClass()));
                    List oldvalue = AbstractProjectClassPathImpl.this.resources;
                    AbstractProjectClassPathImpl.this.resources = newValues;
                    AbstractProjectClassPathImpl.this.support.firePropertyChange("resources", oldvalue, AbstractProjectClassPathImpl.this.resources);
                }
            }
        });
    }

    private boolean hasChanged(List oldValues, List newValues) {
        if (oldValues == null) {
            return newValues != null;
        }
        Iterator it = oldValues.iterator();
        ArrayList nl = new ArrayList();
        if (newValues != null) {
            nl.addAll(newValues);
        }
        while (it.hasNext()) {
            PathResourceImplementation res = (PathResourceImplementation)it.next();
            URL oldUrl = res.getRoots()[0];
            Iterator inner = nl.iterator();
            boolean found = false;
            if (nl.size() == 0) {
                return true;
            }
            while (inner.hasNext()) {
                PathResourceImplementation res2 = (PathResourceImplementation)inner.next();
                URL newUrl = res2.getRoots()[0];
                if (!newUrl.equals(oldUrl)) continue;
                inner.remove();
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return nl.size() != 0;
    }

    protected final MavenProject getMavenProject() {
        return this.project;
    }

    public synchronized List getResources() {
        logger.debug((Object)"getresources");
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    abstract URI[] createPath();

    private List getPath() {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        URI[] pieces = this.createPath();
        for (int i = 0; i < pieces.length; ++i) {
            try {
                URL entry;
                if (pieces[i].toString().toLowerCase().endsWith(".jar")) {
                    entry = FileUtil.getArchiveRoot((URL)pieces[i].toURL());
                } else {
                    entry = pieces[i].toURL();
                    if (!entry.toExternalForm().endsWith("/")) {
                        entry = new URL(entry.toExternalForm() + "/");
                    }
                }
                if (entry == null) continue;
                File checkFile = new File(pieces[i]);
                if (checkFile.exists()) {
                    result.add(ClassPathSupport.createResource((URL)entry));
                    continue;
                }
                logger.debug((Object)("pointing to non-existing resource=" + checkFile));
                continue;
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            logger.debug((Object)("project=" + this.project.getDisplayName() + " adding propchange=" + propertyChangeListener.getClass()));
            this.support.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            logger.debug((Object)("removing propchange=" + propertyChangeListener.getClass()));
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected URI checkOneDependency(Dependency dep) {
        logger.debug((Object)("dependency " + dep.getArtifactId() + " is added to classpath? " + dep.isAddedToClasspath()));
        if (dep.isAddedToClasspath() || dep.getType() == null) {
            URI uri;
            String path = JarOverrideReader2.getInstance().processOverride(dep, this.getMavenProject().getPropertyResolver(), this.getMavenProject().getLocFinder());
            if (path != null) {
                File file = FileUtil.normalizeFile((File)new File(path));
                uri = file.toURI();
            } else {
                uri = FileUtilities.getDependencyURI(dep, this.getMavenProject());
            }
            if (uri != null) {
                return uri;
            }
        }
        return null;
    }

    protected URI checkOneResource(Resource res) {
        String dir = res.getDirectory();
        File file = new File(dir);
        if (!file.exists()) {
            File basedir = FileUtil.toFile((FileObject)this.getMavenProject().getProjectDirectory());
            file = new File(basedir, dir);
        }
        if (file.exists()) {
            file = FileUtil.normalizeFile((File)file);
            return file.toURI();
        }
        return null;
    }
}

