/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.mevenide.netbeans.project.dependencies.RepoElementComparator;
import org.mevenide.repository.RepoPathElement;

public class RepoPathGrouper {
    private RepoPathElement[] elements;

    public RepoPathGrouper(RepoPathElement[] els) {
        this.elements = els;
        RepoPathGrouper.checkEqualPath(els);
    }

    public RepoPathGrouper[] getChildren() throws Exception {
        HashSet<RepoPathGrouper> set = new HashSet<RepoPathGrouper>();
        for (int i = 0; i < this.elements.length; ++i) {
            RepoPathElement[] chil = this.elements[i].getChildren();
            for (int k = 0; k < chil.length; ++k) {
                Iterator it = set.iterator();
                boolean added = false;
                while (it.hasNext()) {
                    RepoPathGrouper gr = (RepoPathGrouper)it.next();
                    if (!gr.addElement(chil[k])) continue;
                    added = true;
                    break;
                }
                if (added) continue;
                set.add(new RepoPathGrouper(new RepoPathElement[]{chil[k]}));
            }
        }
        RepoPathGrouper[] toRet = new RepoPathGrouper[set.size()];
        return set.toArray(toRet);
    }

    private boolean addElement(RepoPathElement newEl) {
        if (this.checkEquals(newEl)) {
            ArrayList<RepoPathElement> col = new ArrayList<RepoPathElement>();
            col.addAll(Arrays.asList(this.elements));
            col.add(newEl);
            RepoPathElement[] newones = new RepoPathElement[this.elements.length + 1];
            this.elements = col.toArray(newones);
            return true;
        }
        return false;
    }

    private boolean checkEquals(RepoPathElement newEl) {
        if (this.elements.length > 0) {
            return 0 == RepoElementComparator.getInstance().compare(this.elements[0], newEl);
        }
        return false;
    }

    private static boolean checkEqualPath(RepoPathElement[] els) {
        if (els.length < 2) {
            return true;
        }
        for (int i = 1; i < els.length; ++i) {
            if (0 == RepoElementComparator.getInstance().compare(els[0], els[i])) continue;
            return false;
        }
        return true;
    }

    public int getLevel() {
        return this.elements[0].getLevel();
    }

    public String getGroupId() {
        return this.elements[0].getGroupId();
    }

    public String getArtifactId() {
        return this.elements[0].getArtifactId();
    }

    public String getVersion() {
        return this.elements[0].getVersion();
    }

    public String getType() {
        return this.elements[0].getType();
    }

    public boolean isLocal() {
        RepoPathElement[] els = this.elements;
        for (int i = 0; i < els.length; ++i) {
            if (els[i].isRemote()) continue;
            return true;
        }
        return false;
    }

    public boolean isRemote() {
        RepoPathElement[] els = this.elements;
        for (int i = 0; i < els.length; ++i) {
            if (!els[i].isRemote()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.elements[0].isLeaf();
    }

    public RepoPathElement[] getElements() {
        return Arrays.asList(this.elements).toArray(new RepoPathElement[this.elements.length]);
    }
}

