/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.mevenide.netbeans.project.MavenProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public class ProjectFilesNode
extends AbstractNode {
    private static String[] labels = new String[]{"Project", "Project's parent", "Project's grandparent", "Project's grandgrandparent"};

    public ProjectFilesNode(MavenProject project) {
        super((Children)new ProjectFilesChildren(project));
        this.setName("projectfiles");
        this.setDisplayName("Project Files");
        this.setIconBase("org/mevenide/netbeans/project/resources/MavenFiles");
    }

    private static class MyFilterNode
    extends FilterNode {
        public MyFilterNode(Node original, String dn) {
            super(original);
            this.disableDelegation(76);
            this.setDisplayName(dn);
        }
    }

    private static class FileWrapper {
        private File loc;
        private String display;

        public FileWrapper(String displayName, File file) {
            this.display = displayName;
            this.loc = file;
        }

        public boolean equals(Object obj) {
            return this.loc.equals(obj);
        }

        public int hashCode() {
            return this.loc.hashCode();
        }

        public File getFile() {
            return this.loc;
        }

        public String getText() {
            return this.display;
        }
    }

    private static class ProjectFilesChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private MavenProject project;

        public ProjectFilesChildren(MavenProject proj) {
            this.project = proj;
        }

        protected Node[] createNodes(Object obj) {
            FileWrapper wrap = (FileWrapper)obj;
            File fil = wrap.getFile();
            FileObject fo = FileUtil.toFileObject((File)fil);
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    MyFilterNode node = new MyFilterNode(dobj.getNodeDelegate().cloneNode(), wrap.getText());
                    return new Node[]{node};
                }
                catch (DataObjectNotFoundException e) {
                    // empty catch block
                }
            }
            return new Node[0];
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.regenerateKeys();
                this.refresh();
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.project.addPropertyChangeListener(this);
            this.regenerateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.project.removePropertyChangeListener(this);
            super.removeNotify();
        }

        private void regenerateKeys() {
            ArrayList<FileWrapper> keys = new ArrayList<FileWrapper>();
            File[] projectFiles = this.project.getContext().getPOMContext().getProjectFiles();
            for (int i = 0; i < projectFiles.length; ++i) {
                String prefix = i < labels.length ? labels[i] : "Some rather grand grandparent";
                File normalized = FileUtil.normalizeFile((File)projectFiles[i]);
                keys.add(new FileWrapper(prefix + " POM file", normalized));
                File parent = normalized.getParentFile();
                keys.add(new FileWrapper(prefix + " properties", new File(parent, "project.properties")));
                keys.add(new FileWrapper(prefix + " build properties", new File(parent, "build.properties")));
            }
            keys.add(new FileWrapper("User build properties", new File(this.project.getContext().getUserDirectory(), "build.properties")));
            this.setKeys(keys);
        }
    }
}

