/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.queries;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class MavenFileOwnerQueryImpl
implements FileOwnerQueryImplementation {
    private static final Log logger = LogFactory.getLog((Class)MavenFileOwnerQueryImpl.class);
    private Set set;
    private Object lock = new Object();
    private List listeners;

    public MavenFileOwnerQueryImpl() {
        logger.debug((Object)"MavenFileOwnerQueryImpl()");
        this.set = new HashSet();
        this.listeners = new ArrayList();
    }

    public static MavenFileOwnerQueryImpl getInstance() {
        Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(FileOwnerQueryImplementation.class));
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof MavenFileOwnerQueryImpl) {
                return (MavenFileOwnerQueryImpl)obj;
            }
            logger.debug((Object)("fileOwnwequeryImpl=" + obj.getClass()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMavenProject(MavenProject project) {
        Object object = this.lock;
        synchronized (object) {
            this.set.add(project);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProject(MavenProject project) {
        Object object = this.lock;
        synchronized (object) {
            this.set.remove(project);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener list) {
        List list2 = this.listeners;
        synchronized (list2) {
            this.listeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener list) {
        List list2 = this.listeners;
        synchronized (list2) {
            this.listeners.remove(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList lst = new ArrayList();
        List list = this.listeners;
        synchronized (list) {
            lst.addAll(this.listeners);
        }
        Iterator it = lst.iterator();
        ChangeEvent event = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener change = (ChangeListener)it.next();
            change.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedProjects() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet(this.set);
        }
    }

    public Project getOwner(URI uri) {
        File file = new File(uri);
        return this.getOwner(file);
    }

    public Project getOwner(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.getOwner(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project getOwner(File file) {
        HashSet currentProjects;
        Object object = this.lock;
        synchronized (object) {
            currentProjects = new HashSet(this.set);
        }
        try {
            IDependencyResolver resolver = DependencyResolverFactory.getFactory().newInstance(file.getAbsolutePath());
            String version = resolver.guessVersion();
            String artifactid = resolver.guessArtifactId();
            String groupid = resolver.guessGroupId();
            Iterator it = currentProjects.iterator();
            while (it.hasNext()) {
                MavenProject project = (MavenProject)it.next();
                org.apache.maven.project.Project proj = project.getOriginalMavenProject();
                IPropertyResolver res = project.getPropertyResolver();
                if (version == null || !"SNAPSHOT".equals(version) && !this.doCompare(version, res.resolveString(proj.getCurrentVersion())) || artifactid == null || !this.doCompare(artifactid, res.resolveString(proj.getArtifactId())) && !this.doCompare(artifactid, res.resolveString(proj.getId())) || groupid == null || !this.doCompare(groupid, res.resolveString(proj.getGroupId())) && !groupid.equals(artifactid)) continue;
                logger.debug((Object)("found project=" + project.getDisplayName()));
                return project;
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Something wrong with resolver.", (Throwable)exc);
        }
        return null;
    }

    private boolean doCompare(String one, String two) {
        if (one == null || two == null) {
            return false;
        }
        return one.trim().equals(two.trim());
    }
}

