/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.exec.DefaultRunConfig;
import org.mevenide.netbeans.project.exec.MavenExecutor;
import org.mevenide.netbeans.project.exec.ProjectRunContext;
import org.mevenide.netbeans.project.exec.RunConfig;
import org.mevenide.netbeans.project.output.AttachDebuggerOutputHook;
import org.mevenide.netbeans.project.output.DefaultOutputProcessorFactory;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.spi.project.ActionProvider;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.InputOutput;

public class ActionProviderImpl
implements ActionProvider {
    private static final Log logger = LogFactory.getLog((Class)ActionProviderImpl.class);
    private static final Properties defaultIDEGoals = new Properties();
    public static final String COMMAND_MULTIPROJECTBUILD = "multiprojectbuild";
    public static final String COMMAND_MULTIPROJECTCLEAN = "multiprojectclean";
    private MavenProject project;
    private static String[] supported;

    public ActionProviderImpl(MavenProject proj) {
        this.project = proj;
    }

    public String[] getSupportedActions() {
        if (this.project.getPropertyResolver().getResolvedValue("maven.netbeans.exec.compile.single") != null) {
            ArrayList<String> arr = new ArrayList<String>(Arrays.asList(supported));
            arr.add("compile.single");
            return arr.toArray(new String[arr.size()]);
        }
        return supported;
    }

    private String getGoalDefForAction(String actionName, Lookup lookup) {
        FileObject[] fos;
        FileObject fo;
        IPropertyResolver res = this.project.getPropertyResolver();
        String key = "maven.netbeans.exec.";
        key = "debug.single".equals(actionName) ? ((fo = FileUtilities.findTestForFile(this.project, (fos = FileUtilities.extractFileObjectsfromLookup(lookup))[0])) == fos[0] ? key + "debug.test.single" : key + "debug.single") : key + actionName;
        String value = res.getResolvedValue(key);
        if (value == null) {
            value = ActionProviderImpl.getDefaultGoalForAction(key);
        }
        return value;
    }

    public static String getDefaultGoalForAction(String key) {
        return defaultIDEGoals.getProperty(key);
    }

    public void invokeAction(String str, Lookup lookup) {
        String goal = this.getGoalDefForAction(str, lookup);
        if (goal != null) {
            int index = goal.indexOf("%TESTCLASS%");
            if (index != -1) {
                FileObject testFile = FileUtilities.findTestForFile(this.project, FileUtilities.extractFileObjectsfromLookup(lookup)[0]);
                String path = this.extractPackageName(testFile, FileUtil.toFileObject((File)new File(this.project.getTestSrcDirectory())));
                if (path != null) {
                    goal = goal.substring(0, index) + path + goal.substring(index + "%TESTCLASS%".length());
                } else {
                    StatusDisplayer.getDefault().setStatusText("Cannot execute Maven goal:" + goal);
                    logger.debug((Object)("cannot execute:" + goal));
                    return;
                }
            }
            if ((index = goal.indexOf("%CLASS%")) != -1) {
                String path = this.extractPackageName(lookup, FileUtil.toFileObject((File)new File(this.project.getSrcDirectory())), false);
                if (path != null) {
                    goal = goal.substring(0, index) + path + goal.substring(index + "%CLASS%".length());
                } else {
                    StatusDisplayer.getDefault().setStatusText("Cannot execute Maven goal:" + goal);
                    logger.debug((Object)("cannot execute:" + goal));
                    return;
                }
            }
            if ("debug".equals(str) || "debug.single".equals(str) || "debug.test.single".equals(str)) {
                String attach = this.project.getPropertyResolver().getResolvedValue("maven.netbeans.debug.attach");
                if (attach == null || "true".equals(attach)) {
                    this.runDebuggedGoal(goal, lookup);
                } else {
                    this.runGoal(goal, lookup);
                }
            } else {
                this.runGoal(goal, lookup);
            }
        } else {
            logger.error((Object)("cannot find the action=" + str));
        }
    }

    private void runDebuggedGoal(String goal, Lookup lookup) {
        String delStr;
        String portStr;
        IPropertyResolver resolv = this.project.getPropertyResolver();
        String host = resolv.getResolvedValue("maven.netbeans.debug.address");
        if (host == null) {
            host = "localhost";
        }
        if ((portStr = resolv.getResolvedValue("maven.netbeans.debug.port")) == null) {
            portStr = "8888";
        }
        if ((delStr = resolv.getResolvedValue("maven.netbeans.debug.delay")) == null) {
            delStr = "5000";
        }
        try {
            int port = Integer.parseInt(portStr);
            int delay = Integer.parseInt(delStr);
            AttachDebuggerOutputHook filter = new AttachDebuggerOutputHook(delay, host, port);
            Set procs = DefaultOutputProcessorFactory.getAllProcessors(this.project);
            procs.add(filter);
            this.runGoal(goal, lookup, procs, null, new DefaultRunConfig());
        }
        catch (NumberFormatException exc) {
            logger.error((Object)"Cannot parse", (Throwable)exc);
        }
    }

    public void runGoal(String goal, Lookup lookup) {
        this.runGoal(goal, lookup, new DefaultRunConfig());
    }

    public void runGoal(String goal, Lookup lookup, RunConfig config) {
        this.runGoal(goal, lookup, DefaultOutputProcessorFactory.getAllProcessors(this.project), null, config);
    }

    private void runGoal(String goal, Lookup lookup, Set processors, InputOutput io, RunConfig config) {
        LifecycleManager.getDefault().saveAll();
        MavenExecutor exec = new MavenExecutor(new ProjectRunContext(this.project), goal, processors, config);
        int meterLoc = this.project.getPropertyLocator().getPropertyLocation("maven.download.meter");
        if (meterLoc == -1 || meterLoc == -2) {
            exec.setDownloadMeter(MavenSettings.getDefault().getDownloader());
        } else {
            exec.setDownloadMeter(this.project.getPropertyResolver().getResolvedValue("maven.download.meter"));
        }
        exec.setCustomInputOutput(io);
        ExecutorTask task = ExecutionEngine.getDefault().execute("Maven", (Runnable)exec, exec.getInputOutput());
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task2) {
                ActionProviderImpl.this.project.firePropertyChange("MavenProject");
            }
        });
    }

    public boolean isActionEnabled(String str, Lookup lookup) {
        if ("test.single".equals(str)) {
            boolean found;
            FileObject[] fos = FileUtilities.extractFileObjectsfromLookup(lookup);
            boolean bl = found = fos != null && fos.length == 1;
            if (found) {
                found = FileUtilities.findTestForFile(this.project, fos[0]) != null;
            }
            return found;
        }
        if ("run.single".equals(str) || "compile.single".equals(str)) {
            FileObject[] fos = this.findSources(lookup);
            return fos != null && fos.length == 1;
        }
        if ("debug.single".equals(str)) {
            boolean found;
            FileObject[] fos = this.findSources(lookup);
            boolean bl = found = fos != null && fos.length == 1;
            if (!found) {
                fos = this.findTestSources(lookup);
                found = fos != null && fos.length == 1;
            }
            return found;
        }
        if ("debug.test.single".equals(str)) {
            boolean found;
            FileObject[] fos = FileUtilities.extractFileObjectsfromLookup(lookup);
            boolean bl = found = fos != null && fos.length == 1;
            if (found) {
                found = FileUtilities.findTestForFile(this.project, fos[0]) != null;
            }
            return found;
        }
        return true;
    }

    private FileObject[] findTestSources(Lookup lookup) {
        FileObject testSrcDir = FileUtil.toFileObject((File)new File(this.project.getTestSrcDirectory()));
        if (testSrcDir != null) {
            FileObject[] files = FileUtilities.findSelectedFiles(lookup, testSrcDir, ".java");
            return files;
        }
        return null;
    }

    private FileObject[] findSources(Lookup lookup) {
        FileObject testSrcDir = FileUtil.toFileObject((File)new File(this.project.getSrcDirectory()));
        if (testSrcDir != null) {
            FileObject[] files = FileUtilities.findSelectedFiles(lookup, testSrcDir, ".java");
            return files;
        }
        return null;
    }

    private String extractPackageName(Lookup lookup, FileObject root, boolean test) {
        FileObject[] fos;
        FileObject[] fileObjectArray = fos = test ? this.findTestSources(lookup) : this.findSources(lookup);
        if (fos != null && fos.length == 1) {
            return this.extractPackageName(fos[0], root);
        }
        return null;
    }

    private String extractPackageName(FileObject fo, FileObject root) {
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
        path = path.replace('/', '.');
        if ((path = path.replace('\\', '.')).endsWith(".java")) {
            path = path.substring(0, path.length() - ".java".length());
        }
        return path;
    }

    public Action createBasicMavenAction(String name, String action) {
        return new BasicAction(name, action);
    }

    public Action createCustomMavenAction(String name, String goal) {
        return new CustomAction(name, goal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream str = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/mevenide/netbeans/project/exec/execdefaults.properties");
        if (str != null) {
            try {
                defaultIDEGoals.load(str);
            }
            catch (IOException exc) {
                logger.error((Object)"cannot read the default props file", (Throwable)exc);
            }
            finally {
                try {
                    str.close();
                }
                catch (IOException exc) {
                    logger.error((Object)"cannot read the default props file2", (Throwable)exc);
                }
            }
        } else {
            logger.error((Object)"cannot read the default props file");
        }
        supported = new String[]{"build", "clean", "rebuild", "javadoc", "test", "test.single", "run", "run.single", "debug", "debug.single", "debug.test.single"};
    }

    private final class CustomAction
    extends AbstractAction {
        private String gls;

        private CustomAction(String name, String goals) {
            this.gls = goals;
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            ActionProviderImpl.this.runGoal(this.gls, ActionProviderImpl.this.project.getLookup());
        }
    }

    private final class BasicAction
    extends AbstractAction {
        private String gls;

        private BasicAction(String name, String goals) {
            this.gls = goals;
            this.putValue("Name", name);
        }

        public void actionPerformed(ActionEvent e) {
            ActionProviderImpl.this.invokeAction(this.gls, ActionProviderImpl.this.project.getLookup());
        }
    }
}

