/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Developer;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.customizer.ListModelPOMChange;
import org.mevenide.netbeans.project.customizer.MultiTextComponentPOMChange;
import org.mevenide.netbeans.project.customizer.ProjectPanel;
import org.mevenide.netbeans.project.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.project.customizer.ui.LocationComboFactory;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;
import org.mevenide.project.io.IContentProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class TeamPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)TeamPanel.class);
    private ProjectValidateObserver valObserver;
    private MultiTextComponentPOMChange currentContDev;
    private Listener listener;
    private MavenProject project;
    private OriginChange ocContDevel;
    private OriginChange ocDummyOC;
    private DefaultListModel developerModel;
    private DefaultListModel contributorModel;
    private ListModelPOMChange changeDevel;
    private ListModelPOMChange changeContrib;
    private ListModelPOMChange currentChange;
    private boolean isResolvingValues = false;
    private boolean initialized;
    private JButton btnAdd;
    private JButton btnLocation;
    private JButton btnRemove;
    private JButton btnView;
    private JComboBox comTeam;
    private JLabel lblEmail;
    private JLabel lblID;
    private JLabel lblName;
    private JLabel lblOrganization;
    private JLabel lblTeam;
    private JLabel lblTimezone;
    private JLabel lblURL;
    private JList lstTeam;
    private JScrollPane spTeam;
    private JTextField txtEmail;
    private JTextField txtID;
    private JTextField txtName;
    private JTextField txtOrganization;
    private JTextField txtTimezone;
    private JTextField txtURL;

    public TeamPanel(MavenProject proj) {
        this.project = proj;
        this.initComponents();
        this.valObserver = null;
        this.setName(NbBundle.getMessage((Class)TeamPanel.class, (String)"TeamPanel.name"));
        this.btnView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String url = TeamPanel.this.txtURL.getText().trim();
                url = TeamPanel.this.project.getPropertyResolver().resolveString(url);
                if (url.startsWith("http://")) {
                    try {
                        URL link = new URL(url);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                    }
                    catch (MalformedURLException exc) {
                        NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
                    }
                }
            }
        });
        this.lstTeam.setSelectionMode(0);
        this.initialized = false;
    }

    private void initComponents() {
        this.lblTeam = new JLabel();
        this.comTeam = new JComboBox();
        this.ocContDevel = LocationComboFactory.createPOMChange(this.project, true);
        this.btnLocation = (JButton)this.ocContDevel.getComponent();
        this.spTeam = new JScrollPane();
        this.lstTeam = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblID = new JLabel();
        this.txtID = new JTextField();
        this.lblEmail = new JLabel();
        this.txtEmail = new JTextField();
        this.lblOrganization = new JLabel();
        this.txtOrganization = new JTextField();
        this.lblURL = new JLabel();
        this.txtURL = new JTextField();
        this.lblTimezone = new JLabel();
        this.txtTimezone = new JTextField();
        this.btnView = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblTeam.setLabelFor(this.lblName);
        this.lblTeam.setText(NbBundle.getMessage((Class)TeamPanel.class, (String)"TeamPanel.lblTeam.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblTeam, gridBagConstraints);
        this.comTeam.setActionCommand("comTeam");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.comTeam, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.btnLocation, gridBagConstraints);
        this.spTeam.setPreferredSize(new Dimension(300, 131));
        this.spTeam.setViewportView(this.lstTeam);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.spTeam, gridBagConstraints);
        this.btnAdd.setText(NbBundle.getMessage((Class)TeamPanel.class, (String)"ListsPanel.btnAdd.text"));
        this.btnAdd.setActionCommand("btnAdd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setText(NbBundle.getMessage((Class)TeamPanel.class, (String)"ListsPanel.btnRemove.text"));
        this.btnRemove.setActionCommand("btnRemove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText(NbBundle.getMessage((Class)TeamPanel.class, (String)"ListsPanel.lblName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtName, gridBagConstraints);
        this.lblID.setLabelFor(this.txtID);
        this.lblID.setText("ID :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.lblID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtID, gridBagConstraints);
        this.lblEmail.setLabelFor(this.txtEmail);
        this.lblEmail.setText("Email :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblEmail, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtEmail, gridBagConstraints);
        this.lblOrganization.setLabelFor(this.txtOrganization);
        this.lblOrganization.setText("Organization :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblOrganization, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtOrganization, gridBagConstraints);
        this.lblURL.setLabelFor(this.txtURL);
        this.lblURL.setText("URL :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtURL, gridBagConstraints);
        this.lblTimezone.setLabelFor(this.txtTimezone);
        this.lblTimezone.setText("TZ :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.lblTimezone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtTimezone, gridBagConstraints);
        this.btnView.setText("View...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 3, 0, 0);
        this.add((Component)this.btnView, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
        this.listener = new Listener();
        this.btnAdd.addActionListener(this.listener);
        this.btnRemove.addActionListener(this.listener);
        this.lstTeam.addListSelectionListener(this.listener);
        this.comTeam.addActionListener(this.listener);
        this.comTeam.setSelectedIndex(0);
        this.txtName.addFocusListener(this.listener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnAdd.removeActionListener(this.listener);
        this.btnRemove.removeActionListener(this.listener);
        this.lstTeam.removeListSelectionListener(this.listener);
        this.comTeam.removeActionListener(this.listener);
        this.txtName.removeFocusListener(this.listener);
    }

    private void populateChangeInstances() {
        MultiTextComponentPOMChange change;
        ArrayList roles;
        HashMap<String, Object> vals;
        Developer mlist;
        Iterator it;
        String key = "pom.developers";
        int location = this.project.getProjectWalker().getLocation(key);
        this.ocDummyOC = LocationComboFactory.createPOMChange(this.project, true);
        ArrayList<MultiTextComponentPOMChange> oldValues = new ArrayList<MultiTextComponentPOMChange>();
        List orig = this.project.getOriginalMavenProject().getDevelopers();
        if (orig != null) {
            it = orig.iterator();
            while (it.hasNext()) {
                mlist = (Developer)it.next();
                vals = new HashMap<String, Object>();
                vals.put("id", mlist.getId());
                vals.put("name", mlist.getName());
                vals.put("email", mlist.getEmail());
                vals.put("organization", mlist.getOrganization());
                vals.put("timezone", mlist.getTimezone());
                vals.put("url", mlist.getUrl());
                roles = new ArrayList();
                if (mlist.getRoles() != null) {
                    roles.addAll(mlist.getRoles());
                }
                vals.put("roles", roles);
                change = new MultiTextComponentPOMChange("pom.developers.developer", vals, location, this.createFieldMap(true), this.ocDummyOC, false);
                oldValues.add(change);
            }
        }
        this.developerModel = new DefaultListModel();
        this.changeDevel = new ListModelPOMChange(key, oldValues, location, this.developerModel, this.ocContDevel, true);
        key = "pom.contributors";
        location = this.project.getProjectWalker().getLocation(key);
        oldValues = new ArrayList();
        orig = this.project.getOriginalMavenProject().getContributors();
        if (orig != null) {
            it = orig.iterator();
            while (it.hasNext()) {
                mlist = (Contributor)it.next();
                vals = new HashMap();
                vals.put("name", mlist.getName());
                vals.put("email", mlist.getEmail());
                vals.put("organization", mlist.getOrganization());
                vals.put("timezone", mlist.getTimezone());
                vals.put("url", mlist.getUrl());
                roles = new ArrayList();
                if (mlist.getRoles() != null) {
                    roles.addAll(mlist.getRoles());
                }
                vals.put("roles", roles);
                change = new MultiTextComponentPOMChange("pom.contributors.contributor", vals, location, this.createFieldMap(false), this.ocDummyOC, false);
                oldValues.add(change);
            }
        }
        this.contributorModel = new DefaultListModel();
        this.changeContrib = new ListModelPOMChange(key, oldValues, location, this.contributorModel, this.ocContDevel, true);
        this.lstTeam.setCellRenderer(new ListRenderer());
        this.changeContrib.startIgnoringChanges();
        this.changeDevel.startIgnoringChanges();
        DefaultComboBoxModel<ComboWrapper> comModel = new DefaultComboBoxModel<ComboWrapper>();
        comModel.addElement(new ComboWrapper("Developers", this.developerModel));
        comModel.addElement(new ComboWrapper("Contributors", this.contributorModel));
        this.comTeam.setModel(comModel);
    }

    private HashMap createFieldMap(boolean isDeveloper) {
        HashMap<String, JTextField> fields = new HashMap<String, JTextField>();
        if (isDeveloper) {
            fields.put("id", this.txtID);
        }
        fields.put("name", this.txtName);
        fields.put("email", this.txtEmail);
        fields.put("organization", this.txtOrganization);
        fields.put("timezone", this.txtTimezone);
        fields.put("url", this.txtURL);
        return fields;
    }

    public void setResolveValues(boolean resolve) {
        this.isResolvingValues = resolve;
        this.resolveOneCont(resolve, this.currentContDev);
        this.btnRemove.setEnabled(false);
    }

    public List getChanges() {
        ArrayList<ListModelPOMChange> toReturn = new ArrayList<ListModelPOMChange>();
        if (this.initialized) {
            MultiTextComponentPOMChange chng;
            int i;
            boolean hasChanged = this.changeDevel.hasChanged();
            if (!hasChanged) {
                for (i = 0; i < this.developerModel.size() && !(hasChanged = (chng = (MultiTextComponentPOMChange)this.developerModel.get(i)).hasChanged()); ++i) {
                }
            }
            if (hasChanged) {
                toReturn.add(this.changeDevel);
            }
            if (!(hasChanged = this.changeContrib.hasChanged())) {
                for (i = 0; i < this.contributorModel.size() && !(hasChanged = (chng = (MultiTextComponentPOMChange)this.contributorModel.get(i)).hasChanged()); ++i) {
                }
            }
            if (hasChanged) {
                toReturn.add(this.changeContrib);
            }
        }
        return toReturn;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    private int doValidateCheck() {
        if (this.txtName.getText().trim().length() == 0) {
            return 1;
        }
        return 0;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        String message = "";
        return message;
    }

    private boolean isDeveloper() {
        return ((ComboWrapper)this.comTeam.getSelectedItem()).getModel() == this.developerModel;
    }

    private void resolveOneCont(boolean resolve, MultiTextComponentPOMChange chng) {
        if (chng != null) {
            if (resolve) {
                IContentProvider prov = this.currentContDev.getChangedContent();
                HashMap<String, String> resolved = new HashMap<String, String>();
                String value = prov.getValue("name");
                if (value != null) {
                    resolved.put("name", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("id")) != null) {
                    resolved.put("id", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("timezone")) != null) {
                    resolved.put("timezone", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("url")) != null) {
                    resolved.put("url", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("email")) != null) {
                    resolved.put("email", this.project.getPropertyResolver().resolveString(value));
                }
                if ((value = prov.getValue("organization")) != null) {
                    resolved.put("organization", this.project.getPropertyResolver().resolveString(value));
                }
                chng.setResolvedValues(resolved);
            } else {
                chng.resetToNonResolvedValue();
            }
        }
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MultiTextComponentPOMChange change = (MultiTextComponentPOMChange)value;
            String name = change.getValueFor("name");
            name = name == null || name.trim().length() == 0 ? (TeamPanel.this.isDeveloper() ? "<Developer with no name>" : "<Contributor with no name>") : TeamPanel.this.project.getPropertyResolver().resolveString(name);
            return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        }
    }

    private class ComboWrapper {
        private String title;
        private DefaultListModel model;

        public ComboWrapper(String tit, DefaultListModel mod) {
            this.title = tit;
            this.model = mod;
        }

        public DefaultListModel getModel() {
            return this.model;
        }

        public String toString() {
            return this.title;
        }
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener,
    FocusListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            DefaultListModel model;
            if ("btnRemove".equals(e.getActionCommand())) {
                int index;
                model = (DefaultListModel)TeamPanel.this.lstTeam.getModel();
                model.removeElementAt(index);
                for (index = TeamPanel.this.lstTeam.getSelectedIndex(); index >= model.size(); --index) {
                }
                if (index > -1) {
                    TeamPanel.this.lstTeam.setSelectedIndex(index);
                }
            }
            if ("btnAdd".equals(e.getActionCommand())) {
                MultiTextComponentPOMChange newOne = new MultiTextComponentPOMChange(TeamPanel.this.isDeveloper() ? "pom.developers.developer" : "pom.contributors.contributor", new HashMap(), TeamPanel.this.currentChange.getOldLocation(), TeamPanel.this.createFieldMap(TeamPanel.this.isDeveloper()), TeamPanel.this.ocDummyOC, false);
                if (TeamPanel.this.currentContDev != null) {
                    TeamPanel.this.currentContDev.detachListeners();
                }
                model = (DefaultListModel)TeamPanel.this.lstTeam.getModel();
                model.addElement(newOne);
                TeamPanel.this.lstTeam.setSelectedValue(newOne, true);
                TeamPanel.this.txtName.requestFocusInWindow();
            }
            if ("comTeam".equals(e.getActionCommand())) {
                DefaultListModel model2;
                if (TeamPanel.this.currentChange != null) {
                    TeamPanel.this.currentChange.startIgnoringChanges();
                }
                if ((model2 = ((ComboWrapper)TeamPanel.this.comTeam.getSelectedItem()).getModel()) == TeamPanel.this.developerModel) {
                    TeamPanel.this.currentChange = TeamPanel.this.changeDevel;
                    TeamPanel.this.lstTeam.setModel(model2);
                    TeamPanel.this.changeDevel.stopIgnoringChanges();
                } else if (model2 == TeamPanel.this.contributorModel) {
                    TeamPanel.this.currentChange = TeamPanel.this.changeContrib;
                    TeamPanel.this.lstTeam.setModel(model2);
                    TeamPanel.this.changeContrib.stopIgnoringChanges();
                }
                if (model2.size() > 0) {
                    TeamPanel.this.lstTeam.setSelectedIndex(0);
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (TeamPanel.this.currentContDev != null) {
                TeamPanel.this.currentContDev.detachListeners();
                TeamPanel.this.txtName.setText("");
                TeamPanel.this.txtURL.setText("");
                TeamPanel.this.txtEmail.setText("");
                TeamPanel.this.txtID.setText("");
                TeamPanel.this.txtOrganization.setText("");
                TeamPanel.this.txtTimezone.setText("");
            }
            TeamPanel.this.lstTeam.repaint();
            if (TeamPanel.this.lstTeam.getSelectedIndex() == -1) {
                TeamPanel.this.currentContDev = null;
                TeamPanel.this.btnRemove.setEnabled(false);
            } else {
                TeamPanel.this.currentContDev = (MultiTextComponentPOMChange)TeamPanel.this.lstTeam.getSelectedValue();
                if (!TeamPanel.this.isDeveloper()) {
                    TeamPanel.this.txtID.setText("");
                    TeamPanel.this.txtID.setEditable(false);
                }
                TeamPanel.this.resolveOneCont(TeamPanel.this.isResolvingValues, TeamPanel.this.currentContDev);
                TeamPanel.this.currentContDev.attachListeners();
                TeamPanel.this.btnRemove.setEnabled(true);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            TeamPanel.this.lstTeam.repaint();
        }
    }
}

