/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.mevenide.netbeans.project.customizer.MavenPropertyChange;
import org.mevenide.netbeans.project.customizer.ui.OriginChange;

public class TextFieldPropertyChange
implements MavenPropertyChange {
    private String key;
    private String value;
    private int location;
    private String newValue;
    private int newLocation;
    private String defaultValue;
    private JTextField field;
    private OriginChange origin;
    private DocListener listener;
    private boolean ignore = false;

    public TextFieldPropertyChange(String keyParam, String oldValue, int oldLocation, JTextField textfield, OriginChange oc, String defVal) {
        this.key = keyParam;
        this.value = oldValue != null ? oldValue : "";
        this.location = oldLocation;
        this.newValue = this.value;
        this.newLocation = oldLocation;
        this.field = textfield;
        this.origin = oc;
        this.defaultValue = defVal;
        this.origin.setInitialLocationID(oldLocation);
        this.field.setText(this.value);
        this.listener = new DocListener();
        this.origin.setChangeObserver(this.listener);
        this.field.getDocument().addDocumentListener(this.listener);
    }

    public void startIgnoringChanges() {
        this.ignore = true;
    }

    public void stopIgnoringChanges() {
        this.field.setText(this.newValue);
        this.origin.setInitialLocationID(this.newLocation);
        this.ignore = false;
    }

    public String getKey() {
        return this.key;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public int getOldLocation() {
        return this.location;
    }

    public String getOldValue() {
        return this.value;
    }

    public boolean hasChanged() {
        return this.newLocation != this.location || !this.getOldValue().equals(this.getNewValue());
    }

    public void setResolvedValue(String resvalue) {
        this.ignore = true;
        this.field.setEditable(false);
        this.origin.getComponent().setEnabled(false);
        this.field.setText(resvalue);
        this.ignore = false;
    }

    public void resetToNonResolvedValue() {
        this.ignore = true;
        this.field.setEditable(true);
        this.origin.getComponent().setEnabled(true);
        this.field.setText(this.newValue);
        this.ignore = false;
    }

    private final class DocListener
    implements DocumentListener,
    OriginChange.ChangeObserver {
        private DocListener() {
        }

        private void update() {
            if (TextFieldPropertyChange.this.ignore) {
                return;
            }
            TextFieldPropertyChange.this.newValue = TextFieldPropertyChange.this.field.getText();
            if (TextFieldPropertyChange.this.origin.getSelectedLocationID() == -1 || TextFieldPropertyChange.this.origin.getSelectedLocationID() == -2) {
                TextFieldPropertyChange.this.origin.setAction(11);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        public void locationChanged() {
            if (TextFieldPropertyChange.this.ignore) {
                return;
            }
            TextFieldPropertyChange.this.newLocation = TextFieldPropertyChange.this.origin.getSelectedLocationID();
            if (TextFieldPropertyChange.this.newLocation < 0) {
                TextFieldPropertyChange.this.ignore = true;
                TextFieldPropertyChange.this.newValue = TextFieldPropertyChange.this.defaultValue == null ? "" : TextFieldPropertyChange.this.defaultValue;
                TextFieldPropertyChange.this.field.setText(TextFieldPropertyChange.this.newValue);
                TextFieldPropertyChange.this.ignore = false;
            }
        }
    }
}

