/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.dependencies;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.customizer.DependencyPOMChange;
import org.mevenide.netbeans.project.dependencies.RepositoryExplorerPanel;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.repository.RepoPathElement;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DependencyEditor
extends JPanel {
    private MavenProject project;
    private Set currentProps;
    private DefaultComboBoxModel comboModel;
    private JButton btnOverride;
    private JButton btnRepo;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lblArtifactId;
    private JLabel lblGroupId;
    private JLabel lblOverride;
    private JLabel lblType;
    private JLabel lblURL;
    private JLabel lblVersion;
    private JLabel lbljar;
    private JTable tblProperties;
    private JTextField txtArtifactId;
    private JTextField txtGroupId;
    private JTextField txtJar;
    private JTextField txtOverride;
    private JTextField txtType;
    private JTextField txtURL;
    private JTextField txtVersion;
    static /* synthetic */ Class class$java$lang$String;

    public DependencyEditor(MavenProject proj, DependencyPOMChange change) {
        this.initComponents();
        this.project = proj;
        IContentProvider content = change.getChangedContent();
        this.assignValue(content, "groupId", this.txtGroupId);
        this.assignValue(content, "artifactId", this.txtArtifactId);
        this.assignValue(content, "version", this.txtVersion);
        this.assignValue(content, "type", this.txtType);
        this.assignValue(content, "jar", this.txtJar);
        this.assignValue(content, "url", this.txtURL);
        List props = content.getProperties();
        this.currentProps = new TreeSet();
        this.comboModel = new DefaultComboBoxModel();
        ArrayList<WrapperRow> tableRows = new ArrayList<WrapperRow>();
        if (props != null) {
            Iterator it = props.iterator();
            while (it.hasNext()) {
                String ent = (String)it.next();
                int index = ent.indexOf(58);
                if (index <= 0) continue;
                String key = ent.substring(0, index);
                this.currentProps.add(key);
                this.comboModel.addElement(key);
                tableRows.add(new WrapperRow(key, ent.substring(index + 1)));
            }
        }
        String[] defaults = MavenSettings.getDefault().getDependencyProperties();
        for (int i = 0; i < defaults.length; ++i) {
            if (this.currentProps.contains(defaults[i])) continue;
            this.comboModel.addElement(defaults[i]);
        }
        JComboBox<Object> comProperty = new JComboBox<Object>();
        comProperty.setModel(this.comboModel);
        comProperty.setRenderer(new MyListRenderer());
        comProperty.setEditable(true);
        this.tblProperties.setModel(new Model(tableRows));
        this.tblProperties.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(comProperty));
        this.tblProperties.setSurrendersFocusOnKeystroke(true);
        this.txtOverride.setVisible(false);
        this.lblOverride.setVisible(false);
        this.btnOverride.setVisible(false);
        this.jSeparator1.setVisible(false);
    }

    private void assignValue(IContentProvider provider, String key, JTextField field) {
        String value = provider.getValue(key);
        field.setText(value == null ? "" : value);
    }

    public HashMap getValues() {
        HashMap<String, String> toRet = new HashMap<String, String>();
        toRet.put("artifactId", this.getValue(this.txtArtifactId));
        toRet.put("groupId", this.getValue(this.txtGroupId));
        toRet.put("version", this.getValue(this.txtVersion));
        toRet.put("jar", this.getValue(this.txtJar));
        toRet.put("url", this.getValue(this.txtURL));
        toRet.put("type", this.getValue(this.txtType));
        return toRet;
    }

    private String getValue(JTextField field) {
        String ret = field.getText();
        if (ret != null && ret.length() == 0) {
            ret = null;
        }
        return ret;
    }

    public HashMap getProperties() {
        HashMap<String, String> toRet = new HashMap<String, String>();
        Collection rows = ((Model)this.tblProperties.getModel()).getRows();
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            WrapperRow row = (WrapperRow)it.next();
            if (row.getKey() == null || row.getKey().length() <= 0 || row.getValue() == null || row.getValue().length() <= 0) continue;
            toRet.put(row.getKey(), row.getValue());
        }
        return toRet;
    }

    private void initComponents() {
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblType = new JLabel();
        this.txtType = new JTextField();
        this.lbljar = new JLabel();
        this.txtJar = new JTextField();
        this.lblURL = new JLabel();
        this.txtURL = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.btnRepo = new JButton();
        this.btnOverride = new JButton();
        this.lblOverride = new JLabel();
        this.txtOverride = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.tblProperties = new JTable();
        this.setLayout(new GridBagLayout());
        this.lblGroupId.setText("Group ID:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblGroupId, gridBagConstraints);
        this.txtGroupId.setPreferredSize(new Dimension(200, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtGroupId, gridBagConstraints);
        this.lblArtifactId.setText("Artifact ID :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblArtifactId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtArtifactId, gridBagConstraints);
        this.lblVersion.setText("Version :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtVersion, gridBagConstraints);
        this.lblType.setText("Type :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtType, gridBagConstraints);
        this.lbljar.setText("Jar :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lbljar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtJar, gridBagConstraints);
        this.lblURL.setText("URL :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.btnRepo.setText("Repository...");
        this.btnRepo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependencyEditor.this.btnRepoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnRepo, gridBagConstraints);
        this.btnOverride.setText("Anywhere...");
        this.btnOverride.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DependencyEditor.this.btnOverrideActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnOverride, gridBagConstraints);
        this.lblOverride.setText("Override :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.lblOverride, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.txtOverride, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(200, 200));
        this.tblProperties.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.tblProperties);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    private void btnOverrideActionPerformed(ActionEvent evt) {
    }

    private void btnRepoActionPerformed(ActionEvent evt) {
        RepoPathElement el;
        RepositoryExplorerPanel panel = new RepositoryExplorerPanel(this.project.getPropertyResolver(), this.project.getLocFinder());
        DialogDescriptor dd = new DialogDescriptor((Object)panel, "Select repository artifact:");
        Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (retVal == DialogDescriptor.OK_OPTION && (el = panel.getSelectedRepoPathElement()) != null) {
            this.txtArtifactId.setText(el.getArtifactId());
            this.txtGroupId.setText(el.getGroupId());
            String vers = el.getVersion();
            if (vers != null) {
                this.txtVersion.setText(vers);
            } else {
                if (el.isLeaf()) {
                    this.txtJar.setText(el.getArtifactId());
                }
                this.txtVersion.setText("");
            }
            this.txtType.setText(el.getType());
        }
    }

    private class WrapperRow {
        private String key;
        private String value;

        public WrapperRow() {
        }

        public WrapperRow(String k, String v) {
            this.key = k;
            this.value = v;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String newkey) {
            this.key = newkey;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String newvalue) {
            this.value = newvalue;
        }
    }

    private class Model
    implements TableModel {
        private List rows;
        private Collection listeners = new ArrayList();

        public Model(List rowlist) {
            this.rows = rowlist;
        }

        public void setValueAt(Object aValue, int row, int column) {
            WrapperRow rw = this.rows.size() == row ? new WrapperRow() : (WrapperRow)this.rows.get(row);
            if (column == 1) {
                rw.setValue(aValue.toString());
            } else {
                String old = (String)this.getValueAt(row, column);
                rw.setKey(aValue.toString());
                if (aValue.toString().length() > 0) {
                    DependencyEditor.this.currentProps.remove(old);
                    DependencyEditor.this.currentProps.add(aValue.toString());
                }
            }
            if (this.rows.size() == row) {
                this.rows.add(rw);
                this.fireTableChanged();
            }
        }

        private void fireTableChanged() {
            TableModelEvent event = new TableModelEvent(this);
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                TableModelListener list = (TableModelListener)it.next();
                list.tableChanged(event);
            }
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Key";
            }
            if (column == 1) {
                return "Value";
            }
            return "XXX";
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = DependencyEditor.class$("java.lang.String")) : class$java$lang$String;
        }

        public Object getValueAt(int row, int column) {
            if (row != this.rows.size()) {
                WrapperRow rowObj = (WrapperRow)this.rows.get(row);
                if (column == 0) {
                    return rowObj.getKey();
                }
                if (column == 1) {
                    return rowObj.getValue();
                }
            }
            return "";
        }

        public int getRowCount() {
            return this.rows.size() + 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.listeners.add(tableModelListener);
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.listeners.remove(tableModelListener);
        }

        public Collection getRows() {
            return this.rows;
        }
    }

    private class MyListRenderer
    extends DefaultListCellRenderer {
        private MyListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component supers = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (supers instanceof JLabel && DependencyEditor.this.currentProps.contains(value)) {
                JLabel lbl = (JLabel)supers;
                lbl.setText("<html><b>" + value.toString() + "</b></html>");
            }
            return supers;
        }
    }
}

