/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.environment.ConfigUtils;
import org.mevenide.genapp.TemplateInfo;
import org.mevenide.netbeans.project.exec.BeanRunContext;
import org.mevenide.netbeans.project.exec.DefaultRunConfig;
import org.mevenide.netbeans.project.exec.MavenExecutor;
import org.mevenide.netbeans.project.wizards.GenAppPropsPanel;
import org.mevenide.netbeans.project.wizards.GenAppTemplatePanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

public class GenAppWizardIterator
implements TemplateWizard.Iterator {
    private static final Log logger = LogFactory.getLog((Class)GenAppWizardIterator.class);
    private static final long serialVersionUID = 13334234343323432L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    public static final String TEMPLATE = "gatemplate";
    public static final String PROPERTY_PREFIX = "property.";

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new GenAppTemplatePanel(), new GenAppPropsPanel()};
    }

    protected String[] createSteps() {
        return new String[]{"Choose GenApp template", "Fill out properties"};
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        HashSet<DataObject> resultSet = new HashSet<DataObject>();
        String dir = (String)wiz.getProperty("projectDir");
        String name = (String)wiz.getProperty("artifactID");
        FileObject dirFo = FileUtil.toFileObject((File)new File(dir));
        if (dirFo == null) {
            throw new IOException("Base Directory doesn't exist");
        }
        FileObject projectDir = dirFo.createFolder(name);
        TemplateInfo info = (TemplateInfo)wiz.getProperty(TEMPLATE);
        String[] params = info.getParameters();
        boolean customTemplateLoc = this.getCustomTemplateLocation() != null;
        String[] add = new String[params.length + (customTemplateLoc ? 3 : 2)];
        add[0] = "genapp";
        add[1] = "-Dmaven.genapp.template=" + info.getName();
        for (int i = 0; i < params.length; ++i) {
            String val = (String)wiz.getProperty(PROPERTY_PREFIX + params[i]);
            if (val == null) {
                val = info.getDefaultValue(params[i]);
            }
            add[i + 2] = "-Dmaven.genapp.template." + params[i] + "=" + val;
        }
        if (customTemplateLoc) {
            add[add.length - 1] = "-Dmaven.genapp.template.dir=" + this.getCustomTemplateLocation().getAbsolutePath();
        }
        BeanRunContext context = new BeanRunContext("GenApp", ConfigUtils.getDefaultLocationFinder().getMavenHome(), FileUtil.toFile((FileObject)projectDir), add);
        MavenExecutor exec = new MavenExecutor(context, "", Collections.EMPTY_SET, new DefaultRunConfig());
        ExecutorTask task = ExecutionEngine.getDefault().execute("Maven", (Runnable)exec, exec.getInputOutput());
        task.waitFinished();
        resultSet.add(DataObject.find((FileObject)projectDir));
        return resultSet;
    }

    public File getCustomTemplateLocation() {
        return null;
    }

    public void initialize(TemplateWizard wiz) {
        FileObject templateFO = Templates.getTemplate((WizardDescriptor)wiz);
        wiz.putProperty("projectDir", (Object)System.getProperty("user.home"));
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        wizard.putProperty("artifactID", null);
        wizard = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("name {0}/{1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

