/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.writer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.mevenide.context.IProjectContext;
import org.mevenide.context.IQueryContext;
import org.mevenide.netbeans.project.MavenProject;
import org.mevenide.netbeans.project.queries.MavenFileOwnerQueryImpl;
import org.mevenide.netbeans.project.writer.CountNewLinesReader;
import org.mevenide.netbeans.project.writer.NbProjectWriter;
import org.mevenide.project.dependency.DependencyMatcher;
import org.mevenide.project.dependency.ExactDependencyReplacer;
import org.mevenide.project.dependency.IDependencyPattern;
import org.mevenide.project.dependency.IDependencyReplacer;
import org.mevenide.project.io.CarefulProjectMarshaller;
import org.mevenide.project.io.ElementContentProvider;
import org.mevenide.project.io.IContentProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.UserQuestionException;

public final class DependencyUpdater {
    private DependencyUpdater() {
    }

    public static void checkOpenedProjects(String artId, String grId, String version, String newArt, String newGrp, String newVersion) throws Exception {
        ExactDependencyReplacer replacer;
        MavenFileOwnerQueryImpl q = MavenFileOwnerQueryImpl.getInstance();
        Set projects = q.getOpenedProjects();
        Iterator it = projects.iterator();
        HashMap<IQueryContext, MavenProject> contextToProjectMap = new HashMap<IQueryContext, MavenProject>();
        while (it.hasNext()) {
            MavenProject proj = (MavenProject)it.next();
            contextToProjectMap.put(proj.getContext(), proj);
        }
        IQueryContext[] contexts = new IQueryContext[contextToProjectMap.size()];
        contexts = contextToProjectMap.keySet().toArray(contexts);
        IQueryContext[] matching = DependencyMatcher.matchingContexts((IQueryContext[])contexts, (IDependencyPattern)(replacer = new ExactDependencyReplacer(artId, grId, version, newArt, newGrp, newVersion)));
        if (matching.length > 0) {
            HashSet projs = new HashSet();
            for (int i = 0; i < matching.length; ++i) {
                projs.add(contextToProjectMap.get(matching[i]));
            }
            JList<Object> lst = new JList<Object>();
            lst.setListData(projs.toArray());
            Object[] buttons = new JButton[]{new JButton("Proceed All"), new JButton("Proceed Selected"), new JButton("Cancel")};
            NotifyDescriptor dd = new NotifyDescriptor((Object)DependencyUpdater.createPanel(lst), "Select Projects to update", 1, 3, buttons, (Object)buttons[0]);
            Object ret = DialogDisplayer.getDefault().notify(dd);
            if (ret == buttons[0]) {
                DependencyUpdater.writePOMs((IDependencyReplacer)replacer, projs);
            }
            if (ret == buttons[1]) {
                Object[] sels = lst.getSelectedValues();
                DependencyUpdater.writePOMs((IDependencyReplacer)replacer, Arrays.asList(sels));
            }
        }
    }

    private static void writePOMs(IDependencyReplacer replacer, Collection projects) throws Exception {
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            IProjectContext context = project.getContext().getPOMContext();
            Element[] roots = context.getRootElementLayers();
            File[] files = context.getProjectFiles();
            Writer writer = null;
            CountNewLinesReader reader = null;
            FileLock lock = null;
            try {
                for (int i = 0; i < files.length; ++i) {
                    ElementContentProvider provider = new ElementContentProvider(roots[i]);
                    provider = DependencyMatcher.replace((IDependencyReplacer)replacer, (IContentProvider)provider);
                    FileObject fo = FileUtil.toFileObject((File)files[i]);
                    reader = new CountNewLinesReader(fo.getInputStream());
                    SAXBuilder builder = new SAXBuilder();
                    Document originalDoc = builder.build((Reader)reader);
                    reader.close();
                    lock = fo.lock();
                    CarefulProjectMarshaller marshall = new CarefulProjectMarshaller(NbProjectWriter.figureOutFormat(roots[i], reader));
                    writer = new OutputStreamWriter(fo.getOutputStream(lock));
                    marshall.marshall(writer, (IContentProvider)provider, originalDoc);
                }
            }
            catch (UserQuestionException exc) {
                throw new IOException("Cannot obtain lock. User interaction required.");
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (lock == null) continue;
                lock.releaseLock();
            }
        }
    }

    private static JPanel createPanel(JList list) {
        JPanel toReturn = new JPanel();
        JLabel jLabel1 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        toReturn.setLayout(new GridBagLayout());
        jLabel1.setText("<html><p>These projects contain the edited project as dependency.</p><p>\nYou can update their dependency definitions automatically.</p></html>");
        jLabel1.setPreferredSize(new Dimension(500, 35));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        toReturn.add((Component)jLabel1, gridBagConstraints);
        jScrollPane1.setViewportView(list);
        list.setCellRenderer(new ProjRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        toReturn.add((Component)jScrollPane1, gridBagConstraints);
        return toReturn;
    }

    private static class ProjRenderer
    extends DefaultListCellRenderer {
        private ProjRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel retValue = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            MavenProject proj = (MavenProject)value;
            retValue.setText(proj.getDisplayName());
            return retValue;
        }
    }
}

