/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.util.FileUtils;
import org.mevenide.environment.ILocationFinder;
import org.mevenide.environment.SysEnvLocationFinder;
import org.mevenide.environment.sysenv.SysEnvProvider;
import org.mevenide.netbeans.project.FileUtilities;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.NbCustomPluginLoaderImpl;
import org.mevenide.netbeans.project.NbSysEnvProvider;
import org.mevenide.netbeans.project.NoMavenHomePanel;
import org.mevenide.netbeans.project.output.CheckstyleAnnotation;
import org.mevenide.netbeans.project.output.CompileAnnotation;
import org.mevenide.netbeans.project.output.FindbugsAnnotation;
import org.mevenide.netbeans.project.output.PmdAnnotation;
import org.mevenide.plugins.ICustomPluginLoader;
import org.mevenide.plugins.PluginInfoFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;

public class MavenModule
extends ModuleInstall {
    private static Log log = LogFactory.getLog((Class)MavenModule.class);
    private static final long serialVersionUID = -485754848837354747L;
    public static final String CURRENT_VERSION = "maven-mevenide-plugin-0.3.jar";

    public void restored() {
        SysEnvLocationFinder.setDefaultSysEnvProvider((SysEnvProvider)new NbSysEnvProvider());
        PluginInfoFactory.getInstance().setCustomLoader((ICustomPluginLoader)new NbCustomPluginLoaderImpl());
    }

    public void uninstalled() {
        PmdAnnotation.detachAllAnnotations();
        CompileAnnotation.detachAllAnnotations();
        CheckstyleAnnotation.detachAllAnnotations();
        FindbugsAnnotation.detachAllAnnotations();
    }

    public static boolean checkMavenHome(ILocationFinder finder) {
        if (finder.getMavenHome() == null) {
            NoMavenHomePanel pnl = new NoMavenHomePanel();
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, "Enter Maven Home");
            Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retVal == NotifyDescriptor.OK_OPTION) {
                File fil;
                String hm = pnl.getMavenHome();
                if (hm == null) {
                    hm = "";
                }
                if ((fil = new File(hm)).exists() && new File(fil, "bin" + File.separator + "forehead.conf").exists()) {
                    MavenSettings.getDefault().setMavenHome(fil.getAbsolutePath());
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static void copyMevenidePlugin(ILocationFinder finder) {
        File home = new File(finder.getMavenHome());
        if (home.exists()) {
            File plugins = new File(home, "plugins");
            File[] files = plugins.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("maven-mevenide-plugin");
                }
            });
            File current = InstalledFileLocator.getDefault().locate("maven-plugins/maven-mevenide-plugin-0.3.jar", null, false);
            if (current == null) {
                log.error((Object)"cannot copy maven-mevenide-plugin - the assumed version is not present -maven-mevenide-plugin-0.3.jar");
                return;
            }
            File cache = new File(finder.getMavenPluginsDir());
            boolean deleteCache = false;
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    String name = files[i].getName();
                    if (name.equals(CURRENT_VERSION)) continue;
                    deleteCache = true;
                    File cached = new File(cache, name = name.substring(0, name.length() - ".jar".length()));
                    if (cached.exists()) {
                        FileUtilities.delete(cached);
                    }
                    files[i].delete();
                }
            }
            File newFile = new File(plugins, CURRENT_VERSION);
            try {
                File cFile;
                FileUtils.newFileUtils().copyFile(current, newFile, null, true);
                if (deleteCache && (cFile = new File(cache, "plugins.cache")).exists()) {
                    FileUtilities.delete(cFile);
                }
            }
            catch (IOException exc) {
                log.error((Object)"cannot copy maven-mevenide-plugin", (Throwable)exc);
            }
        }
    }
}

