/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.apache.maven.project.Dependency;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.changes.MavenPOMTreeChange;
import org.mevenide.project.io.IContentProvider;

public final class DependencyPOMChange
implements MavenPOMTreeChange {
    private String key;
    private Map values;
    private Map propValues;
    private int location;
    private Map newValues;
    private Map newPropValues;
    private int newLocation;
    private Map fields;
    private OriginChange origin;
    private OrigListener orListener;
    private DependencyContentProvider contentProvider;
    private boolean ignore = false;

    private DependencyPOMChange(String keyParam, Map oldValues, int oldLocation, Map textfields, OriginChange oc, Map propOldValues, boolean attachListeners) {
        this.key = keyParam;
        this.values = oldValues;
        this.propValues = propOldValues;
        this.location = oldLocation;
        this.newValues = new HashMap(this.values);
        this.newPropValues = new HashMap(this.propValues);
        this.newLocation = oldLocation;
        this.fields = textfields;
        this.origin = oc;
        this.origin.setInitialLocationID(oldLocation);
        this.orListener = new OrigListener();
        if (attachListeners) {
            this.attachListeners();
        }
        this.contentProvider = new DependencyContentProvider();
    }

    public static DependencyPOMChange createChangeInstance(Dependency dep, int location, Map fieldMap, OriginChange oc, boolean attachListeners) {
        HashMap<String, String> vals = new HashMap<String, String>();
        HashMap props = new HashMap();
        if (dep != null) {
            vals.put("artifactId", dep.getArtifactId());
            vals.put("groupId", dep.getGroupId());
            vals.put("version", dep.getVersion());
            vals.put("type", dep.getType());
            vals.put("jar", dep.getJar());
            vals.put("url", dep.getUrl());
            Map map = dep.resolvedProperties();
            if (map != null) {
                Iterator it2 = map.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry ent = it2.next();
                    if (ent.getValue() == null || ent.getValue().toString().trim().length() <= 0) continue;
                    props.put(ent.getKey(), ent.getValue());
                }
            }
        }
        DependencyPOMChange change = new DependencyPOMChange("pom.dependencies.dependency", vals, location, fieldMap, oc, props, attachListeners);
        return change;
    }

    public void attachListeners() {
        this.origin.setChangeObserver(this.orListener);
    }

    public void detachListeners() {
        this.origin.setChangeObserver(null);
    }

    public void startIgnoringChanges() {
        this.ignore = true;
    }

    public void stopIgnoringChanges() {
        this.origin.getComponent().setEnabled(true);
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            JTextComponent field = (JTextComponent)entry.getValue();
            String val = (String)this.newValues.get(entry.getKey());
            field.setText(val == null ? "" : val);
        }
        this.origin.setInitialLocationID(this.newLocation);
        this.ignore = false;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public int getOldLocation() {
        return this.location;
    }

    public boolean hasChanged() {
        boolean toReturn = this.newLocation != this.location || !this.valuesEqual();
        return toReturn;
    }

    private boolean valuesEqual() {
        boolean equal;
        boolean bl = equal = this.values.keySet().containsAll(this.newValues.keySet()) && this.newValues.keySet().containsAll(this.values.keySet());
        if (equal) {
            Iterator it = this.values.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String oldval = (String)entry.getValue();
                String newval = (String)this.newValues.get(entry.getKey());
                equal = oldval != null && newval != null ? oldval.equals(newval) : false;
                if (equal) continue;
                return false;
            }
        }
        return equal;
    }

    public void setResolvedValues(HashMap resvalues) {
        this.ignore = true;
        this.origin.getComponent().setEnabled(false);
        Iterator it = this.fields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            JTextComponent field = (JTextComponent)ent.getValue();
            field.setEditable(false);
            String val = (String)resvalues.get(ent.getKey());
            field.setText(val != null ? val : "");
        }
        this.ignore = false;
    }

    public void resetToNonResolvedValue() {
        this.startIgnoringChanges();
        this.stopIgnoringChanges();
    }

    public String getPath() {
        return this.key;
    }

    public void setNewValues(HashMap newOnes, HashMap newProps) {
        this.newValues = new HashMap(newOnes);
        this.newPropValues = new HashMap(newProps);
    }

    public HashMap getOldValues() {
        return new HashMap(this.values);
    }

    public HashMap getOldProperties() {
        return new HashMap(this.propValues);
    }

    public IContentProvider getChangedContent() {
        return this.contentProvider;
    }

    private class DependencyContentProvider
    implements IContentProvider {
        public List getProperties() {
            ArrayList<String> toReturn = new ArrayList<String>();
            Iterator it = DependencyPOMChange.this.newPropValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry ent = it.next();
                toReturn.add("" + ent.getKey() + ":" + ent.getValue());
            }
            return toReturn;
        }

        public IContentProvider getSubContentProvider(String keyx) {
            return null;
        }

        public List getSubContentProviderList(String parentKey, String childKey) {
            return null;
        }

        public String getValue(String keyx) {
            return (String)DependencyPOMChange.this.newValues.get(keyx);
        }

        public List getValueList(String parentKey, String childKey) {
            return null;
        }
    }

    private final class OrigListener
    implements OriginChange.ChangeObserver {
        private OrigListener() {
        }

        public void locationChanged() {
            if (DependencyPOMChange.this.ignore) {
                return;
            }
            DependencyPOMChange.this.newLocation = DependencyPOMChange.this.origin.getSelectedLocationID();
            if (DependencyPOMChange.this.newLocation < 0) {
                DependencyPOMChange.this.ignore = true;
                DependencyPOMChange.this.newValues.clear();
                Iterator it = DependencyPOMChange.this.fields.values().iterator();
                while (it.hasNext()) {
                    JTextComponent field = (JTextComponent)it.next();
                    field.setText("");
                }
                DependencyPOMChange.this.ignore = false;
            }
        }
    }
}

