/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import org.apache.maven.project.Repository;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.customizer.changes.MavenChange;
import org.mevenide.netbeans.api.customizer.changes.MultiTextComponentPOMChange;
import org.mevenide.netbeans.api.customizer.changes.TextComponentPOMChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.project.io.IContentProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;

public class RepositoryPanel
extends JPanel
implements ProjectPanel {
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private OriginChange ocGumpID;
    private OriginChange ocRepository;
    private HashMap changes;
    private boolean initialized;
    private JButton btnGumpID;
    private JButton btnRepository;
    private JButton btnURL;
    private JPanel jPanel1;
    private JLabel lblConnection;
    private JLabel lblDevConnection;
    private JLabel lblGumpRepoID;
    private JLabel lblRepository;
    private JLabel lblURL;
    private JPanel pnlRepo;
    private JTextField txtConnection;
    private JTextField txtDevConnection;
    private JTextField txtGumpRepoID;
    private JTextField txtURL;

    public RepositoryPanel(MavenProject proj) {
        this.project = proj;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.setName("Repository");
        this.btnURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                String url = RepositoryPanel.this.txtURL.getText().trim();
                url = RepositoryPanel.this.project.getPropertyResolver().resolveString(url);
                if (url.startsWith("http://")) {
                    try {
                        URL link = new URL(url);
                        HtmlBrowser.URLDisplayer.getDefault().showURL(link);
                    }
                    catch (MalformedURLException exc) {
                        NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)"Is not a valid URL.", 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
                    }
                }
            }
        });
        this.initialized = false;
    }

    private void initComponents() {
        this.ocRepository = LocationComboFactory.createPOMChange(this.project, true);
        this.btnRepository = (JButton)this.ocRepository.getComponent();
        this.pnlRepo = new JPanel();
        this.lblConnection = new JLabel();
        this.txtConnection = new JTextField();
        this.lblURL = new JLabel();
        this.txtURL = new JTextField();
        this.lblDevConnection = new JLabel();
        this.txtDevConnection = new JTextField();
        this.btnURL = new JButton();
        this.lblGumpRepoID = new JLabel();
        this.txtGumpRepoID = new JTextField();
        this.ocGumpID = LocationComboFactory.createPOMChange(this.project, false);
        this.btnGumpID = (JButton)this.ocGumpID.getComponent();
        this.jPanel1 = new JPanel();
        this.lblRepository = new JLabel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 6, 0);
        this.add((Component)this.btnRepository, gridBagConstraints);
        this.pnlRepo.setLayout(new GridBagLayout());
        this.pnlRepo.setBorder(new EtchedBorder(0));
        this.lblConnection.setLabelFor(this.txtConnection);
        this.lblConnection.setText("Connection:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.pnlRepo.add((Component)this.lblConnection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.pnlRepo.add((Component)this.txtConnection, gridBagConstraints);
        this.lblURL.setLabelFor(this.txtURL);
        this.lblURL.setText("URL :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.pnlRepo.add((Component)this.lblURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 6, 0);
        this.pnlRepo.add((Component)this.txtURL, gridBagConstraints);
        this.lblDevConnection.setLabelFor(this.txtDevConnection);
        this.lblDevConnection.setText("Developer Conn:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.pnlRepo.add((Component)this.lblDevConnection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.pnlRepo.add((Component)this.txtDevConnection, gridBagConstraints);
        this.btnURL.setText("View...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 6, 6);
        this.pnlRepo.add((Component)this.btnURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.pnlRepo, gridBagConstraints);
        this.lblGumpRepoID.setLabelFor(this.txtGumpRepoID);
        this.lblGumpRepoID.setText("Gump Repository ID:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.lblGumpRepoID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(6, 3, 0, 0);
        this.add((Component)this.txtGumpRepoID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.btnGumpID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lblRepository.setText("Repository:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lblRepository, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
    }

    private void populateChangeInstances() {
        this.createChangeInstance("gumpRepositoryId", this.txtGumpRepoID, this.ocGumpID);
        Repository repo = this.project.getOriginalMavenProject().getRepository();
        String key = "pom.repository";
        int location = this.project.getProjectWalker().getLocation(key);
        HashMap<String, String> oldValues = new HashMap<String, String>();
        if (repo != null) {
            if (repo.getUrl() != null) {
                oldValues.put("url", repo.getUrl());
            }
            if (repo.getConnection() != null) {
                oldValues.put("connection", repo.getConnection());
            }
            if (repo.getDeveloperConnection() != null) {
                oldValues.put("developerConnection", repo.getDeveloperConnection());
            }
        }
        HashMap<String, JTextField> fields = new HashMap<String, JTextField>();
        fields.put("url", this.txtURL);
        fields.put("connection", this.txtConnection);
        fields.put("developerConnection", this.txtDevConnection);
        this.changes.put(key, new MultiTextComponentPOMChange(key, oldValues, location, fields, this.ocRepository));
    }

    private void createChangeInstance(String propName, JTextField field, OriginChange oc) {
        String key = "pom." + propName;
        String value = this.project.getProjectWalker().getValue(key);
        int location = this.project.getProjectWalker().getLocation(key);
        if (value == null) {
            value = "";
        }
        this.changes.put(key, new TextComponentPOMChange(key, value, location, field, oc));
    }

    public void setResolveValues(boolean resolve) {
        this.assignValue("gumpRepositoryId", resolve);
        MultiTextComponentPOMChange change = (MultiTextComponentPOMChange)this.changes.get("pom.repository");
        if (resolve) {
            IContentProvider prov = change.getChangedContent();
            HashMap<String, String> resolvedvalues = new HashMap<String, String>();
            String val = prov.getValue("url");
            if (val != null) {
                resolvedvalues.put("url", this.project.getPropertyResolver().resolveString(val));
            }
            if ((val = prov.getValue("connection")) != null) {
                resolvedvalues.put("connection", this.project.getPropertyResolver().resolveString(val));
            }
            if ((val = prov.getValue("developerConnection")) != null) {
                resolvedvalues.put("developerConnection", this.project.getPropertyResolver().resolveString(val));
            }
            change.setResolvedValues(resolvedvalues);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    private void assignValue(String actionName, boolean resolve) {
        String key = "pom." + actionName;
        TextComponentPOMChange change = (TextComponentPOMChange)this.changes.get(key);
        if (resolve) {
            String value = this.project.getPropertyResolver().resolveString(change.getNewValue());
            change.setResolvedValue(value);
        } else {
            change.resetToNonResolvedValue();
        }
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public boolean isInValidState() {
        return true;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    public String getValidityMessage() {
        return "";
    }
}

