/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer.ui;

import java.awt.Component;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.changes.MavenPropertyChange;

public class TableRowPropertyChange
implements MavenPropertyChange {
    private String key;
    private String value;
    private int location;
    private String newValue;
    private int newLocation;
    private String defaultValue;
    private OriginChange origin;

    public TableRowPropertyChange(String keyParam, String oldValue, int oldLocation, OriginChange oc, String defVal) {
        this.key = keyParam;
        this.value = oldValue != null ? oldValue : "";
        this.location = oldLocation;
        this.newValue = this.value;
        this.newLocation = oldLocation;
        this.origin = oc;
        this.defaultValue = defVal;
        this.origin.setInitialLocationID(oldLocation);
    }

    Component getOriginComponent() {
        return this.origin.getComponent();
    }

    public void startIgnoringChanges() {
    }

    public void stopIgnoringChanges() {
        this.origin.setInitialLocationID(this.newLocation);
    }

    public String getKey() {
        return this.key;
    }

    public int getNewLocation() {
        return this.newLocation;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public int getOldLocation() {
        return this.location;
    }

    public String getOldValue() {
        return this.value;
    }

    public boolean hasChanged() {
        return this.newLocation != this.location || !this.getOldValue().equals(this.getNewValue());
    }

    public void setResolvedValue(String resvalue) {
        this.origin.getComponent().setEnabled(false);
    }

    public void resetToNonResolvedValue() {
        this.origin.getComponent().setEnabled(true);
    }

    public void setNewValue(String val) {
        this.newValue = val;
        if (this.origin.getSelectedLocationID() == -1 || this.origin.getSelectedLocationID() == -2) {
            this.newLocation = 11;
            this.origin.setAction(11);
        }
    }

    public void setNewLocation(int loc) {
        this.newLocation = loc;
        if (this.newLocation == -2 || this.newLocation == -1) {
            this.newValue = this.defaultValue;
        }
        this.origin.setAction(loc);
    }
}

