/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.exec;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Action;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.OutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.project.exec.MavenExecutor;
import org.mevenide.netbeans.project.exec.RunConfig;
import org.mevenide.netbeans.project.exec.RunContext;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class MavenJavaExecutor
implements Runnable,
Cancellable {
    private static final Log logger = LogFactory.getLog((Class)MavenExecutor.class);
    public static final String FORMAT_MAVEN_HOME = "MAVEN_HOME";
    public static final String FORMAT_GOAL = "goal";
    public static final String FORMAT_OFFLINE = "offline";
    public static final String FORMAT_NOBANNER = "nobanner";
    public static final String FORMAT_DEBUG = "debug";
    public static final String FORMAT_EXCEPTIONS = "exceptions";
    public static final String FORMAT_NONVERBOSE = "nonverbose";
    public static final String FORMAT_DOWNLOADMETER = "downloadmeter";
    private String goal = "dist";
    private String meter = "silent";
    private static final long serialVersionUID = 7564737833872873L;
    private RunContext context;
    private Process proces;
    private String format;
    private InputOutput io;
    private Set processors;
    private RunConfig config;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("maven execution", 3);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$windows$OutputListener;
    static /* synthetic */ Class class$org$openide$windows$OutputWriter;

    public MavenJavaExecutor(RunContext proj, String gl, Set procs, RunConfig conf) {
        this.context = proj;
        this.goal = gl;
        this.processors = procs;
        this.config = conf;
    }

    public void setDownloadMeter(String met) {
        this.meter = met;
    }

    public Process createProcess() throws IOException {
        File execDir = this.context.getExecutionDirectory();
        String[] additionals = this.context.getAdditionalParams();
        HashMap formats = new HashMap(5);
        File mavenHome = this.config.getMavenHome() != null && new File(this.config.getMavenHome()).exists() ? new File(this.config.getMavenHome()) : new File(this.context.getMavenHome());
        JavaPlatform platform = JavaPlatformManager.getDefault().getDefaultPlatform();
        FileObject fo = platform.findTool("java");
        if (fo == null) {
            throw new IOException("Cannot find platform");
        }
        ArrayList<Object> lst = new ArrayList<Object>();
        lst.add(FileUtil.toFile((FileObject)fo).getAbsolutePath());
        String opts = System.getProperty("Env-MAVEN_OPTS");
        if (opts == null) {
            opts = "-Xmx256m";
        }
        lst.add(opts);
        File lib = new File(mavenHome, "lib");
        String forehead = null;
        File[] lbs = lib.listFiles();
        for (int i = 0; i < lbs.length; ++i) {
            if (!lbs[i].getName().startsWith("forehead")) continue;
            forehead = lbs[i].getAbsolutePath();
            break;
        }
        if (forehead == null) {
            throw new IOException("Cannot find forehead");
        }
        lst.add("-classpath");
        lst.add(forehead);
        lst.add("-Dforehead.conf.file=" + new File(mavenHome, "bin" + File.separator + "forehead.conf").getAbsolutePath());
        File toolJar = null;
        ClassPath path = platform.getStandardLibraries();
        FileObject[] roots = path.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            FileObject rfo = FileUtil.getArchiveFile((FileObject)roots[i]);
            if (rfo == null) {
                rfo = roots[i];
            }
            if (rfo.getNameExt().equals("tools.jar")) {
                toolJar = FileUtil.toFile((FileObject)rfo);
                break;
            }
            if (Utilities.getOperatingSystem() != 4096 || !rfo.getNameExt().equals("classes.jar")) continue;
            toolJar = FileUtil.toFile((FileObject)rfo);
            break;
        }
        if (toolJar == null) {
            throw new IOException("Cannot find tools.jar");
        }
        lst.add("-Dtools.jar=" + toolJar.getAbsolutePath());
        lst.add("-Dmaven.home=" + mavenHome.getAbsolutePath());
        String homelocal = this.config.getMavenLocalHome();
        if (homelocal == null) {
            homelocal = System.getProperty("Env-MAVEN_HOME_LOCAL");
        }
        if (homelocal != null) {
            lst.add("-Dmaven.home.local=" + homelocal);
        }
        lst.add("com.werken.forehead.Forehead");
        if (this.config.isOffline()) {
            lst.add("--offline");
        }
        if (this.config.isNoBanner()) {
            lst.add("--nobanner");
        }
        if (this.config.isDebug()) {
            lst.add("-X");
        }
        if (this.config.isExceptions()) {
            lst.add("--exception");
        }
        if (this.config.isNonverbose()) {
            lst.add("--quiet");
        }
        if (!this.config.isOffline() && !"default".equals(this.meter)) {
            lst.add("-Dmaven.download.meter=" + this.meter);
        }
        if (additionals.length > 0) {
            lst.addAll(Arrays.asList(additionals));
        } else {
            StringTokenizer st = new StringTokenizer(this.goal, " ");
            while (st.hasMoreElements()) {
                lst.add(st.nextElement());
            }
        }
        String[] prcs = new String[lst.size()];
        prcs = lst.toArray(prcs);
        Process proc = Runtime.getRuntime().exec(prcs, null, execDir);
        return proc;
    }

    private String[] createEnvironment() {
        HashMap<String, String> envMap = new HashMap<String, String>();
        Properties props = System.getProperties();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith("Env-")) continue;
            envMap.put(key.substring("Env-".length()), props.getProperty(key));
        }
        ArrayList<String> toRet = new ArrayList<String>();
        Iterator it = envMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String val = "" + entry.getKey() + "=" + entry.getValue();
            System.out.println("  " + val);
            toRet.add(val);
        }
        return toRet.toArray(new String[toRet.size()]);
    }

    private InputOutput createInputOutput() {
        InputOutput newio = IOProvider.getDefault().getIO(this.context.getExecutionName(), false);
        newio.setErrSeparated(false);
        try {
            newio.getOut().reset();
        }
        catch (IOException exc) {
            logger.error((Object)"Cannot reset InputOutput", (Throwable)exc);
        }
        return newio;
    }

    public InputOutput getInputOutput() {
        if (this.io == null) {
            this.io = this.createInputOutput();
        }
        return this.io;
    }

    public void setCustomInputOutput(InputOutput inout) {
        this.io = inout;
    }

    public void run() {
        try {
            this.proces = this.createProcess();
            InputOutput ioput = this.getInputOutput();
            OutputProcessor[] providers = new OutputProcessor[this.processors.size()];
            providers = this.processors.toArray(providers);
            Output out = new Output(this.proces.getInputStream(), ioput.getOut(), providers);
            Output err = new Output(this.proces.getErrorStream(), ioput.getErr(), providers);
            RequestProcessor.Task outTask = PROCESSOR.post((Runnable)out);
            RequestProcessor.Task errTask = PROCESSOR.post((Runnable)err);
            this.proces.waitFor();
            outTask.waitFinished();
            errTask.waitFinished();
            if (out.wasSuccessfull()) {
                ArrayList succActions = new ArrayList();
                succActions.addAll(out.getSuccessActions() != null ? out.getSuccessActions() : Collections.EMPTY_LIST);
                succActions.addAll(err.getSuccessActions() != null ? err.getSuccessActions() : Collections.EMPTY_LIST);
                if (succActions.size() > 0) {
                    Action action = null;
                    if (succActions.size() == 1) {
                        action = (Action)succActions.iterator().next();
                    } else {
                        int maxPriotity = -1;
                        Iterator it = succActions.iterator();
                        while (it.hasNext()) {
                            Action act = (Action)it.next();
                            Integer priority = (Integer)act.getValue("Priority");
                            if (priority <= maxPriotity) continue;
                            action = act;
                            maxPriotity = priority;
                        }
                    }
                    String question = (String)action.getValue("Question");
                    String title = (String)action.getValue("ShortDescription");
                    if (question != null) {
                        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)question, title == null ? "" : title, 2, 3);
                        Object returned = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        if (NotifyDescriptor.OK_OPTION.equals(returned)) {
                            action.actionPerformed(new ActionEvent(this, 1001, "Performed"));
                        }
                    } else {
                        action.actionPerformed(new ActionEvent(this, 1001, "Performed"));
                    }
                }
            }
        }
        catch (IOException ioexc) {
            ErrorManager.getDefault().notify((Throwable)ioexc);
        }
        catch (InterruptedException exc) {
            ErrorManager.getDefault().notify(1, (Throwable)exc);
            this.cancel();
        }
        catch (ThreadDeath death) {
            this.cancel();
            throw death;
        }
    }

    public boolean cancel() {
        if (this.proces != null) {
            System.err.println("**User cancelled execution**");
            this.proces.destroy();
        }
        return true;
    }

    private static class Output
    implements Runnable {
        private InputStream str;
        private OutputWriter writer;
        private OutputProcessor[] providers;
        private List successActions;
        private boolean success = false;
        private boolean failed = false;

        public Output(InputStream instream, OutputWriter out, OutputProcessor[] provs) {
            this.str = instream;
            this.writer = out;
            this.providers = provs;
            this.successActions = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader read = new BufferedReader(new InputStreamReader(this.str), 50);
            OutputVisitor visitor = new OutputVisitor();
            Method method = null;
            try {
                Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MavenJavaExecutor.class$("java.lang.String")) : class$java$lang$String, class$org$openide$windows$OutputListener == null ? (class$org$openide$windows$OutputListener = MavenJavaExecutor.class$("org.openide.windows.OutputListener")) : class$org$openide$windows$OutputListener, Boolean.TYPE};
                method = (class$org$openide$windows$OutputWriter == null ? (class$org$openide$windows$OutputWriter = MavenJavaExecutor.class$("org.openide.windows.OutputWriter")) : class$org$openide$windows$OutputWriter).getMethod("println", params);
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                String line;
                while ((line = read.readLine()) != null) {
                    if (line.equals("BUILD SUCCESSFUL")) {
                        this.success = true;
                    }
                    if (line.equals("BUILD FAILED")) {
                        this.failed = true;
                    }
                    visitor.resetVisitor();
                    if (this.providers != null) {
                        for (int i = 0; i < this.providers.length; ++i) {
                            this.providers[i].processLine(line, visitor);
                        }
                    }
                    if (visitor.getOutputListener() == null) {
                        this.writer.println(line);
                    } else if (method != null) {
                        try {
                            Object[] objs = new Object[]{line, visitor.getOutputListener(), visitor.isImportant()};
                            method.invoke((Object)this.writer, objs);
                        }
                        catch (Exception exc) {
                            logger.error((Object)"Error while doing reflection", (Throwable)exc);
                        }
                    } else {
                        this.writer.println(line, visitor.getOutputListener());
                    }
                    if (visitor.getSuccessAction() != null) {
                        this.successActions.add(visitor.getSuccessAction());
                    }
                    this.writer.flush();
                }
                read.close();
            }
            catch (IOException ioexc) {
                logger.error((Object)ioexc);
            }
            finally {
                try {
                    read.close();
                    this.writer.close();
                }
                catch (IOException ioexc) {
                    logger.error((Object)ioexc);
                }
            }
        }

        public List getSuccessActions() {
            return this.successActions;
        }

        public boolean wasSuccessfull() {
            return this.success;
        }

        public boolean wasFailed() {
            return this.failed;
        }
    }
}

