/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.libraries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.project.dependency.IDependencyResolver;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class RepositoryJavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    private static final Log logger = LogFactory.getLog((Class)RepositoryJavadocForBinaryQueryImpl.class);

    public JavadocForBinaryQuery.Result findJavadoc(URL url) {
        File jarFile;
        logger.debug((Object)("checkurl=" + url));
        URL binRoot = url;
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        binRoot = FileUtil.getArchiveFile((URL)url);
        FileObject jarFO = URLMapper.findFileObject((URL)binRoot);
        if (jarFO != null && (jarFile = FileUtil.toFile((FileObject)jarFO)) != null) {
            try {
                IDependencyResolver resolver = DependencyResolverFactory.getFactory().newInstance(jarFile.getAbsolutePath());
                String version = resolver.guessVersion();
                String artifactid = resolver.guessArtifactId();
                String groupid = resolver.guessGroupId();
                String ext = resolver.guessExtension();
                if (version != null && artifactid != null && groupid != null && ext != null && "jar".equals(ext)) {
                    File groupDir = jarFile.getParentFile().getParentFile();
                    File javadocsDir = new File(groupDir, "javadoc.jars");
                    File javadocFile = new File(javadocsDir, jarFile.getName().substring(0, jarFile.getName().length() - ext.length()) + "javadoc.jar");
                    if (javadocFile.exists()) {
                        return new DocResult(javadocFile);
                    }
                    javadocsDir = new File(groupDir, "javadocs");
                    javadocFile = new File(javadocsDir, jarFile.getName().substring(0, jarFile.getName().length() - ext.length()) + "javadoc");
                    if (javadocFile.exists()) {
                        return new DocResult(javadocFile);
                    }
                }
            }
            catch (Exception exc) {
                logger.debug((Object)"exception", (Throwable)exc);
            }
        }
        return null;
    }

    private class DocResult
    implements JavadocForBinaryQuery.Result {
        private File file;
        private List listeners;

        public DocResult(File javadoc) {
            this.file = javadoc;
            this.listeners = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public URL[] getRoots() {
            if (this.file.exists()) {
                try {
                    URL[] url = new URL[]{FileUtil.getArchiveRoot((URL)this.file.toURI().toURL())};
                    return url;
                }
                catch (MalformedURLException exc) {
                    logger.debug((Object)"exception", (Throwable)exc);
                }
            }
            return new URL[0];
        }
    }
}

