/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.customizer.DependencyPOMChange;
import org.mevenide.netbeans.project.dependencies.DependencyEditor;
import org.mevenide.netbeans.project.dependencies.DependencyNode;
import org.mevenide.netbeans.project.dependencies.RepositoryUtilities;
import org.mevenide.netbeans.project.writer.NbProjectWriter;
import org.mevenide.project.io.IContentProvider;
import org.mevenide.repository.IRepositoryReader;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

class DependenciesNode
extends AbstractNode {
    private MavenProject project;

    DependenciesNode(MavenProject mavproject) {
        super((Children)new DependenciesChildren(mavproject));
        this.setName("Dependencies");
        this.setDisplayName("Dependencies");
        this.project = mavproject;
        this.setIconBase("org/mevenide/netbeans/project/resources/defaultFolder");
    }

    public Image getIcon(int param) {
        Image retValue = super.getIcon(param);
        retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/libraries-badge.png"), (int)8, (int)8);
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = super.getOpenedIcon(param);
        retValue = Utilities.mergeImages((Image)retValue, (Image)Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/libraries-badge.png"), (int)8, (int)8);
        return retValue;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new AddDependencyAction(), null, new DownloadAction(), new DownloadJavadocSrcAction()};
    }

    private MavenProject getProject() {
        return this.project;
    }

    private class DownloadJavadocSrcAction
    extends AbstractAction {
        public DownloadJavadocSrcAction() {
            this.putValue("Name", "Check repository(ies) for javadoc and sources");
        }

        public void actionPerformed(ActionEvent evnt) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ArrayList lst = new ArrayList(((DependenciesChildren)DependenciesNode.this.getChildren()).deps);
                    Iterator it = lst.iterator();
                    boolean atLeastOneDownloaded = false;
                    while (it.hasNext()) {
                        boolean downloaded;
                        DependencyPOMChange change = (DependencyPOMChange)it.next();
                        IRepositoryReader[] readers = RepositoryUtilities.createRemoteReaders(DependenciesNode.this.project.getPropertyResolver());
                        Dependency dep = DependencyNode.createDependencySnapshot(change.getChangedContent(), DependenciesNode.this.project.getPropertyResolver());
                        try {
                            dep.setType("javadoc.jar");
                            downloaded = RepositoryUtilities.downloadArtifact(readers, DependenciesNode.this.project, dep);
                            if (downloaded) {
                                atLeastOneDownloaded = true;
                            }
                        }
                        catch (FileNotFoundException e) {
                            StatusDisplayer.getDefault().setStatusText(dep.getArtifact() + " is not available in repote repositories.");
                        }
                        catch (Exception exc) {
                            StatusDisplayer.getDefault().setStatusText("Error downloading " + dep.getArtifact() + " : " + exc.getLocalizedMessage());
                        }
                        try {
                            dep.setType("src.jar");
                            downloaded = RepositoryUtilities.downloadArtifact(readers, DependenciesNode.this.project, dep);
                            if (!downloaded) continue;
                            atLeastOneDownloaded = true;
                        }
                        catch (FileNotFoundException e) {
                            StatusDisplayer.getDefault().setStatusText(dep.getArtifact() + " is not available in repote repositories.");
                        }
                        catch (Exception exc) {
                            StatusDisplayer.getDefault().setStatusText("Error downloading " + dep.getArtifact() + " : " + exc.getLocalizedMessage());
                        }
                    }
                    if (atLeastOneDownloaded) {
                        DependenciesNode.this.project.firePropertyChange("MavenProject");
                    }
                }
            });
        }
    }

    private class DownloadAction
    extends AbstractAction {
        public DownloadAction() {
            this.putValue("Name", "Download missing dependencies");
        }

        public void actionPerformed(ActionEvent evnt) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ArrayList lst = new ArrayList(((DependenciesChildren)DependenciesNode.this.getChildren()).deps);
                    Iterator it = lst.iterator();
                    boolean atLeastOneDownloaded = false;
                    while (it.hasNext()) {
                        DependencyPOMChange change = (DependencyPOMChange)it.next();
                        IRepositoryReader[] readers = RepositoryUtilities.createRemoteReaders(DependenciesNode.this.project.getPropertyResolver());
                        Dependency dep = DependencyNode.createDependencySnapshot(change.getChangedContent(), DependenciesNode.this.project.getPropertyResolver());
                        try {
                            boolean downloaded = RepositoryUtilities.downloadArtifact(readers, DependenciesNode.this.project, dep);
                            if (!downloaded) continue;
                            atLeastOneDownloaded = true;
                        }
                        catch (FileNotFoundException e) {
                            StatusDisplayer.getDefault().setStatusText(dep.getArtifact() + " is not available in repote repositories.");
                        }
                        catch (Exception exc) {
                            StatusDisplayer.getDefault().setStatusText("Error downloading " + dep.getArtifact() + " : " + exc.getLocalizedMessage());
                        }
                    }
                    if (atLeastOneDownloaded) {
                        DependenciesNode.this.project.firePropertyChange("MavenProject");
                    }
                }
            });
        }
    }

    private class AddDependencyAction
    extends AbstractAction {
        public AddDependencyAction() {
            this.putValue("Name", "Add Dependency...");
        }

        public void actionPerformed(ActionEvent event) {
            DependencyPOMChange change = DependencyPOMChange.createChangeInstance(null, 0, new HashMap(), LocationComboFactory.createPOMChange(DependenciesNode.this.project, false), false);
            DependencyEditor ed = new DependencyEditor(DependenciesNode.this.project, change);
            DialogDescriptor dd = new DialogDescriptor((Object)ed, "Add Dependency");
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (ret == NotifyDescriptor.OK_OPTION) {
                HashMap props = ed.getProperties();
                MavenSettings.getDefault().checkDependencyProperties(props.keySet());
                change.setNewValues(ed.getValues(), props);
                IContentProvider pr = change.getChangedContent();
                String artifactId = pr.getValue("artifactId");
                String groupId = pr.getValue("groupId");
                String type = pr.getValue("type");
                ArrayList<DependencyPOMChange> changes = new ArrayList<DependencyPOMChange>();
                changes.addAll(((DependenciesChildren)DependenciesNode.this.getChildren()).deps);
                Iterator it = changes.iterator();
                boolean reused = false;
                while (it.hasNext()) {
                    DependencyPOMChange element = (DependencyPOMChange)it.next();
                    IContentProvider prov = element.getChangedContent();
                    String depArtifactId = prov.getValue("artifactId");
                    String depGroupId = prov.getValue("groupId");
                    String depId = prov.getValue("id");
                    String depType = prov.getValue("type");
                    if ((!artifactId.equals(depArtifactId) || !groupId.equals(depGroupId)) && (!artifactId.equals(groupId) || !artifactId.equals(depId)) || !type.equals(depType) && (!type.equals("jar") || depType != null)) continue;
                    NotifyDescriptor.Confirmation d2 = new NotifyDescriptor.Confirmation((Object)("The project already has a dependency with '" + groupId + ":" + artifactId + "' id. Replace it?"), "Dependency conflict", 0, 3);
                    Object ret2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)d2);
                    if (ret2 != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                    element.setNewValues(ed.getValues(), props);
                    reused = true;
                }
                if (!reused) {
                    changes.add(change);
                }
                try {
                    NbProjectWriter writer = new NbProjectWriter(DependenciesNode.this.project);
                    writer.applyChanges(changes);
                }
                catch (Exception exc) {
                    ErrorManager.getDefault().notify(256, (Throwable)exc);
                }
            }
        }
    }

    private static class DependenciesChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private MavenProject project;
        private List deps;

        public DependenciesChildren(MavenProject proj) {
            this.project = proj;
        }

        protected Node[] createNodes(Object obj) {
            DependencyPOMChange combo = (DependencyPOMChange)obj;
            Lookup look = Lookups.fixed((Object[])new Object[]{combo, this.project, this.deps});
            return new Node[]{new DependencyNode(look, true)};
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.regenerateKeys();
                this.refresh();
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.project.addPropertyChangeListener(this);
            this.regenerateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.project.removePropertyChangeListener(this);
            super.removeNotify();
        }

        private void regenerateKeys() {
            Project[] projs = this.project.getContext().getPOMContext().getProjectLayers();
            this.deps = new ArrayList();
            for (int i = 0; i < projs.length; ++i) {
                List ones = projs[i].getDependencies();
                if (ones == null) continue;
                Iterator it = ones.iterator();
                while (it.hasNext()) {
                    Dependency dep = (Dependency)it.next();
                    this.deps.add(DependencyPOMChange.createChangeInstance(dep, i, new HashMap(), LocationComboFactory.createPOMChange(this.project, false), false));
                }
            }
            this.setKeys(this.deps);
        }
    }
}

