/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Resource;
import org.apache.tools.ant.DirectoryScanner;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class DirScannerSubClass
extends DirectoryScanner {
    private static Log logger = LogFactory.getLog((Class)DirScannerSubClass.class);

    public static String[] getDefaultExcludesHack() {
        return DEFAULTEXCLUDES;
    }

    public static boolean checkIncluded(FileObject file, FileObject rootFile, String includes, String excludes) {
        ArrayList<String> includeList = new ArrayList<String>();
        if (includes != null) {
            StringTokenizer tok = new StringTokenizer(includes, " ,", false);
            while (tok.hasMoreTokens()) {
                includeList.add(tok.nextToken());
            }
        }
        ArrayList<String> excludeList = new ArrayList<String>();
        if (excludes != null) {
            StringTokenizer tok = new StringTokenizer(excludes, " ,", false);
            while (tok.hasMoreTokens()) {
                excludeList.add(tok.nextToken());
            }
        }
        return DirScannerSubClass.checkIncludedImpl(file, rootFile, includeList, excludeList);
    }

    public static boolean checkIncluded(FileObject file, FileObject rootFile, Resource resource) {
        logger.debug((Object)"chceckIncluded");
        return DirScannerSubClass.checkIncludedImpl(file, rootFile, resource.getIncludes(), resource.getExcludes());
    }

    static boolean checkIncludedImpl(FileObject file, FileObject rootFile, List includes, List excludes) {
        String pattern;
        Iterator it;
        String relPath = "";
        relPath = FileUtil.getRelativePath((FileObject)rootFile, (FileObject)file);
        boolean doInclude = false;
        if (includes != null && includes.size() != 0) {
            it = includes.iterator();
            while (it.hasNext()) {
                pattern = (String)it.next();
                logger.debug((Object)("include=" + pattern));
                if (pattern.equals(relPath) || DirectoryScanner.match((String)pattern, (String)relPath)) {
                    doInclude = true;
                } else {
                    String dirPath;
                    int lastSlash;
                    if (!file.isFolder() || (lastSlash = pattern.lastIndexOf("/")) <= -1 || !(dirPath = pattern.substring(0, lastSlash)).startsWith(relPath) && !DirectoryScanner.match((String)dirPath, (String)relPath)) continue;
                    doInclude = true;
                }
                break;
            }
        } else {
            String pattern2 = "**";
            if (pattern2.equals(relPath) || DirectoryScanner.match((String)pattern2, (String)relPath)) {
                doInclude = true;
            }
        }
        if (!doInclude) {
            logger.debug((Object)"do not include");
            return false;
        }
        if (excludes != null) {
            it = excludes.iterator();
            while (it.hasNext()) {
                pattern = (String)it.next();
                logger.debug((Object)("exclude=" + pattern));
                if (!pattern.equals(relPath) && !DirectoryScanner.match((String)pattern, (String)relPath)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkVisible(File file, File rootFile) {
        String relPath = file.getAbsolutePath().replace('\\', '/');
        String[] defaults = DirScannerSubClass.getDefaultExcludesHack();
        if (defaults != null) {
            for (int i = 0; i < defaults.length; ++i) {
                if (!DirectoryScanner.match((String)defaults[i], (String)relPath)) continue;
                return false;
            }
        }
        return true;
    }
}

